/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.search;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.lang.search.RubyParamDefSearchTextProvider;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public final class RailsAssetViewParamDefSearchTextProvider
implements RubyParamDefSearchTextProvider {
    @Override
    @NotNull
    public Set<String> getSearchTexts(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiFile)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(2);
            }
            return set;
        }
        RailsApp app = RailsApp.fromPsiElement(element);
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (app == null || file == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(3);
            }
            return set;
        }
        VirtualFile root = RailsAssetViewParamDefSearchTextProvider.getRootFolder(app, file);
        if (root == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(4);
            }
            return set;
        }
        String fileName = StringUtil.trimStart((String)file.getName(), (String)"_");
        String viewName = (String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)fileName, (String)"."), (Object)fileName);
        Set<String> extensions = RailsAssetViewParamDefSearchTextProvider.getExtensions(file);
        Set<String> set = RailsAssetViewParamDefSearchTextProvider.getPrefixes(root, file).stream().flatMap(prefix -> extensions.stream().flatMap(extension -> Stream.of(viewName, prefix + "/" + viewName, viewName + "." + extension, prefix + "/" + viewName + "." + extension))).collect(Collectors.toSet());
        if (set == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    private static VirtualFile getRootFolder(@NotNull RailsApp app, @NotNull VirtualFile file) {
        VirtualFile viewsRoot;
        if (app == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(6);
        }
        if (file == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(7);
        }
        if ((viewsRoot = (VirtualFile)ContainerUtil.find(app.getPaths().findFiles("app/views"), it -> VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true))) != null) {
            return viewsRoot;
        }
        VirtualFile assetsRoot = (VirtualFile)ContainerUtil.find(app.getPaths().findFiles("app/assets"), it -> VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true));
        if (assetsRoot != null) {
            return assetsRoot;
        }
        return null;
    }

    @NotNull
    private static Set<String> getExtensions(@NotNull VirtualFile file) {
        List<String> extensions;
        if (file == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(8);
        }
        if ((extensions = ViewsConventions.getViewExtensions(file.getName())).isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<String> set = IntStream.rangeClosed(1, extensions.size()).mapToObj(i -> String.join((CharSequence)".", extensions.subList(0, i))).collect(Collectors.toSet());
        if (set == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private static Set<String> getPrefixes(@NotNull VirtualFile root, @NotNull VirtualFile file) {
        List<String> relativePath;
        if (root == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(11);
        }
        if (file == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(12);
        }
        List<String> list = relativePath = file.getParent() != null ? VirtualFileUtil.getRelativePath(file.getParent(), root) : null;
        if (relativePath == null || relativePath.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(13);
            }
            return set;
        }
        Set<String> set = IntStream.rangeClosed(1, relativePath.size()).mapToObj(i -> String.join((CharSequence)"/", relativePath.subList(relativePath.size() - i, relativePath.size()))).collect(Collectors.toSet());
        if (set == null) {
            RailsAssetViewParamDefSearchTextProvider.$$$reportNull$$$0(14);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 9, 10, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/search/RailsAssetViewParamDefSearchTextProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/search/RailsAssetViewParamDefSearchTextProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchTexts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSearchTexts";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRootFolder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 9, 10, 13, 14 -> new IllegalStateException(string);
        };
    }
}

