/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolverManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RailsUrlFilter
implements Filter {
    private static final Pattern QUOTED_URL_PATTERN = Pattern.compile("Started (\\S*) \"(.*)\"");
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    private final Project myProject;

    public RailsUrlFilter(@NotNull Project project) {
        if (project == null) {
            RailsUrlFilter.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            RailsUrlFilter.$$$reportNull$$$0(1);
        }
        if (line.length() > 255) {
            return null;
        }
        Matcher matcher = QUOTED_URL_PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        ArrayList<Filter.ResultItem> items = new ArrayList<Filter.ResultItem>();
        UrlResolverManager resolver = UrlResolverManager.getInstance((Project)this.myProject);
        do {
            String verb = matcher.group(1);
            String url = matcher.group(2);
            int start = entireLength - line.length() + matcher.start(2);
            Iterable infos = resolver.resolve(new UrlResolveRequest(null, null, UrlPath.fromExactString((String)url), verb));
            List elements = StreamSupport.stream(infos.spliterator(), false).flatMap(it -> Stream.ofNullable(it.resolveToPsiElement())).toList();
            if (elements.isEmpty()) continue;
            HyperlinkInfo hyperlinkInfo = HyperlinkInfoFactory.getInstance().createMultiplePsiElementHyperlinkInfo(elements);
            items.add(new Filter.ResultItem(start, start + url.length(), hyperlinkInfo, HYPERLINK_ATTRIBUTES));
        } while (matcher.find());
        return !items.isEmpty() ? new Filter.Result(items) : null;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myProject.equals(((RailsUrlFilter)obj).myProject);
    }

    public int hashCode() {
        return this.myProject.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/filters/RailsUrlFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

