/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;

public final class RailsControllerActionFilter
implements Filter {
    private static final Pattern CONTROLLER_ACTION_PATTERN = Pattern.compile("([A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*(?:::[A-Z\\p{Lu}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)*)#(" + RubyTextUtil.CID_PATTERN.pattern() + ")");
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    private final Project myProject;
    private final Module myModule;

    public RailsControllerActionFilter(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            RailsControllerActionFilter.$$$reportNull$$$0(0);
        }
        if (module == null) {
            RailsControllerActionFilter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myModule = module;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            RailsControllerActionFilter.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed() || this.myModule.isDisposed() || line.length() > 255) {
            return null;
        }
        Matcher matcher = CONTROLLER_ACTION_PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        ArrayList items = new ArrayList();
        do {
            String fqn = matcher.group(1);
            String action = matcher.group(2);
            int start = entireLength - line.length() + matcher.start();
            Symbol symbol = SymbolUtil.findConstantByFQN(this.myProject, Types.MODULE_OR_CLASS, FQN.of((String)fqn), null);
            if (symbol == null) continue;
            Symbol method = SymbolUtil.findMethod(symbol, action, Types.METHODS_LIKE, null);
            if (method != null) {
                ContainerUtil.addIfNotNull(items, (Object)RailsControllerActionFilter.createResultItem(method, start, start + fqn.length() + 1 + action.length()));
                continue;
            }
            ContainerUtil.addIfNotNull(items, (Object)RailsControllerActionFilter.createResultItem(symbol, start, start + fqn.length()));
        } while (matcher.find());
        return !items.isEmpty() ? new Filter.Result(items) : null;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RailsControllerActionFilter other = (RailsControllerActionFilter)obj;
        return this.myProject.equals(other.myProject) && this.myModule.equals(other.myModule);
    }

    public int hashCode() {
        return 31 * this.myProject.hashCode() + this.myModule.hashCode();
    }

    @Nullable
    private static Filter.ResultItem createResultItem(@NotNull Symbol symbol, int start, int end) {
        Collection elements;
        if (symbol == null) {
            RailsControllerActionFilter.$$$reportNull$$$0(3);
        }
        if ((elements = symbol.getAllDeclarations(null)).isEmpty()) {
            return null;
        }
        HyperlinkInfo hyperlinkInfo = HyperlinkInfoFactory.getInstance().createMultiplePsiElementHyperlinkInfo(elements);
        return new Filter.ResultItem(start, end, hyperlinkInfo, HYPERLINK_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/filters/RailsControllerActionFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createResultItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

