/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.ExternalRailsSettings;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.BaseRailsServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.RailsServerInitializerUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public class JRubyServerRunCommandLineGenerator
extends BaseRailsServerRunCommandLineGenerator {
    private static final String RUBYMINE_JRUBY_DEBUG_RB = "rubymine_jruby_debug.rb";

    public JRubyServerRunCommandLineGenerator(RailsServerRunConfiguration config) {
        super(config);
    }

    @Override
    public void addIpAddressAndPortParameters(@Nullable String ipAddress, @Nullable Integer port, @NotNull ParamsGroup params) {
        if (params == null) {
            JRubyServerRunCommandLineGenerator.$$$reportNull$$$0(0);
        }
        if (port != null) {
            params.addParameter("-p");
            params.addParameter(String.valueOf(port));
        }
    }

    @Override
    public void addEnvironmentVariables(RailsServerRunConfiguration config, RubyCommandLineData data, String runnerId) throws ExecutionException {
        if (!"RubyDebugRunner".equals(runnerId)) {
            return;
        }
        RailsServerInitializerUtil.setupDebugInitializer(config, runnerId, RUBYMINE_JRUBY_DEBUG_RB, ExternalRailsSettings.getServerGemTitle(config.getServerType()));
        RubyCommandLine commandLine = data.getCommandLine();
        Map params = commandLine.getEnvironment();
        commandLine.getParametersList().clearAll();
        commandLine.addParameter("-X+O");
        params.put("RUBYMINE_DEBUG_PORT", String.valueOf(((PortForwarding)((Collection)data.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY)).iterator().next()).getRemotePort()));
        OSUtil.appendToEnvVariable("JRUBY_OPTS", "-J-Djruby.objectspace.enabled=true -J-Djruby.compile.mode=OFF -J-Djruby.debug.fullTrace=true", params, " ");
        if (RubyDebuggerSettings.getInstance().getState().isVerboseOutput()) {
            params.put("RUBYMINE_DEBUG_VERBOSE", "true");
        }
    }

    @Override
    @Nullable
    public String getServerScript(boolean isInDebugMode) {
        String path = this.myConfig.getGemScriptPath();
        if (path != null) {
            return path;
        }
        return super.getServerScript(isInDebugMode);
    }

    @Override
    public void addServerParameter(@NotNull String server, @NotNull ParamsGroup params, boolean isInDebugMode) {
        if (server == null) {
            JRubyServerRunCommandLineGenerator.$$$reportNull$$$0(1);
        }
        if (params == null) {
            JRubyServerRunCommandLineGenerator.$$$reportNull$$$0(2);
        }
        params.addParameter("--threadsafe");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/commandline/JRubyServerRunCommandLineGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addIpAddressAndPortParameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addServerParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

