/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration.server;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;

public class RailsServerRunConfigurationExternalizer
extends SettingsExternalizer {
    private static final RailsServerRunConfigurationExternalizer myInstance = new RailsServerRunConfigurationExternalizer();
    @NonNls
    public static final String RAILS_SERVER_CONFIG_SETTINGS_ID = "RAILS_SERVER_CONFIG_SETTINGS_ID";
    @NonNls
    private static final String SCRIPT_ARGS = "SCRIPT_ARGS";
    @NonNls
    private static final String PORT = "PORT";
    @NonNls
    private static final String IP = "IP";
    @NonNls
    public static final String DUMMY_APP = "DUMMY_APP";
    @NonNls
    public static final String SERVER_TYPE = "RAILS_SERVER_TYPE";
    @NonNls
    public static final String ENVIRONMENT_TYPE = "ENVIRONMENT_TYPE";
    @NonNls
    private static final String BROWSER_URL = "BROWSER_URL";
    @NonNls
    private static final String LAUNCH_JS = "LAUNCH_JS";

    public void writeExternal(RailsServerRunConfiguration conf, Element elem) {
        this.writeOption(SCRIPT_ARGS, conf.getScriptArgs(), elem);
        this.writeOption(PORT, conf.getPort(), elem);
        this.writeOption(IP, conf.getIPAddr(), elem);
        this.writeOption(DUMMY_APP, conf.getDummyAppLocation(), elem);
        this.writeOption(SERVER_TYPE, conf.getServerType(), elem);
        this.writeOption(ENVIRONMENT_TYPE, conf.getRailsEnvironmentType(), elem);
        String url = conf.getBrowserUrl();
        if (url != null) {
            this.writeOption(BROWSER_URL, url, elem);
        }
        this.writeOption(LAUNCH_JS, String.valueOf(conf.isLaunchJavascriptDebugger()), elem);
    }

    public void readExternal(RailsServerRunConfiguration conf, Element elem) {
        String launchJS;
        String browserUrl;
        String envType;
        String dummyApp;
        Map<String, String> optionsByName = this.buildOptionsByElement(elem);
        conf.setScriptArgs(optionsByName.get(SCRIPT_ARGS));
        conf.setPort(optionsByName.get(PORT));
        conf.setIPAddr(optionsByName.get(IP));
        String serverType = optionsByName.get(SERVER_TYPE);
        if (serverType != null) {
            conf.setServerType(serverType);
        }
        if ((dummyApp = optionsByName.get(DUMMY_APP)) != null) {
            conf.setDummyAppLocation(dummyApp);
        }
        if ((envType = optionsByName.get(ENVIRONMENT_TYPE)) != null) {
            conf.setRailsEnvironmentType(StringUtil.toLowerCase((String)envType));
        }
        if ((browserUrl = optionsByName.get(BROWSER_URL)) != null) {
            conf.setBrowserUrl(browserUrl);
        }
        if ((launchJS = optionsByName.get(LAUNCH_JS)) != null) {
            conf.setLaunchJavascriptDebugger(Boolean.parseBoolean(launchJS));
        }
    }

    public static RailsServerRunConfigurationExternalizer getInstance() {
        return myInstance;
    }

    @Override
    @NotNull
    public String getID() {
        return RAILS_SERVER_CONFIG_SETTINGS_ID;
    }
}

