/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration.server;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.ExternalRailsSettings;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;

public class RailsServerRunConfigurationEditor
extends SettingsEditor<RailsServerRunConfiguration>
implements RailsServerRunConfigurationParams,
PanelWithAnchor {
    private JPanel generatedPanel1;
    private LabeledComponent myScriptArgsComponent;
    private LabeledComponent myRailsServerComponent;
    private LabeledComponent myPort;
    private LabeledComponent myIPAddr;
    private LabeledComponent myRailsEnvironment;
    private JBCheckBox myRunBrowserCheckBox;
    private JTextField myUrlTextField;
    private JPanel myCommonOptionsPanel;
    private JCheckBox myStartJavaScriptDebugger;
    private LabeledComponent<TextFieldWithBrowseButton> myDummyApp;
    private TextFieldWithBrowseButton myDummyAppLocation;
    private JTextField myIPAddrField;
    private JTextField myPortField;
    private JComboBox<String> myRailsServerComboBox;
    private JComboBox<String> myRailsEnvironmentComboBox;
    private final RubyCommonRunParamsEditor myCommonEditor;
    private RawCommandLineEditor myScriptArgsEditor;
    private JComponent anchor;
    private final Project myProject;

    public RailsServerRunConfigurationEditor(Project project, RailsServerRunConfiguration configuration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = new RubyCommonRunParamsEditor(configuration);
        this.myCommonOptionsPanel.add((Component)this.myCommonEditor.getMainPanel(), "Center");
        this.myCommonEditor.setWorkDirVisible(false);
        this.initComponents();
        this.setAnchor(this.myCommonEditor.getAnchor());
    }

    private void initComponents() {
        this.myRunBrowserCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RailsServerRunConfigurationEditor.this.myUrlTextField.setEnabled(RailsServerRunConfigurationEditor.this.myRunBrowserCheckBox.isSelected());
                RailsServerRunConfigurationEditor.this.myStartJavaScriptDebugger.setEnabled(RailsServerRunConfigurationEditor.this.myRunBrowserCheckBox.isSelected());
            }
        });
        this.myPortField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                RailsServerRunConfigurationEditor.this.updatePort();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/rails/run/configuration/server/RailsServerRunConfigurationEditor$2", "textChanged"));
            }
        });
        this.myIPAddrField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                RailsServerRunConfigurationEditor.this.updateHost();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/rails/run/configuration/server/RailsServerRunConfigurationEditor$3", "textChanged"));
            }
        });
        this.myUrlTextField.setText(this.getDefaultUrl());
        this.myRailsServerComboBox.setModel(new DefaultComboBoxModel<String>(ExternalRailsSettings.getRailsServersTypes()));
        this.myRailsEnvironmentComboBox.setModel(new DefaultComboBoxModel<String>(RailsUtil.getAllEnvironments(this.myCommonEditor.getModule())));
        this.myRailsServerComboBox.setSelectedItem("Default");
        this.myRailsEnvironmentComboBox.setSelectedItem("development");
        this.myRailsServerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RailsServerRunConfiguration.isJrubyServer((String)RailsServerRunConfigurationEditor.this.myRailsServerComboBox.getSelectedItem())) {
                    RailsServerRunConfigurationEditor.this.myIPAddr.setEnabled(false);
                    RailsServerRunConfigurationEditor.this.myPort.setEnabled(true);
                } else {
                    RailsServerRunConfigurationEditor.this.myIPAddr.setEnabled(true);
                    RailsServerRunConfigurationEditor.this.myPort.setEnabled(true);
                }
            }
        });
        this.myCommonEditor.addModuleChangedListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RailsServerRunConfigurationEditor.this.updateDummyApp();
            }
        });
        this.updateDummyApp();
    }

    private void updateDummyApp() {
        RailsApp app = RailsApp.fromModule(this.myCommonEditor.getModule());
        this.myDummyApp.setEnabled(app == null || app.isEngine());
    }

    private void updateHost() {
        String url = this.myUrlTextField.getText();
        int index = url.lastIndexOf(58);
        if (index != -1) {
            this.myUrlTextField.setText("http://" + this.myIPAddrField.getText().trim() + url.substring(index));
        }
    }

    private void updatePort() {
        String url = this.myUrlTextField.getText();
        int index = url.lastIndexOf(58);
        if (index != -1) {
            int i;
            for (i = index + 1; i < url.length() && Character.isDigit(url.charAt(i)); ++i) {
            }
            String route = i < url.length() ? url.substring(i) : "";
            this.myUrlTextField.setText(url.substring(0, index) + ":" + this.myPortField.getText().trim() + route);
        }
    }

    private String getDefaultUrl() {
        return "http://" + this.myIPAddrField.getText().trim() + ":" + this.myPortField.getText().trim();
    }

    private void createUIComponents() {
        this.myScriptArgsComponent = this.createScriptArgsComponent();
        this.myDummyApp = this.createDummyAppComponent();
        this.myRailsServerComponent = this.createServersComponent();
        this.myRailsEnvironment = this.createEnvironmentsComponent();
        this.myPort = this.createPortComponent();
        this.myIPAddr = this.createIPAddrComponent();
    }

    private LabeledComponent createIPAddrComponent() {
        this.myIPAddrField = new JTextField();
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)this.myIPAddrField);
        myComponent.setText(RBundle.message((String)"run.configuration.server.dialog.ip"));
        myComponent.setLabelLocation("West");
        return myComponent;
    }

    private LabeledComponent createPortComponent() {
        this.myPortField = new JTextField();
        this.myPortField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c < '0' || c > '9') {
                    e.consume();
                }
            }
        });
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)this.myPortField);
        myComponent.setLabelLocation("West");
        myComponent.setText(RBundle.message((String)"run.configuration.server.dialog.port"));
        return myComponent;
    }

    private LabeledComponent createServersComponent() {
        this.myRailsServerComboBox = new ComboBox();
        this.myRailsServerComboBox.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", ExternalRailsSettings::getRailsServersTitlesByType));
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent(this.myRailsServerComboBox);
        myComponent.setText(RBundle.message((String)"run.configuration.server.dialog.server"));
        myComponent.setLabelLocation("West");
        return myComponent;
    }

    private LabeledComponent createEnvironmentsComponent() {
        this.myRailsEnvironmentComboBox = new ComboBox();
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent(this.myRailsEnvironmentComboBox);
        myComponent.setText(RBundle.message((String)"run.configuration.server.dialog.environment"));
        return myComponent;
    }

    protected LabeledComponent createScriptArgsComponent() {
        String text = RBundle.message((String)"run.configuration.server.args");
        Ref scriptArgsEditorWrapper = new Ref();
        LabeledComponent<RawCommandLineEditor> myComponent = RunConfigurationUIUtil.createRawEditorComponent((Ref<? super RawCommandLineEditor>)scriptArgsEditorWrapper, text);
        this.myScriptArgsEditor = (RawCommandLineEditor)scriptArgsEditorWrapper.get();
        return myComponent;
    }

    protected LabeledComponent<TextFieldWithBrowseButton> createDummyAppComponent() {
        String title = RBundle.message((String)"run.configuration.messages.select.working.dir");
        this.myDummyAppLocation = new TextFieldWithBrowseButton();
        RunConfigurationUIUtil.addFolderChooser(title, this.myDummyAppLocation, this.myProject);
        return LabeledComponent.create((JComponent)this.myDummyAppLocation, (String)RBundle.message((String)"run.configuration.server.dialog.dummy.app"));
    }

    @Override
    @NotNull
    public String getIPAddr() {
        String string = this.myIPAddrField.getText().trim();
        if (string == null) {
            RailsServerRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void setIPAddr(String ip) {
        this.myIPAddrField.setText(ip);
    }

    @Override
    public String getPort() {
        return this.myPortField.getText().trim();
    }

    @Override
    public void setPort(String port) {
        this.myPortField.setText(port);
    }

    @Override
    @NotNull
    public String getServerType() {
        String string = (String)this.myRailsServerComboBox.getSelectedItem();
        if (string == null) {
            RailsServerRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void setServerType(@NotNull @NlsSafe String type) {
        if (type == null) {
            RailsServerRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        this.myRailsServerComboBox.setSelectedItem(type);
    }

    @Override
    public void setRailsEnvironmentType(@NotNull @NlsSafe String type) {
        if (type == null) {
            RailsServerRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        this.myRailsEnvironmentComboBox.setSelectedItem(type);
    }

    @Override
    @Nullable
    public String getBrowserUrl() {
        return this.myRunBrowserCheckBox.isSelected() ? this.myUrlTextField.getText() : null;
    }

    @Override
    public void setBrowserUrl(String url) {
        if (url != null) {
            this.myRunBrowserCheckBox.setSelected(true);
            this.myUrlTextField.setText(url);
            this.myStartJavaScriptDebugger.setEnabled(true);
        } else {
            this.myRunBrowserCheckBox.setSelected(false);
            this.myUrlTextField.setText(this.getDefaultUrl());
            this.myStartJavaScriptDebugger.setEnabled(false);
        }
        this.myUrlTextField.setEnabled(this.myRunBrowserCheckBox.isSelected());
    }

    @Override
    public boolean isLaunchJavascriptDebugger() {
        return this.myStartJavaScriptDebugger.isEnabled() && this.myStartJavaScriptDebugger.isSelected();
    }

    @Override
    public void setLaunchJavascriptDebugger(boolean launch) {
        this.myStartJavaScriptDebugger.setSelected(launch);
    }

    @Override
    public String getDummyAppLocation() {
        return FileUtil.toSystemIndependentName((String)this.myDummyAppLocation.getText().trim());
    }

    @Override
    public void setDummyAppLocation(@NlsSafe String location) {
        this.myDummyAppLocation.setText(location);
    }

    @Override
    @NotNull
    public String getRailsEnvironmentType() {
        String string = (String)this.myRailsEnvironmentComboBox.getSelectedItem();
        if (string == null) {
            RailsServerRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public String getScriptArgs() {
        return this.myScriptArgsEditor.getText().trim();
    }

    @Override
    public void setScriptArgs(String value) {
        this.myScriptArgsEditor.setText(value);
    }

    public JComponent getPanel() {
        return this.generatedPanel1;
    }

    public void resetEditorFrom(@NotNull RailsServerRunConfiguration config) {
        if (config == null) {
            RailsServerRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        RailsServerRunConfiguration.copyParams(config, this);
        this.myCommonEditor.resetEditorFrom(config);
    }

    public void applyEditorTo(@NotNull RailsServerRunConfiguration config) {
        if (config == null) {
            RailsServerRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        RailsServerRunConfiguration.copyParams(this, config);
        this.myCommonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.generatedPanel1;
        if (jPanel == null) {
            RailsServerRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myIPAddr.setAnchor(anchor);
        this.myPort.setAnchor(anchor);
        this.myDummyApp.setAnchor(anchor);
        this.myRailsEnvironment.setAnchor(anchor);
        this.myRailsServerComponent.setAnchor(anchor);
        this.myScriptArgsComponent.setAnchor(anchor);
        this.myRunBrowserCheckBox.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.generatedPanel1 = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent labeledComponent = this.myScriptArgsComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", RailsServerRunConfigurationEditor.class).getString("run.configuration.server.args"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent2 = this.myRailsServerComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", RailsServerRunConfigurationEditor.class).getString("run.configuration.server.dialog.server"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent3 = this.myIPAddr;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/RBundle", RailsServerRunConfigurationEditor.class).getString("run.configuration.server.dialog.ip"));
        jPanel2.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent4 = this.myRailsEnvironment;
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/RBundle", RailsServerRunConfigurationEditor.class).getString("run.configuration.server.dialog.environment"));
        jPanel2.add((Component)labeledComponent4, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myRunBrowserCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RailsServerRunConfigurationEditor.class).getString("run.configuration.server.dialog.run.browser.text"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        LabeledComponent labeledComponent5 = this.myPort;
        labeledComponent5.setLabelLocation("West");
        labeledComponent5.setText(DynamicBundle.getBundle((String)"messages/RBundle", RailsServerRunConfigurationEditor.class).getString("run.configuration.server.dialog.port"));
        jPanel2.add((Component)labeledComponent5, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myStartJavaScriptDebugger = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 1));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RailsServerRunConfigurationEditor.class).getString("run.configuration.server.dialog.auto.start.js.debugger.text"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(8, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myUrlTextField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel2.add((Component)jTextField, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(9, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(10, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel2.add((Component)jSeparator2, new GridConstraints(6, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent6 = this.myDummyApp;
        labeledComponent6.setLabelLocation("West");
        labeledComponent6.setText(DynamicBundle.getBundle((String)"messages/RBundle", RailsServerRunConfigurationEditor.class).getString("run.configuration.server.dialog.dummy.app"));
        jPanel2.add((Component)labeledComponent6, new GridConstraints(5, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.generatedPanel1;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/RailsServerRunConfigurationEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIPAddr";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerType";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/RailsServerRunConfigurationEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRailsEnvironmentType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setServerType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRailsEnvironmentType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

