/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.routes;

import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.routes.RailsRoute;
import org.jetbrains.plugins.ruby.rails.routes.RailsRouteScope;
import org.jetbrains.plugins.ruby.rails.routes.RailsRouteUtil;
import org.jetbrains.plugins.ruby.rails.routes.RoutesInfo;
import org.jetbrains.plugins.ruby.rails.routes.RubyRoutesProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.util.StreamUtil;

final class RoutesCallable
implements PsiCallable {
    private static final Set<String> MATCHER_NAMES = Set.of("delete", "get", "match", "patch", "post", "put", "root");
    private static final Set<String> ON_NAMES = Set.of("collection", "member");
    private static final Set<String> RESOURCEFUL_NAMES = Set.of("resource", "resources");
    private static final Set<String> IRRELEVANT_COMMANDS = Set.of("connect", "draw");
    private final RoutesInfo myRoutesInfo;
    private final RailsRouteScope myScope;

    RoutesCallable(@NotNull Module module) {
        if (module == null) {
            RoutesCallable.$$$reportNull$$$0(0);
        }
        this(new RoutesInfo(), new RailsRouteScope(module));
    }

    RoutesCallable(@NotNull RoutesInfo routesInfo, @NotNull RailsRouteScope scope) {
        if (routesInfo == null) {
            RoutesCallable.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            RoutesCallable.$$$reportNull$$$0(2);
        }
        this.myRoutesInfo = routesInfo;
        this.myScope = scope;
    }

    @NotNull
    public RoutesInfo getRoutesInfo() {
        RoutesInfo routesInfo = this.myRoutesInfo;
        if (routesInfo == null) {
            RoutesCallable.$$$reportNull$$$0(3);
        }
        return routesInfo;
    }

    @NotNull
    public RailsRouteScope getRouteScope() {
        RailsRouteScope railsRouteScope = this.myScope;
        if (railsRouteScope == null) {
            RoutesCallable.$$$reportNull$$$0(4);
        }
        return railsRouteScope;
    }

    @Override
    public void processCall(@NotNull RCallArguments arguments) {
        if (arguments == null) {
            RoutesCallable.$$$reportNull$$$0(5);
        }
        ProgressManager.checkCanceled();
        PsiElement call = arguments.getCallElement();
        if (call instanceof RIdentifier && ((RIdentifier)call).isBlockParameterDeclaration()) {
            return;
        }
        if (call instanceof RDotReference) {
            return;
        }
        String command = arguments.getCommand();
        if (RESOURCEFUL_NAMES.contains(command)) {
            this.addRoutesForResource(command, arguments);
        } else if (ON_NAMES.contains(command)) {
            arguments.interpretBlockWithGivenSelf(new MyMethodsCallable(command.equals("collection"), command.equals("member")), new PsiCallable[0]);
            this.myRoutesInfo.addNamespaceFqn(arguments.getRBlockCallElement(), this.myScope.getModuleFqn());
        } else if (MATCHER_NAMES.contains(command)) {
            String on = StringUtil.notNullize((String)arguments.getOptionValue("on"));
            this.addRoutesForMatcher(command, arguments, on.equals("collection"), on.equals("member") || this.myScope.hasScopeLevel("resource"), on.equals("new"));
        } else if (!IRRELEVANT_COMMANDS.contains(command) && arguments.hasBlock()) {
            this.addRoutesForScope(command, arguments);
        }
        for (RubyRoutesProvider routesProvider : RubyRoutesProvider.EP_NAME.getExtensionList()) {
            if (!routesProvider.canGenerateRoutesForCommand(command)) continue;
            routesProvider.generateRoutes(this, arguments);
        }
    }

    public void addRoute(@NotNull PsiElement declaringElement, @Nullable String prefix, @Nullable String verb, @Nullable UrlPath path, @NotNull FQN target) {
        if (declaringElement == null) {
            RoutesCallable.$$$reportNull$$$0(6);
        }
        if (target == null) {
            RoutesCallable.$$$reportNull$$$0(7);
        }
        this.myRoutesInfo.addRoute(declaringElement, new RailsRoute(prefix, verb, path, target));
    }

    public void addRoutes(@NotNull PsiElement declaringElement, @Nullable String prefix, @NotNull Set<String> verbs, @Nullable UrlPath path, @NotNull FQN target) {
        if (declaringElement == null) {
            RoutesCallable.$$$reportNull$$$0(8);
        }
        if (verbs == null) {
            RoutesCallable.$$$reportNull$$$0(9);
        }
        if (target == null) {
            RoutesCallable.$$$reportNull$$$0(10);
        }
        verbs.forEach(it -> this.addRoute(declaringElement, prefix, (String)it, path, target));
    }

    private void addRoutesForMatcher(@NotNull String matcher, @NotNull RCallArguments arguments, boolean collection, boolean member, boolean alternateNew) {
        if (matcher == null) {
            RoutesCallable.$$$reportNull$$$0(11);
        }
        if (arguments == null) {
            RoutesCallable.$$$reportNull$$$0(12);
        }
        String moduleName = RailsRouteUtil.joinNamespace(this.myScope.getModuleName(), arguments.getOptionValue("module"));
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)arguments.getRCallElement());
        this.myRoutesInfo.addNamespaceFqn(arguments.getRCallElement(), RailsRouteUtil.getNamespaceFqn(moduleName, module));
        String as = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)arguments.getOptionValueElement("as"));
        String format = arguments.getOptionValue("format");
        String controller = StringUtil.notNullize((String)this.myScope.getControllerForMatcher(matcher, arguments));
        FQN controllerFqn = RailsRouteUtil.getControllerFqn(moduleName, controller, module);
        this.myRoutesInfo.addControllerFqn(arguments.getRCallElement(), controllerFqn);
        String action = this.myScope.getActionForMatcher(matcher, arguments);
        FQN target = action != null ? FQN.Builder.concat((FQN)controllerFqn, (String)action) : FQN.INVALID;
        this.myRoutesInfo.addActionFqn(arguments.getRCallElement(), target);
        Set<String> verbs = RailsRouteUtil.getVerbsForMatcher(arguments);
        ArrayList pathElements = new ArrayList();
        if (matcher.equals("root")) {
            this.addRoutes(arguments.getCallElement(), this.myScope.getPrefixForMatcher((String)ObjectUtils.coalesce((Object)as, (Object)"root"), collection, member, alternateNew), verbs, this.myScope.getPathForMatcher("", collection, member, alternateNew, (String)ObjectUtils.coalesce((Object)format, (Object)"false")), target);
            return;
        }
        if (ContainerUtil.getFirstItem(arguments.getArguments()) instanceof RAssoc) {
            arguments.getArguments().stream().mapMulti(StreamUtil.select(RAssoc.class, (Class[])new Class[0])).map(RAssoc::getKey).mapMulti(StreamUtil.select(RStringLiteral.class, (Class[])new Class[0])).findFirst().ifPresent(pathElements::add);
        } else {
            pathElements.addAll(ContainerUtil.filter(arguments.getArguments(), RubyPsiUtil::isSimpleStringOrSymbol));
        }
        for (PsiElement element : pathElements) {
            String path = RubyInterpretUtil.evaluateStringOrSymbolElement(element);
            if (path == null) continue;
            String prefix = this.myScope.getPrefixForMatcher((String)ObjectUtils.coalesce((Object)as, (Object)RailsRouteUtil.getNormalizedPrefixForMatcher(path)), collection, member, alternateNew);
            if (element instanceof RSymbol && RailsRouteScope.ACTION_NAMES.contains(path)) {
                this.addRoutes(element, prefix, verbs, this.myScope.getPathForResourceAction(path, format), target);
                continue;
            }
            this.addRoutes(element, prefix, verbs, this.myScope.getPathForMatcher(path, collection, member, alternateNew, format), target);
        }
    }

    private void addRoutesForScope(@NotNull String command, @NotNull RCallArguments arguments) {
        if (command == null) {
            RoutesCallable.$$$reportNull$$$0(13);
        }
        if (arguments == null) {
            RoutesCallable.$$$reportNull$$$0(14);
        }
        RailsRouteScope scope = this.myScope.scope(command, arguments);
        RoutesCallable routes = new RoutesCallable(this.myRoutesInfo, scope);
        arguments.interpretBlockWithGivenSelf(routes, routes);
        this.myRoutesInfo.addNamespaceFqn(arguments.getRBlockCallElement(), scope.getModuleFqn());
        this.myRoutesInfo.addControllerFqn(arguments.getRBlockCallElement(), scope.getControllerFqn());
    }

    private void addRoutesForResource(@NotNull String command, @NotNull RCallArguments arguments) {
        if (command == null) {
            RoutesCallable.$$$reportNull$$$0(15);
        }
        if (arguments == null) {
            RoutesCallable.$$$reportNull$$$0(16);
        }
        for (String resource : ContainerUtil.map(arguments.getArguments(), RubyInterpretUtil::evaluateStringOrSymbolElement)) {
            if (StringUtil.isEmpty((String)resource)) continue;
            RailsRouteScope scope = this.myScope.resource(command, arguments, resource);
            RoutesCallable routes = new RoutesCallable(this.myRoutesInfo, scope);
            arguments.interpretBlockWithGivenSelf(routes, routes);
            this.addRoutesForResource(scope, arguments.getRCallElement());
            this.myRoutesInfo.addNamespaceFqn(arguments.getRBlockCallElement(), scope.getModuleFqn());
            this.myRoutesInfo.addControllerFqn(arguments.getRBlockCallElement(), scope.getControllerFqn());
        }
    }

    private void addRoutesForResource(@NotNull RailsRouteScope scope, @NotNull PsiElement element) {
        if (scope == null) {
            RoutesCallable.$$$reportNull$$$0(17);
        }
        if (element == null) {
            RoutesCallable.$$$reportNull$$$0(18);
        }
        FQN controllerFqn = scope.getControllerFqn();
        for (String action : scope.getActionsForResource()) {
            this.myRoutesInfo.addActionFqn(element, FQN.Builder.concat((FQN)controllerFqn, (String)action));
            String prefix = scope.getPrefixForResourceAction(action);
            Set<String> verbs = RailsRouteUtil.getVerbsForResourceAction(action);
            UrlPath path = scope.getPathForResourceAction(action);
            FQN target = FQN.Builder.concat((FQN)controllerFqn, (String)action);
            if (prefix == null) continue;
            if (action.equals("index")) {
                if (!scope.hasScopeLevel("resources")) continue;
                this.addRoutes(element, prefix, verbs, path, target);
                continue;
            }
            this.addRoutes(element, prefix, verbs, path, target);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routesInfo";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/RoutesCallable";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringElement";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verbs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RoutesCallable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutesInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRouteScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRoute";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRoutes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addRoutesForMatcher";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addRoutesForScope";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addRoutesForResource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private final class MyMethodsCallable
    implements PsiCallable {
        private final boolean myInCollection;
        private final boolean myInMember;

        private MyMethodsCallable(boolean inCollection, boolean inMember) {
            this.myInCollection = inCollection;
            this.myInMember = inMember;
        }

        @Override
        public void processCall(@NotNull RCallArguments arguments) {
            String command;
            if (arguments == null) {
                MyMethodsCallable.$$$reportNull$$$0(0);
            }
            if (MATCHER_NAMES.contains(command = arguments.getCommand())) {
                RoutesCallable.this.addRoutesForMatcher(command, arguments, this.myInCollection, this.myInMember, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/plugins/ruby/rails/routes/RoutesCallable$MyMethodsCallable", "processCall"));
        }
    }
}

