/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.routes;

import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ControllerActionRefParam;
import org.jetbrains.plugins.ruby.rails.routes.RailsRouteUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValue;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;

final class RailsRouteScope {
    public static final Set<String> ACTION_NAMES = Set.of("create", "destroy", "edit", "index", "new", "show", "update");
    private final Module myModule;
    private final InflectorService myInflectorService;
    @Nullable
    private final RailsRouteScope myParent;
    @Nullable
    private final String myScopeLevel;
    @Nullable
    private final String myPrefix;
    @Nullable
    private final String myShallowPrefix;
    @Nullable
    private final List<UrlPath.PathSegment> myPathSegments;
    @Nullable
    private final List<UrlPath.PathSegment> myShallowPathSegments;
    @Nullable
    private final Map<String, UrlPath.PathSegment> myPathNameSegments;
    @Nullable
    private final Pair<String, String> myParam;
    @Nullable
    private final String myFormat;
    @Nullable
    private final String myModuleName;
    @Nullable
    private final String myController;
    @Nullable
    private final String myAction;
    @Nullable
    private final List<String> myOnly;
    @Nullable
    private final List<String> myExcept;
    @Nullable
    private final Boolean myShallow;

    RailsRouteScope(@NotNull Module module) {
        if (module == null) {
            RailsRouteScope.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myInflectorService = InflectorService.getInstance(module);
        this.myParent = null;
        this.myScopeLevel = null;
        this.myPrefix = null;
        this.myShallowPrefix = null;
        this.myPathSegments = null;
        this.myShallowPathSegments = null;
        this.myPathNameSegments = null;
        this.myParam = null;
        this.myFormat = null;
        this.myModuleName = null;
        this.myController = null;
        this.myAction = null;
        this.myOnly = null;
        this.myExcept = null;
        this.myShallow = null;
    }

    private RailsRouteScope(@NotNull Module module, @NotNull RailsRouteScope parent, @Nullable String level, @Nullable String prefix, @Nullable String shallowPrefix, @Nullable List<UrlPath.PathSegment> pathSegments, @Nullable List<UrlPath.PathSegment> shallowPathSegments, @Nullable Map<String, UrlPath.PathSegment> pathNameSegments, @Nullable Pair<String, String> param, @Nullable String format, @Nullable String moduleName, @Nullable String controller, @Nullable String action, @Nullable List<String> only, @Nullable List<String> except, @Nullable Boolean shallow) {
        if (module == null) {
            RailsRouteScope.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            RailsRouteScope.$$$reportNull$$$0(2);
        }
        this.myModule = module;
        this.myInflectorService = InflectorService.getInstance(module);
        this.myParent = parent;
        this.myScopeLevel = level;
        this.myPrefix = prefix;
        this.myShallowPrefix = shallowPrefix;
        this.myPathSegments = (List)ObjectUtils.doIfNotNull(pathSegments, List::copyOf);
        this.myShallowPathSegments = (List)ObjectUtils.doIfNotNull(shallowPathSegments, List::copyOf);
        this.myPathNameSegments = (Map)ObjectUtils.doIfNotNull(pathNameSegments, Map::copyOf);
        this.myParam = param;
        this.myFormat = format;
        this.myModuleName = moduleName;
        this.myController = controller;
        this.myAction = action;
        this.myOnly = (List)ObjectUtils.doIfNotNull(only, List::copyOf);
        this.myExcept = (List)ObjectUtils.doIfNotNull(except, List::copyOf);
        this.myShallow = shallow;
    }

    @NotNull
    Builder builder(@NotNull String level) {
        if (level == null) {
            RailsRouteScope.$$$reportNull$$$0(3);
        }
        Builder builder2 = new Builder(this.myModule, this).withScopeLevel(level);
        if (builder2 == null) {
            RailsRouteScope.$$$reportNull$$$0(4);
        }
        return builder2;
    }

    @Nullable
    String getAction() {
        return (String)ContainerUtil.getLastItem(this.getValues(it -> it.myAction));
    }

    @Nullable
    String getActionForMatcher(@NotNull String matcher, @NotNull RCallArguments arguments) {
        RPsiElement to;
        if (matcher == null) {
            RailsRouteScope.$$$reportNull$$$0(5);
        }
        if (arguments == null) {
            RailsRouteScope.$$$reportNull$$$0(6);
        }
        if ((to = arguments.getOptionValueElement("to")) != null) {
            return ControllerActionRefParam.getActionName((PsiElement)to);
        }
        PsiElement firstArgument = (PsiElement)ContainerUtil.getFirstItem(arguments.getArguments());
        if (matcher.equals("root") && firstArgument instanceof RStringLiteral) {
            return ControllerActionRefParam.getActionName(firstArgument);
        }
        if (firstArgument instanceof RAssoc) {
            return (String)ObjectUtils.doIfNotNull((Object)((RAssoc)firstArgument).getValue(), ControllerActionRefParam::getActionName);
        }
        String action = this.getAction();
        if (!StringUtil.isEmpty((String)action)) {
            return action;
        }
        if (arguments.hasOptionKey("action")) {
            return arguments.getOptionValue("action");
        }
        return RubyInterpretUtil.evaluateStringOrSymbolElement(firstArgument);
    }

    @NotNull
    Set<String> getActionsForResource() {
        List only = (List)ObjectUtils.coalesce(this.myOnly, this.getOnly());
        List except = (List)ObjectUtils.coalesce(this.myExcept, this.getExcept());
        Set<String> set = Set.copyOf((Collection)ObjectUtils.coalesce((Object)only, (Object)ContainerUtil.filter(ACTION_NAMES, action -> except == null || !except.contains(action))));
        if (set == null) {
            RailsRouteScope.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Nullable
    String getController() {
        return (String)ContainerUtil.getLastItem(this.getValues(it -> it.myController));
    }

    @Nullable
    String getControllerForMatcher(@NotNull String matcher, @NotNull RCallArguments arguments) {
        if (matcher == null) {
            RailsRouteScope.$$$reportNull$$$0(8);
        }
        if (arguments == null) {
            RailsRouteScope.$$$reportNull$$$0(9);
        }
        if (arguments.hasOptionKey("controller")) {
            return arguments.getOptionValue("controller");
        }
        RPsiElement to = arguments.getOptionValueElement("to");
        if (to != null) {
            return ControllerActionRefParam.getControllerName((PsiElement)to);
        }
        PsiElement firstArgument = (PsiElement)ContainerUtil.getFirstItem(arguments.getArguments());
        if (matcher.equals("root") && firstArgument instanceof RStringLiteral) {
            return ControllerActionRefParam.getControllerName(firstArgument);
        }
        if (firstArgument instanceof RAssoc) {
            return (String)ObjectUtils.doIfNotNull((Object)((RAssoc)firstArgument).getValue(), ControllerActionRefParam::getControllerName);
        }
        return this.getController();
    }

    @NotNull
    FQN getControllerFqn() {
        String controller = this.getController();
        FQN fQN = controller != null ? RailsRouteUtil.getControllerFqn(this.getModuleName(), controller, this.myModule) : FQN.INVALID;
        if (fQN == null) {
            RailsRouteScope.$$$reportNull$$$0(10);
        }
        return fQN;
    }

    @Nullable
    List<String> getExcept() {
        return (List)ContainerUtil.getLastItem(this.getValues(it -> !it.hasScopeLevel("resource") && !it.hasScopeLevel("resources") ? it.myExcept : null));
    }

    @Nullable
    String getFormat() {
        return (String)ContainerUtil.getLastItem(this.getValues(it -> it.myFormat));
    }

    @NotNull
    String getModuleName() {
        String string = RailsRouteUtil.joinNamespace(ArrayUtil.toStringArray(this.getValues(it -> it.myModuleName)));
        if (string == null) {
            RailsRouteScope.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    FQN getModuleFqn() {
        FQN fQN = RailsRouteUtil.getNamespaceFqn(this.getModuleName(), this.myModule);
        if (fQN == null) {
            RailsRouteScope.$$$reportNull$$$0(12);
        }
        return fQN;
    }

    @Nullable
    List<String> getOnly() {
        return (List)ContainerUtil.getLastItem(this.getValues(it -> !it.hasScopeLevel("resource") && !it.hasScopeLevel("resources") ? it.myOnly : null));
    }

    @NotNull
    String getParam(boolean full) {
        if (this.myParam == null) {
            return "id";
        }
        String string = full ? String.format("%s_%s", this.myParam.getFirst(), this.myParam.getSecond()) : (String)this.myParam.getSecond();
        if (string == null) {
            RailsRouteScope.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    UrlPath getPathForMatcher(@NotNull String path, boolean collection, boolean member, boolean alternateNew, @Nullable String format) {
        if (path == null) {
            RailsRouteScope.$$$reportNull$$$0(14);
        }
        ArrayList<UrlPath.PathSegment> segments = new ArrayList<UrlPath.PathSegment>(this.getPathSegments(!collection, !member, alternateNew));
        Arrays.stream(Strings.trimEnd((String)Strings.trimEnd((String)path, (String)"(.:format)"), (String)".:format").split("/")).filter(StringUtil::isNotEmpty).map(it -> {
            if (it.startsWith(":")) {
                return new UrlPath.PathSegment.Variable(it.substring(1), null);
            }
            return new UrlPath.PathSegment.Exact(it);
        }).forEach(segments::add);
        return RailsRouteScope.getPathForSegments(segments, (String)ObjectUtils.coalesce((Object)format, (Object)this.getFormat()));
    }

    @Nullable
    UrlPath getPathForResourceAction(@NotNull String action) {
        if (action == null) {
            RailsRouteScope.$$$reportNull$$$0(15);
        }
        return this.getPathForResourceAction(action, null);
    }

    @Nullable
    UrlPath getPathForResourceAction(@NotNull String action, @Nullable String format) {
        if (action == null) {
            RailsRouteScope.$$$reportNull$$$0(16);
        }
        ArrayList<UrlPath.PathSegment> collectionSegments = new ArrayList<UrlPath.PathSegment>();
        if (this.myParent != null) {
            collectionSegments.addAll(this.myParent.getPathSegments(true, true, false));
        }
        collectionSegments.addAll((Collection)ObjectUtils.coalesce(this.myPathSegments, Collections.emptyList()));
        ArrayList<UrlPath.PathSegment> memberSegments = new ArrayList<UrlPath.PathSegment>();
        if (this.isShallow()) {
            memberSegments.addAll(this.getShallowPathSegments());
            memberSegments.addAll((Collection)ObjectUtils.coalesce(this.myPathSegments, Collections.emptyList()));
        } else {
            memberSegments.addAll(collectionSegments);
        }
        ArrayList<UrlPath.PathSegment> segments = new ArrayList<UrlPath.PathSegment>();
        switch (action) {
            case "index": 
            case "create": {
                segments.addAll(collectionSegments);
                break;
            }
            case "new": {
                segments.addAll(collectionSegments);
                segments.add(this.getPathName("new"));
                break;
            }
            case "show": 
            case "update": 
            case "destroy": {
                segments.addAll(memberSegments);
                if (!this.hasScopeLevel("resources")) break;
                segments.add((UrlPath.PathSegment)new UrlPath.PathSegment.Variable(this.getParam(false), null));
                break;
            }
            case "edit": {
                segments.addAll(memberSegments);
                if (this.hasScopeLevel("resources")) {
                    segments.add((UrlPath.PathSegment)new UrlPath.PathSegment.Variable(this.getParam(false), null));
                }
                segments.add(this.getPathName("edit"));
            }
        }
        if (segments.isEmpty()) {
            return null;
        }
        return RailsRouteScope.getPathForSegments(segments, (String)ObjectUtils.coalesce((Object)format, (Object)this.getFormat()));
    }

    @NotNull
    String getPrefix() {
        if ((this.hasScopeLevel("resources") || this.hasScopeLevel("resource")) && this.isShallow()) {
            String string = RailsRouteUtil.joinPrefix(this.getShallowPrefix(), this.myPrefix);
            if (string == null) {
                RailsRouteScope.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (this.myParent == null) {
            String string = (String)ObjectUtils.coalesce((Object)this.myPrefix, (Object)"");
            if (string == null) {
                RailsRouteScope.$$$reportNull$$$0(18);
            }
            return string;
        }
        if (this.myParent.hasScopeLevel("resources")) {
            String string = RailsRouteUtil.joinPrefix(this.myInflectorService.singularize(this.myParent.getPrefix()), this.myPrefix);
            if (string == null) {
                RailsRouteScope.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = RailsRouteUtil.joinPrefix(this.myParent.getPrefix(), this.myPrefix);
        if (string == null) {
            RailsRouteScope.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    String getPrefix(boolean isScopeAware) {
        if (this.myParent != null && this.myPrefix == null) {
            String string = this.myParent.getPrefix(isScopeAware);
            if (string == null) {
                RailsRouteScope.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = isScopeAware && this.hasScopeLevel("resources") ? this.myInflectorService.singularize(this.getPrefix()) : this.getPrefix();
        if (string == null) {
            RailsRouteScope.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    String getPrefixForMatcher(@NotNull String path, boolean collection, boolean member, boolean alternateNew) {
        String prefix;
        if (path == null) {
            RailsRouteScope.$$$reportNull$$$0(23);
        }
        if ((prefix = this.getPrefix(!collection)).isEmpty() && path.isEmpty()) {
            return null;
        }
        if (collection && this.hasScopeLevel("resources") && this.myInflectorService.isSingular(prefix)) {
            return RailsRouteUtil.joinPrefix(path, prefix, "index");
        }
        if (collection || member) {
            return RailsRouteUtil.joinPrefix(path, prefix);
        }
        if (alternateNew) {
            return RailsRouteUtil.joinPrefix(path, "new", prefix);
        }
        return RailsRouteUtil.joinPrefix(prefix, path);
    }

    @Nullable
    String getPrefixForResourceAction(@NotNull String action) {
        if (action == null) {
            RailsRouteScope.$$$reportNull$$$0(24);
        }
        if (this.myParent == null) {
            return null;
        }
        boolean singleton = !this.hasScopeLevel("resources");
        String collectionPrefix = this.myParent.getPrefix(true);
        String collectionName = this.myPrefix;
        String memberPrefix = this.isShallow() ? this.getShallowPrefix() : collectionPrefix;
        String memberName = !singleton ? this.myInflectorService.singularize(collectionName) : collectionName;
        return switch (action) {
            case "index", "create" -> {
                if (!singleton && this.myInflectorService.isSingular(collectionName)) {
                    yield RailsRouteUtil.joinPrefix(collectionPrefix, collectionName, "index");
                }
                yield RailsRouteUtil.joinPrefix(collectionPrefix, collectionName);
            }
            case "new" -> RailsRouteUtil.joinPrefix("new", collectionPrefix, memberName);
            case "show", "update", "destroy" -> RailsRouteUtil.joinPrefix(memberPrefix, memberName);
            case "edit" -> RailsRouteUtil.joinPrefix("edit", memberPrefix, memberName);
            default -> null;
        };
    }

    @NotNull
    String getShallowPrefix() {
        String string = RailsRouteUtil.joinPrefix(ArrayUtil.toStringArray(this.getValues(it -> it.myShallowPrefix)));
        if (string == null) {
            RailsRouteScope.$$$reportNull$$$0(25);
        }
        return string;
    }

    boolean hasScopeLevel(@NotNull String level) {
        if (level == null) {
            RailsRouteScope.$$$reportNull$$$0(26);
        }
        return this.myScopeLevel != null ? level.equals(this.myScopeLevel) : this.myParent != null && this.myParent.hasScopeLevel(level);
    }

    boolean isShallow() {
        Boolean shallow = (Boolean)ContainerUtil.getLastItem(this.getValues(it -> it.myShallow));
        return shallow != null && shallow != false;
    }

    @NotNull
    RailsRouteScope resource(@NotNull String command, @NotNull RCallArguments arguments, @Nullable String resource) {
        RPsiElement pathNames;
        if (command == null) {
            RailsRouteScope.$$$reportNull$$$0(27);
        }
        if (arguments == null) {
            RailsRouteScope.$$$reportNull$$$0(28);
        }
        String controller = (String)ObjectUtils.doIfNotNull((Object)arguments.getOptionValue("as", resource), it -> command.equals("resource") ? this.myInflectorService.pluralize((String)it) : it);
        Builder builder2 = this.builder(command).withPrefix(arguments.getOptionValue("as", resource)).withShallowPrefix(arguments.getOptionValue("shallow_prefix")).withParam((Pair<String, String>)new Pair((Object)this.myInflectorService.singularize(resource), (Object)((String)ObjectUtils.coalesce((Object)arguments.getOptionValue("param"), (Object)"id")))).withFormat(arguments.getOptionValue("format")).withModule(arguments.getOptionValue("module")).withController(arguments.getOptionValue("controller", controller)).withOnly(arguments.getOptionValues("only")).withExcept(arguments.getOptionValues("except"));
        if (arguments.hasOptionKey("path") || resource != null) {
            builder2.withPath(arguments.getOptionValue("path", resource));
        }
        if (arguments.hasOptionKey("shallow_path")) {
            builder2.withShallowPath(arguments.getOptionValue("shallow_path"));
        }
        if ((pathNames = arguments.getOptionValueElement("path_names")) != null) {
            builder2.withPathNames(RubyInterpretUtil.evaluateHashElement((PsiElement)pathNames));
        }
        if (arguments.hasOptionKey("shallow")) {
            builder2.withShallow(!"false".equals(arguments.getOptionValue("shallow")));
        }
        RailsRouteScope railsRouteScope = builder2.build();
        if (railsRouteScope == null) {
            RailsRouteScope.$$$reportNull$$$0(29);
        }
        return railsRouteScope;
    }

    @NotNull
    RailsRouteScope scope(@NotNull String command, @NotNull RCallArguments arguments) {
        RPsiElement pathNames;
        List path;
        if (command == null) {
            RailsRouteScope.$$$reportNull$$$0(30);
        }
        if (arguments == null) {
            RailsRouteScope.$$$reportNull$$$0(31);
        }
        String name = !(path = ContainerUtil.map((Collection)ContainerUtil.filter(arguments.getArguments(), argument -> !(argument instanceof RAssoc)), RubyInterpretUtil::evaluateStringOrSymbolElement)).contains(null) ? Strings.join((Collection)path, (String)"/") : null;
        String as = arguments.getOptionValue("as", command.equals("namespace") ? name : null);
        Builder builder2 = this.builder(command).withPrefix(as).withShallowPrefix(arguments.getOptionValue("shallow_prefix", as)).withFormat(arguments.getOptionValue("format")).withModule(arguments.getOptionValue("module", command.equals("namespace") ? name : null)).withController(arguments.getOptionValue("controller", command.equals("controller") ? name : null)).withAction(arguments.getOptionValue("action")).withOnly(arguments.getOptionValues("only")).withExcept(arguments.getOptionValues("except"));
        if (!command.equals("controller") && !path.isEmpty()) {
            builder2.withPath(path);
            builder2.withShallowPath(path);
        }
        if (arguments.hasOptionKey("path")) {
            builder2.withPath(arguments.getOptionValue("path"));
            builder2.withShallowPath(arguments.getOptionValue("path"));
        }
        if (arguments.hasOptionKey("shallow_path")) {
            builder2.withShallowPath(arguments.getOptionValue("shallow_path"));
        }
        if ((pathNames = arguments.getOptionValueElement("path_names")) != null) {
            builder2.withPathNames(RubyInterpretUtil.evaluateHashElement((PsiElement)pathNames));
        }
        if (command.equals("shallow") || arguments.hasOptionKey("shallow")) {
            builder2.withShallow(command.equals("shallow") || !"false".equals(arguments.getOptionValue("shallow")));
        }
        RailsRouteScope railsRouteScope = builder2.build();
        if (railsRouteScope == null) {
            RailsRouteScope.$$$reportNull$$$0(32);
        }
        return railsRouteScope;
    }

    @NotNull
    Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            RailsRouteScope.$$$reportNull$$$0(33);
        }
        return module;
    }

    @NotNull
    private List<UrlPath.PathSegment> getPathSegments(boolean isScopeAware, boolean useFullParamName, boolean alternateNew) {
        if ((this.hasScopeLevel("resources") || this.hasScopeLevel("resource")) && this.isShallow()) {
            ArrayList<UrlPath.PathSegment> segments = new ArrayList<UrlPath.PathSegment>(this.getShallowPathSegments());
            if (this.myPathSegments != null && !this.myPathSegments.isEmpty()) {
                segments.addAll(this.myPathSegments);
                if (this.hasScopeLevel("resources")) {
                    segments.add((UrlPath.PathSegment)new UrlPath.PathSegment.Variable(this.getParam(true), null));
                }
            }
            ArrayList<UrlPath.PathSegment> arrayList = segments;
            if (arrayList == null) {
                RailsRouteScope.$$$reportNull$$$0(34);
            }
            return arrayList;
        }
        ArrayList<UrlPath.PathSegment> segments = new ArrayList<UrlPath.PathSegment>();
        if (this.myParent != null) {
            segments.addAll(this.myParent.getPathSegments(true, true, false));
        }
        if (this.myPathSegments != null && !this.myPathSegments.isEmpty()) {
            segments.addAll(this.myPathSegments);
            if (isScopeAware && this.hasScopeLevel("resources")) {
                UrlPath.PathSegment.Exact segment = alternateNew ? new UrlPath.PathSegment.Exact("new") : new UrlPath.PathSegment.Variable(this.getParam(useFullParamName), null);
                segments.add((UrlPath.PathSegment)segment);
            }
        }
        ArrayList<UrlPath.PathSegment> arrayList = segments;
        if (arrayList == null) {
            RailsRouteScope.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @NotNull
    private UrlPath.PathSegment getPathName(@NotNull String action) {
        if (action == null) {
            RailsRouteScope.$$$reportNull$$$0(36);
        }
        UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)this.getValues(it -> it.myPathNameSegments).stream().flatMap(it -> Stream.ofNullable((UrlPath.PathSegment)it.get(action))).reduce((__, second) -> second).orElse(new UrlPath.PathSegment.Exact(action));
        if (pathSegment == null) {
            RailsRouteScope.$$$reportNull$$$0(37);
        }
        return pathSegment;
    }

    @NotNull
    private List<UrlPath.PathSegment> getShallowPathSegments() {
        List list = ContainerUtil.flatten(this.getValues(it -> it.myShallowPathSegments));
        if (list == null) {
            RailsRouteScope.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    private <T> List<T> getValues(@NotNull Function<RailsRouteScope, @Nullable T> mapper) {
        if (mapper == null) {
            RailsRouteScope.$$$reportNull$$$0(39);
        }
        ArrayList<T> values = new ArrayList<T>();
        RailsRouteScope current = this;
        while (current != null) {
            T value = mapper.apply(current);
            if (value != null) {
                values.add(0, value);
            }
            current = current.myParent;
        }
        ArrayList<T> arrayList = values;
        if (arrayList == null) {
            RailsRouteScope.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    private static UrlPath getPathForSegments(@NotNull List<UrlPath.PathSegment> segments, @Nullable String format) {
        if (segments == null) {
            RailsRouteScope.$$$reportNull$$$0(41);
        }
        if (!"true".equals(format) || segments.isEmpty()) {
            return new UrlPath(segments);
        }
        ArrayList<UrlPath.PathSegment> formatSegments = new ArrayList<UrlPath.PathSegment>(segments.subList(0, segments.size() - 1));
        formatSegments.add((UrlPath.PathSegment)new UrlPath.PathSegment.Composite(List.of(segments.get(segments.size() - 1), new UrlPath.PathSegment.Exact("."), new UrlPath.PathSegment.Variable("format", null))));
        return new UrlPath(formatSegments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 10, 11, 12, 13, 17, 18, 19, 20, 21, 22, 25, 29, 32, 33, 34, 35, 37, 38, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/RailsRouteScope";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 6: 
            case 9: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: 
            case 16: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RailsRouteScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionsForResource";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerFqn";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFqn";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParam";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getShallowPrefix";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resource";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "scope";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSegments";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getShallowPathSegments";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActionForMatcher";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getControllerForMatcher";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPathForMatcher";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPathForResourceAction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixForMatcher";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixForResourceAction";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasScopeLevel";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resource";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "scope";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPathName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getPathForSegments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 10, 11, 12, 13, 17, 18, 19, 20, 21, 22, 25, 29, 32, 33, 34, 35, 37, 38, 40 -> new IllegalStateException(string);
        };
    }

    static final class Builder {
        @NotNull
        private final Module myModule;
        @NotNull
        private final RailsRouteScope myParent;
        @Nullable
        private String myScopeLevel;
        @Nullable
        private String myPrefix;
        @Nullable
        private String myShallowPrefix;
        @Nullable
        private List<UrlPath.PathSegment> myPathSegments;
        @Nullable
        private List<UrlPath.PathSegment> myShallowPathSegments;
        @Nullable
        private Map<String, UrlPath.PathSegment> myPathNameSegments;
        @Nullable
        private Pair<String, String> myParam;
        @Nullable
        private String myFormat;
        @Nullable
        private String myModuleName;
        @Nullable
        private String myController;
        @Nullable
        private String myAction;
        @Nullable
        private List<String> myOnly;
        @Nullable
        private List<String> myExcept;
        @Nullable
        private Boolean myShallow;

        Builder(@NotNull Module module, @NotNull RailsRouteScope parent) {
            if (module == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myModule = module;
            this.myParent = parent;
        }

        @NotNull
        RailsRouteScope build() {
            return new RailsRouteScope(this.myModule, this.myParent, this.myScopeLevel, this.myPrefix, this.myShallowPrefix, this.myPathSegments, this.myShallowPathSegments, this.myPathNameSegments, this.myParam, this.myFormat, this.myModuleName, this.myController, this.myAction, this.myOnly, this.myExcept, this.myShallow);
        }

        @NotNull
        Builder withAction(@Nullable String action) {
            this.myAction = action;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        Builder withController(@Nullable String controller) {
            this.myController = controller;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        Builder withExcept(@Nullable List<String> except) {
            this.myExcept = except;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        Builder withFormat(@Nullable String format) {
            this.myFormat = format;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        Builder withModule(@Nullable String module) {
            this.myModuleName = module;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder2;
        }

        @NotNull
        Builder withOnly(@Nullable List<String> only) {
            this.myOnly = only;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        Builder withParam(@Nullable Pair<String, String> param) {
            this.myParam = param;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @NotNull
        Builder withPath(@Nullable String path) {
            this.myPathSegments = Builder.getPathSegments(path);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        Builder withPath(@NotNull List<@Nullable String> path) {
            if (path == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myPathSegments = ContainerUtil.flatMap(path, Builder::getPathSegments);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder2;
        }

        @NotNull
        Builder withPathNames(@Nullable Map<String, StringValue> pathNames) {
            if (pathNames == null) {
                this.myPathNameSegments = null;
                Builder builder2 = this;
                if (builder2 == null) {
                    Builder.$$$reportNull$$$0(12);
                }
                return builder2;
            }
            this.myPathNameSegments = pathNames.entrySet().stream().map(it -> {
                UrlPath.PathSegment segment = Optional.ofNullable(((StringValue)it.getValue()).getOnlyString()).map(UrlPath.PathSegment.Exact::new).orElse((UrlPath.PathSegment)UrlPath.PathSegment.Undefined.INSTANCE);
                return Map.entry((String)it.getKey(), segment);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Builder builder3 = this;
            if (builder3 == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder3;
        }

        @NotNull
        Builder withPrefix(@Nullable String prefix) {
            this.myPrefix = prefix;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder2;
        }

        @NotNull
        Builder withScopeLevel(@Nullable String level) {
            this.myScopeLevel = level;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder2;
        }

        @NotNull
        Builder withShallow(@Nullable Boolean shallow) {
            this.myShallow = shallow;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder2;
        }

        @NotNull
        Builder withShallowPath(@Nullable String shallowPath) {
            this.myShallowPathSegments = Builder.getPathSegments(shallowPath);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return builder2;
        }

        @NotNull
        Builder withShallowPath(@NotNull List<@Nullable String> shallowPath) {
            if (shallowPath == null) {
                Builder.$$$reportNull$$$0(18);
            }
            this.myShallowPathSegments = ContainerUtil.flatMap(shallowPath, Builder::getPathSegments);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(19);
            }
            return builder2;
        }

        @NotNull
        Builder withShallowPrefix(@Nullable String shallowPrefix) {
            this.myShallowPrefix = shallowPrefix;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return builder2;
        }

        @NotNull
        private static List<UrlPath.PathSegment> getPathSegments(@Nullable String path) {
            if (path == null) {
                List<UrlPath.PathSegment.Undefined> list = List.of(UrlPath.PathSegment.Undefined.INSTANCE);
                if (list == null) {
                    Builder.$$$reportNull$$$0(21);
                }
                return list;
            }
            List<UrlPath.PathSegment> list = Arrays.stream(path.split("/")).filter(StringUtil::isNotEmpty).map(it -> {
                if (it.startsWith(":")) {
                    return new UrlPath.PathSegment.Variable(it.substring(1), null);
                }
                return new UrlPath.PathSegment.Exact(it);
            }).toList();
            if (list == null) {
                Builder.$$$reportNull$$$0(22);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/RailsRouteScope$Builder";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shallowPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RailsRouteScope$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withController";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withExcept";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withFormat";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withModule";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withOnly";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withParam";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPath";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPathNames";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefix";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withScopeLevel";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withShallow";
                    break;
                }
                case 17: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withShallowPath";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withShallowPrefix";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathSegments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "withPath";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "withShallowPath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22 -> new IllegalStateException(string);
            };
        }
    }
}

