/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.routes;

import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RailsRoute {
    @Nullable
    private final String myPrefix;
    @Nullable
    private final String myVerb;
    @Nullable
    private final UrlPath myPath;
    @NotNull
    private final FQN myTarget;

    public RailsRoute(@Nullable String prefix, @Nullable String verb, @Nullable UrlPath path, @NotNull FQN target) {
        if (target == null) {
            RailsRoute.$$$reportNull$$$0(0);
        }
        this.myPrefix = prefix;
        this.myVerb = verb;
        this.myPath = path;
        this.myTarget = target;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RailsRoute other = (RailsRoute)obj;
        return Objects.equals(this.myPrefix, other.myPrefix) && Objects.equals(this.myVerb, other.myVerb) && Objects.equals(this.myPath, other.myPath) && this.myTarget.equals(other.myTarget);
    }

    @NotNull
    public List<? extends PsiElement> getNavigationTargets(@NotNull Project project, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RailsRoute.$$$reportNull$$$0(1);
        }
        List<RContainer> list = RubyFQNUtil.findContainersByFQN(project, Types.METHODS_LIKE, this.myTarget, invocationPoint);
        if (list == null) {
            RailsRoute.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public UrlPath getPath() {
        return this.myPath;
    }

    @Nullable
    public String getPrefix() {
        return this.myPrefix;
    }

    @NotNull
    public FQN getTarget() {
        FQN fQN = this.myTarget;
        if (fQN == null) {
            RailsRoute.$$$reportNull$$$0(3);
        }
        return fQN;
    }

    @Nullable
    public String getVerb() {
        return this.myVerb;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.myPrefix);
        result = 31 * result + Objects.hashCode(this.myVerb);
        result = 31 * result + Objects.hashCode(this.myPath);
        result = 31 * result + this.myTarget.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/RailsRoute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RailsRoute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

