/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public final class RubyControllerRenameHandler
extends PsiElementRenameHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @NotNull DataContext dataContext) {
        PsiElement element;
        RailsController controller;
        if (project == null) {
            RubyControllerRenameHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            RubyControllerRenameHandler.$$$reportNull$$$0(1);
        }
        if ((controller = RubyControllerRenameHandler.getControllerFromClassOrFile(element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext))) != null && controller.isApplicationController()) {
            HintManager.getInstance().showErrorHint(editor, RBundle.message((String)"refactoring.rename.application.controller"));
        } else {
            super.invoke(project, editor, file, dataContext);
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        PsiElement element;
        RailsController controller;
        if (project == null) {
            RubyControllerRenameHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            RubyControllerRenameHandler.$$$reportNull$$$0(3);
        }
        if ((controller = RubyControllerRenameHandler.getControllerFromClassOrFile(element = elements.length == 1 ? elements[0] : null)) != null && controller.isApplicationController()) {
            RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
            JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(RBundle.message((String)"refactoring.rename.application.controller"))).setFadeoutTime(5000L).setContentInsets(new Insets(15, 15, 15, 15)).setFillColor(HintUtil.getErrorColor()).createBalloon().show(point, Balloon.Position.below);
        } else {
            super.invoke(project, elements, dataContext);
        }
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext context) {
        PsiElement element;
        Module module;
        if (context == null) {
            RubyControllerRenameHandler.$$$reportNull$$$0(4);
        }
        if ((module = RModuleUtil.getInstance().getModule(context)) != null && RailsFacetUtil.hasRailsSupport(module) && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
            PsiReference[] references = element.getReferences();
            RailsController controller = null;
            if (references.length == 0) {
                controller = RubyControllerRenameHandler.getControllerFromClassOrFile(element);
            } else {
                for (PsiReference reference : references) {
                    PsiElement psiElement = reference.resolve();
                    if (!(psiElement instanceof RClass)) continue;
                    controller = RailsController.fromClass((RClass)psiElement);
                }
            }
            if (controller != null) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static RailsController getControllerFromClassOrFile(PsiElement element) {
        if (element instanceof RClass) {
            return RailsController.fromClass((RClass)element);
        }
        if (element instanceof RFile) {
            return RailsController.fromFile((PsiFile)element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RubyControllerRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

