/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.rails.refactoring.rename.RenameByRailsActionProcessor;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecViewTest;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;

public final class RenameByRailsViewFileProcessor
extends RenameProcessor {
    @Override
    public boolean canProcessElement(PsiElement element) {
        return element instanceof PsiFile && RailsView.fromFile((PsiFile)element) != null;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newFileName, Map<PsiElement, String> allRenames) {
        super.prepareRenaming(element, newFileName, allRenames);
        RailsView railsView = RailsView.fromFile((PsiFile)element);
        assert (railsView != null);
        RenameByRailsViewFileProcessor.addElementsToRenameByView(railsView, newFileName, allRenames);
    }

    public static void addElementsToRenameByView(@NotNull RailsView railsView, @NotNull String newViewFileName, @NotNull Map<PsiElement, String> allRenames) {
        if (railsView == null) {
            RenameByRailsViewFileProcessor.$$$reportNull$$$0(0);
        }
        if (newViewFileName == null) {
            RenameByRailsViewFileProcessor.$$$reportNull$$$0(1);
        }
        if (allRenames == null) {
            RenameByRailsViewFileProcessor.$$$reportNull$$$0(2);
        }
        PsiFile givenViewFile = railsView.getPsiFile();
        if (!railsView.isPartial() && ViewsConventions.isPartialViewName(newViewFileName)) {
            return;
        }
        RailsAction railsAction = railsView.getAction();
        if (railsAction != null) {
            String newViewName = ViewsConventions.getViewOrLayoutNameByFileName(FileUtilRt.getNameWithoutExtension((String)newViewFileName));
            if (!StringUtil.isEmpty((String)newViewName) && railsAction.getViewOwner().getRClass().findMethodByName(newViewName) == null) {
                allRenames.put((PsiElement)railsAction.getMethod(), newViewName);
            }
            List<RailsView> views = railsAction.getViews();
            for (RailsView view : views) {
                RailsRSpecViewTest specTest;
                PsiFile currentViewFile = view.getPsiFile();
                if (currentViewFile == null) continue;
                VirtualFile viewFileParanetDir = view.getFile().getParent();
                String newCurrViewFileName = RenameByRailsActionProcessor.getNewViewNameBy(newViewName, railsAction.getName(), currentViewFile);
                if (!currentViewFile.equals(givenViewFile)) {
                    RenameByRailsViewFileProcessor.addIfFileDoesntExist(viewFileParanetDir, newCurrViewFileName, currentViewFile, allRenames);
                    allRenames.put((PsiElement)currentViewFile, newCurrViewFileName);
                }
                if ((specTest = view.getSpecTest()) == null) continue;
                RenameByRailsViewFileProcessor.addIfFileDoesntExist(railsAction.getApp().getSpecTestsViewsRoot(), RailsRSpecViewTest.getFileNameBy(currentViewFile.equals(givenViewFile) ? newViewFileName : newCurrViewFileName), specTest.getPsiFile(), allRenames);
            }
        }
    }

    private static void addIfFileDoesntExist(@NotNull VirtualFile parentDir, @NotNull String newFileName, @Nullable PsiFile psiFile, Map<PsiElement, String> allRenames) {
        if (parentDir == null) {
            RenameByRailsViewFileProcessor.$$$reportNull$$$0(3);
        }
        if (newFileName == null) {
            RenameByRailsViewFileProcessor.$$$reportNull$$$0(4);
        }
        if (psiFile != null && parentDir.findChild(newFileName) == null) {
            allRenames.put((PsiElement)psiFile, newFileName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newViewFileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RenameByRailsViewFileProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addElementsToRenameByView";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addIfFileDoesntExist";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

