/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Map;
import org.jetbrains.plugins.ruby.rails.model.RailsMigration;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RenameByRailsMigrationProcessor
extends RenameProcessor {
    @Override
    public boolean canProcessElement(PsiElement element) {
        RContainer parent;
        return element instanceof RClass && (parent = ((RClass)element).getParentContainer()) instanceof RFile && RailsMigration.fromFile((PsiFile)((RFile)parent)) != null;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        RClass rClass = (RClass)element;
        RFile file = (RFile)rClass.getParentContainer();
        assert (file != null && RailsMigration.fromFile((PsiFile)file) != null) : "Migration cannot be null here";
        String fileName = file.getName();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        int index = fileName.lastIndexOf(NamingConventions.toUnderscoreCase((String)rClass.getName(), (Module)module) + ".rb");
        if (index != -1) {
            allRenames.put((PsiElement)file, fileName.substring(0, index) + NamingConventions.toUnderscoreCase((String)newName, (Module)module) + ".rb");
        }
    }
}

