/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.rails.refactoring.rename.RenameByRailsViewFileProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;

public final class RenameByRailsActionProcessor
extends RenameProcessor {
    @Override
    public boolean canProcessElement(PsiElement element) {
        return element instanceof RMethod && RailsAction.fromMethod((RMethod)element) != null;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        RailsAction railsAction = RailsAction.fromMethod((RMethod)element);
        assert (railsAction != null);
        String actionName = railsAction.getName();
        List<RailsView> views = railsAction.getViews();
        String firstViewNewName = null;
        RailsView firstViewObject = null;
        for (RailsView view : views) {
            PsiFile psiFile = view.getPsiFile();
            assert (psiFile != null);
            if (allRenames.containsKey(psiFile)) continue;
            String newActionName = ViewsConventions.getViewOrLayoutNameByFileName(FileUtilRt.getNameWithoutExtension((String)newName));
            String newViewFileName = RenameByRailsActionProcessor.getNewViewNameBy(newActionName, actionName, psiFile);
            if (firstViewNewName == null) {
                firstViewNewName = newViewFileName;
                firstViewObject = view;
            }
            if (psiFile.getVirtualFile().getParent().findChild(newName) != null) continue;
            allRenames.put((PsiElement)psiFile, newViewFileName);
        }
        if (firstViewNewName != null) {
            RenameByRailsViewFileProcessor.addElementsToRenameByView(firstViewObject, firstViewNewName, allRenames);
        }
    }

    public static String getNewViewNameBy(String newActionName, String currentActionName, PsiFile viewFile) {
        return viewFile.getName().replace(currentActionName, newActionName);
    }
}

