/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.AssociationCallType;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsActiveRecordAttributeSymbol;
import org.jetbrains.plugins.ruby.rails.database.RailsRubySchemaParser;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

public final class RailsVetoRenameCondition
implements Condition<PsiElement> {
    public boolean value(PsiElement element) {
        if (element instanceof RailsActiveRecordAttributeSymbol.MyPsiElement) {
            return true;
        }
        if (element instanceof AssociationCallType.MyPsiElement) {
            return true;
        }
        if (element instanceof RailsRubySchemaParser.MyColumnFakePsiElement || element instanceof RailsRubySchemaParser.MyPrimaryKeyFakePsiElement || element instanceof RailsRubySchemaParser.MyTableFakePsiElement) {
            return true;
        }
        return RailsVetoRenameCondition.isCreateTableTimestampsCall(element);
    }

    private static boolean isCreateTableTimestampsCall(@Nullable PsiElement element) {
        RBlockCall parentBlockCall = RubyPsiUtil.getContainingRBlockCall(element);
        if (!RubyPsiUtil.isCallWithCommand((PsiElement)parentBlockCall, "create_table")) {
            return false;
        }
        return RubyPsiUtil.isCallWithCommand(element, "timestamps");
    }
}

