/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.rails.nameConventions.HelpersConventions;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecControllerTest;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecHelperTest;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecModelTest;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RailsRenameUtil {
    private RailsRenameUtil() {
    }

    public static void renameControllerStuff(RailsController controller, String newControllerName, Map<PsiElement, String> allRenames) {
        PsiDirectory viewSpecsDirectory;
        VirtualFile viewSpecsFolder;
        RailsRSpecControllerTest specTest;
        RClass unitTestClass;
        RailsRenameUtil.renameRouteVariables(controller, newControllerName, allRenames);
        RClass controllerClass = controller.getRClass();
        String controllerName = controller.getName();
        String newControllerClassName = ControllersConventions.getControllerClassName(newControllerName, controller.getModule());
        if (newControllerClassName == null) {
            return;
        }
        allRenames.put((PsiElement)controllerClass, newControllerClassName);
        Module module = controller.getModule();
        String newControllerFileNameWOExtension = ControllersConventions.getControllerFileNameWithoutExtension(newControllerClassName, module);
        String newControllerFileName = ControllersConventions.getControllerFileName(newControllerClassName, module);
        RailsRenameUtil.addIfNameIfValid(newControllerFileName, controller.getPsiFile(), allRenames);
        RailsHelper helper = controller.getOwnHelper();
        if (helper != null) {
            String newHelperModuleName = HelpersConventions.getHelperModuleNameByHelperName(newControllerName, module);
            RModule helperModule = helper.getRModule();
            allRenames.put((PsiElement)helperModule, newHelperModuleName);
            RFile helperFile = helper.getPsiFile();
            if (helperFile != null) {
                String newHelperFileName = HelpersConventions.getHelperFileNameByHelperModuleName(newHelperModuleName, module);
                RailsRenameUtil.addIfNameIfValid(newHelperFileName, (PsiFile)helperFile, allRenames);
            }
        }
        for (VirtualFile folder : controller.getViewsFolders()) {
            PsiDirectory viewsFolder = controllerClass.getManager().findDirectory(folder);
            if (viewsFolder == null) continue;
            allRenames.put((PsiElement)viewsFolder, newControllerName);
        }
        RClass functionalTestClass = controller.getFunctionalTestClass();
        if (functionalTestClass != null) {
            PsiFile functionalTestFile = functionalTestClass.getContainingFile();
            String newFunctionalTestFileName = newControllerFileNameWOExtension + "_test.rb";
            RailsRenameUtil.addIfNameIfValid(newFunctionalTestFileName, functionalTestFile, allRenames);
            allRenames.put((PsiElement)functionalTestClass, newControllerClassName + "Test");
        }
        if ((unitTestClass = controller.getUnitTestClass()) != null) {
            PsiFile unitTestFile = unitTestClass.getContainingFile();
            String newUnitTestFileName = newControllerFileNameWOExtension + "_test.rb";
            RailsRenameUtil.addIfNameIfValid(newUnitTestFileName, unitTestFile, allRenames);
            allRenames.put((PsiElement)unitTestClass, newControllerClassName + "Test");
        }
        if ((specTest = controller.getSpecTest()) != null) {
            PsiFile controllerSpecTestFile = specTest.getPsiFile();
            assert (controllerSpecTestFile != null) : "Controller Spec test file cannot be null";
            String newSpecTestFileName = newControllerFileNameWOExtension + "_spec.rb";
            RailsRenameUtil.addIfNameIfValid(newSpecTestFileName, controllerSpecTestFile, allRenames);
        }
        RailsRenameUtil.renameRspecRequests(controller, newControllerName, allRenames);
        RailsRenameUtil.renameRspecRouting(controller, newControllerName, allRenames);
        if (helper != null) {
            RailsRSpecHelperTest helperSpecTest;
            RClass helperTestClass = helper.getUnitTest();
            if (helperTestClass != null) {
                PsiFile helperTestFile = helperTestClass.getContainingFile();
                String newHelperTestFileName = HelpersConventions.getHelperFileNameWithoutExtensionByHelperName(newControllerName) + "_test.rb";
                RailsRenameUtil.addIfNameIfValid(newHelperTestFileName, helperTestFile, allRenames);
                String string = HelpersConventions.getHelperModuleNameByHelperName(newControllerName, module);
                allRenames.put((PsiElement)helperTestClass, string + "Test");
            }
            if ((helperSpecTest = helper.getSpecTest()) != null) {
                PsiFile helperSpecTestFile = helperSpecTest.getPsiFile();
                assert (helperSpecTestFile != null) : "Helper Spec test file cannot be null";
                String string = HelpersConventions.getHelperFileNameWithoutExtensionByHelperName(newControllerName) + "_spec.rb";
                RailsRenameUtil.addIfNameIfValid(string, helperSpecTestFile, allRenames);
            }
        }
        if ((viewSpecsFolder = controller.getViewsSpecsFolder()) != null && (viewSpecsDirectory = controller.getPsiFile().getManager().findDirectory(viewSpecsFolder)) != null) {
            allRenames.put((PsiElement)viewSpecsDirectory, newControllerName);
        }
        List<? extends RailsLayout> layouts = controller.getAllLayouts();
        for (RailsLayout railsLayout : layouts) {
            PsiFile layoutFile;
            if (!controllerName.equals(railsLayout.getName()) || (layoutFile = railsLayout.getPsiFile()) == null) continue;
            RailsRenameUtil.addIfNameIfValid(newControllerName + layoutFile.getName().substring(controllerName.length()), layoutFile, allRenames);
        }
        RailsRenameUtil.renameAssets(controller, newControllerName, allRenames);
    }

    private static void renameRspecRequests(RailsController controller, String newControllerName, Map<PsiElement, String> allRenames) {
        VirtualFile requestSpec = controller.getRequestSpec();
        if (requestSpec != null) {
            String newSpecTestFileName = newControllerName + "_spec.rb";
            PsiFile psiFile = controller.getRClass().getManager().findFile(requestSpec);
            if (psiFile != null) {
                RailsRenameUtil.addIfNameIfValid(newSpecTestFileName, psiFile, allRenames);
            }
        }
    }

    private static void renameRspecRouting(RailsController controller, String newControllerName, Map<PsiElement, String> allRenames) {
        VirtualFile routing = controller.getRoutingSpec();
        if (routing != null) {
            String newSpecTestFileName = newControllerName + "_routing_spec.rb";
            PsiFile psiFile = controller.getRClass().getManager().findFile(routing);
            if (psiFile != null) {
                RailsRenameUtil.addIfNameIfValid(newSpecTestFileName, psiFile, allRenames);
            }
        }
    }

    private static void addIfNameIfValid(@Nullable String newName, @NotNull PsiFile psiFile, Map<PsiElement, String> allRenames) {
        if (psiFile == null) {
            RailsRenameUtil.$$$reportNull$$$0(0);
        }
        if (newName != null) {
            VirtualFile file = psiFile.getVirtualFile();
            assert (file != null);
            VirtualFile parentDir = file.getParent();
            assert (parentDir != null);
            if (parentDir.findChild(newName) == null) {
                allRenames.put((PsiElement)psiFile, newName);
            }
        }
    }

    public static void renameModelStuff(RailsModel model, String newModelName, Map<PsiElement, String> allRenames) {
        RailsRenameUtil.renameModelFixtures(model, newModelName, allRenames);
        RailsRenameUtil.renameModelUnitTest(model, newModelName, allRenames);
        RailsRenameUtil.renameModelRspecTests(model, newModelName, allRenames);
        RailsController controller = model.getController();
        if (controller != null) {
            RailsRenameUtil.renameRelatedController(model, newModelName, allRenames);
            RailsRenameUtil.renameInstanceVariablesInController(controller, newModelName, allRenames);
        }
    }

    private static void renameModelRspecTests(RailsModel model, String newModelName, Map<PsiElement, String> allRenames) {
        RailsRSpecModelTest test = model.getSpecTest();
        if (test != null) {
            VirtualFile virtualFile = test.getFile();
            String extension = virtualFile.getExtension();
            PsiFile psiFile = model.getRClass().getManager().findFile(virtualFile);
            if (psiFile != null) {
                String suffix = "_spec." + extension;
                RailsRenameUtil.addIfNameIfValid(NamingConventions.toUnderscoreCase((String)newModelName, (Module)model.getModule()) + suffix, psiFile, allRenames);
            }
        }
    }

    private static void renameRouteVariables(RailsController controller, String newControllerName, Map<PsiElement, String> allRenames) {
        RailsApp app = RailsApp.fromModule(controller.getModule());
        assert (app != null);
        GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)app.getProject(), (Collection)app.getRoutesFiles().allFiles().collect(Collectors.toList()));
        PsiReference ref = (PsiReference)ReferencesSearch.search((PsiElement)controller.getRClass(), (SearchScope)scope).findFirst();
        if (ref != null) {
            PsiElement elementToRename = PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), RCall.class);
            if (elementToRename == null) {
                return;
            }
            LinkedHashMap<PsiElement, String> temp = new LinkedHashMap<PsiElement, String>();
            temp.putAll(allRenames);
            allRenames.clear();
            allRenames.put(elementToRename, newControllerName);
            allRenames.putAll(temp);
        }
    }

    private static void renameAssets(RailsController controller, String newControllerName, Map<PsiElement, String> allRenames) {
        String newName = NamingConventions.toUnderscoreCase((String)newControllerName, (Module)controller.getModule());
        String oldName = NamingConventions.toUnderscoreCase((String)controller.getName(), (Module)controller.getModule());
        RailsApp railsApp = controller.getApp();
        for (VirtualFile assetsRoot : railsApp.getPaths().findFiles("app/assets")) {
            VirtualFile[] children;
            PsiManager psiManager = controller.getRClass().getManager();
            for (VirtualFile asset : children = assetsRoot.getChildren()) {
                VirtualFile[] files;
                if (!asset.isDirectory()) continue;
                for (VirtualFile file : files = asset.getChildren()) {
                    String fileName = file.getName();
                    String assetName = RailsRenameUtil.getAssetNameWithoutExtension(fileName);
                    if (!assetName.equals(oldName)) continue;
                    String extension = RailsRenameUtil.getAssetExtension(fileName);
                    PsiFile psiFile = psiManager.findFile(file);
                    if (psiFile != null) {
                        allRenames.put((PsiElement)psiFile, newName + extension);
                        continue;
                    }
                    PsiDirectory psiDirectory = psiManager.findDirectory(file);
                    if (psiDirectory == null) continue;
                    allRenames.put((PsiElement)psiDirectory, newName);
                }
            }
        }
    }

    private static void renameRelatedController(RailsModel model, String newModelName, Map<PsiElement, String> allRenames) {
        RailsController controller = model.getController();
        InflectorService inflectorService = InflectorService.getInstance(model.getModule());
        String newPluralModelName = inflectorService.pluralize(newModelName);
        RailsRenameUtil.renameControllerStuff(controller, newPluralModelName, allRenames);
    }

    private static void renameInstanceVariablesInController(@NotNull RailsController controller, String newModelName, Map<PsiElement, String> allRenames) {
        if (controller == null) {
            RailsRenameUtil.$$$reportNull$$$0(1);
        }
        RClass rClass = controller.getRClass();
        String pluralName = controller.getName();
        InflectorService inflector = InflectorService.getInstance(controller.getModule());
        String singularName = inflector.singularize(pluralName);
        assert (singularName != null) : "Null as a singular for [" + pluralName + "]";
        String newPluralName = inflector.pluralize(newModelName);
        Symbol controllerSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        if (controllerSymbol != null) {
            List children = Symbol.getSymbolsByFilter((Symbol)controllerSymbol, (Predicate)Symbol.Filter.byType((Type)Type.INSTANCE_FIELD), (PsiElement)rClass);
            for (Symbol child : children) {
                String newName = null;
                PsiElement psiElement = child.getPsiElement();
                String varName = child.getName();
                if (psiElement == null || varName == null) continue;
                if (varName.equals(singularName)) {
                    newName = inflector.underscore(newModelName);
                } else if (varName.equals(pluralName) && newPluralName != null) {
                    newName = inflector.underscore(newPluralName);
                } else if (varName.endsWith(singularName)) {
                    newName = varName.replace(singularName, inflector.underscore(newModelName));
                } else if (varName.endsWith(pluralName)) {
                    newName = varName.replace(pluralName, inflector.underscore(newPluralName));
                }
                if (newName == null) continue;
                allRenames.put(psiElement, newName);
            }
        }
    }

    private static String getAssetNameWithoutExtension(String fileName) {
        int index = fileName.indexOf(46);
        if (index < 0) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    private static String getAssetExtension(String fileName) {
        int index = fileName.indexOf(46);
        if (index < 0) {
            return fileName;
        }
        return fileName.substring(index);
    }

    private static void renameModelUnitTest(RailsModel model, String newName, Map<PsiElement, String> renames) {
        RClass unitTestClass = model.getUnitTestClass();
        if (unitTestClass != null) {
            PsiFile file = unitTestClass.getContainingFile();
            RailsRenameUtil.addIfNameIfValid(NamingConventions.toUnderscoreCase((String)newName, (Module)model.getModule()) + "_test.rb", file, renames);
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) {
                renames.put((PsiElement)unitTestClass, newName + "Test");
            }
        }
    }

    private static void renameModelFixtures(RailsModel model, String newName, Map<PsiElement, String> renames) {
        VirtualFile fixtureFile = model.getFixtureUnitTestFile();
        if (fixtureFile == null) {
            return;
        }
        InflectorService inflector = InflectorService.getInstance(model.getModule());
        PsiManager psiManager = model.getRClass().getManager();
        PsiFile psiFile = psiManager.findFile(fixtureFile);
        if (psiFile == null) {
            return;
        }
        String pluralized = inflector.pluralize(newName);
        String fixtureSuffix = "." + fixtureFile.getExtension();
        if (pluralized != null) {
            RailsRenameUtil.addIfNameIfValid(inflector.underscore(pluralized) + fixtureSuffix, psiFile, renames);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RailsRenameUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addIfNameIfValid";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "renameInstanceVariablesInController";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

