/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RBaseStringImpl;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RailsControllerOccurenceProcessor
implements TextOccurenceProcessor {
    protected final Processor<? super PsiReference> myPsiReferenceProcessor;
    private final String myPrefix;
    private final RClass myRClass;

    public RailsControllerOccurenceProcessor(@NotNull RailsController controller, String name, @NotNull Processor<? super PsiReference> psiReferenceProcessor) {
        if (controller == null) {
            RailsControllerOccurenceProcessor.$$$reportNull$$$0(0);
        }
        if (psiReferenceProcessor == null) {
            RailsControllerOccurenceProcessor.$$$reportNull$$$0(1);
        }
        this.myRClass = controller.getRClass();
        this.myPrefix = name + "/";
        this.myPsiReferenceProcessor = psiReferenceProcessor;
    }

    public boolean execute(final @NotNull PsiElement element, int offsetInElement) {
        if (element == null) {
            RailsControllerOccurenceProcessor.$$$reportNull$$$0(2);
        }
        if (!(element instanceof RStringLiteral)) {
            return true;
        }
        final String content = ((RStringLiteral)element).getContent();
        if (!content.startsWith(this.myPrefix)) {
            return true;
        }
        for (PsiReference ref : element.getReferences()) {
            RailsView railsView;
            PsiElement result;
            if (!(ref instanceof ParamDefReference) || !((result = ref.resolve()) instanceof PsiFile) || (railsView = RailsView.fromFile((PsiFile)result)) == null || railsView.getController() == null || railsView.getController().getRClass() != this.myRClass) continue;
            final Module module = railsView.getModule();
            if (this.myPsiReferenceProcessor.process((Object)new PsiReferenceBase<PsiElement>(element, new TextRange(1, this.myPrefix.length())){

                public PsiElement resolve() {
                    return null;
                }

                public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                    if (newElementName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String newName = NamingConventions.toUnderscoreCase((String)ControllersConventions.getControllerNameByClassName(newElementName, module), (Module)module);
                    return ((RBaseStringImpl)element).setName(newName + content.substring(RailsControllerOccurenceProcessor.this.myPrefix.length() - 1));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "org/jetbrains/plugins/ruby/rails/refactoring/rename/RailsControllerOccurenceProcessor$1", "handleElementRename"));
                }
            })) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiReferenceProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RailsControllerOccurenceProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

