/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.projectView.nodes.RailsModelAttributeNode;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.projectView.nodes.RubyFileNode;

public final class RailsTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    private final Project myProject;

    public RailsTreeStructureProvider(@NotNull Project project) {
        if (project == null) {
            RailsTreeStructureProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, @NotNull ViewSettings settings) {
        RubyFileNode node;
        RElementWithFQN rElementWithFQN;
        if (parent == null) {
            RailsTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (children == null) {
            RailsTreeStructureProvider.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            RailsTreeStructureProvider.$$$reportNull$$$0(3);
        }
        if (DumbService.isDumb((Project)this.myProject) || !settings.isShowMembers()) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                RailsTreeStructureProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }
        if (!(parent instanceof RubyFileNode) || !((rElementWithFQN = (node = (RubyFileNode)parent).getFile().getPrimaryDeclaration()) instanceof RClass)) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                RailsTreeStructureProvider.$$$reportNull$$$0(5);
            }
            return collection;
        }
        RClass declaration = (RClass)rElementWithFQN;
        ActiveRecordModel model = ActiveRecordModel.fromClass(declaration);
        Collection<AbstractTreeNode<?>> collection = model != null ? this.modifyModelChildren(model, children, settings) : children;
        if (collection == null) {
            RailsTreeStructureProvider.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    private Collection<AbstractTreeNode<?>> modifyModelChildren(@NotNull ActiveRecordModel model, @NotNull Collection<AbstractTreeNode<?>> children, @NotNull ViewSettings settings) {
        if (model == null) {
            RailsTreeStructureProvider.$$$reportNull$$$0(7);
        }
        if (children == null) {
            RailsTreeStructureProvider.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            RailsTreeStructureProvider.$$$reportNull$$$0(9);
        }
        ArrayList newChildren = new ArrayList();
        for (MigrationField field : (Collection)ObjectUtils.coalesce(model.getDBFields(), Collections.emptyList())) {
            newChildren.add((AbstractTreeNode<?>)new RailsModelAttributeNode(this.myProject, field, settings));
        }
        newChildren.addAll(children);
        ArrayList arrayList = newChildren;
        if (arrayList == null) {
            RailsTreeStructureProvider.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/projectView/RailsTreeStructureProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/projectView/RailsTreeStructureProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyModelChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "modifyModelChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 10 -> new IllegalStateException(string);
        };
    }
}

