/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.zeus;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusRunConfiguration;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusRunConfigurationType;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;

public class ZeusCommandLineState
extends RubyAbstractCommandLineState {
    @NonNls
    private static final String ZEUS_RUNNER_ID = "ruby.zeus.runner";
    private final ZeusRunConfiguration myConfig;

    protected ZeusCommandLineState(AbstractRubyRunConfiguration config, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            ZeusCommandLineState.$$$reportNull$$$0(0);
        }
        super(config, environment, true);
        this.myConfig = this.getConfig();
    }

    public ZeusRunConfiguration getConfig() {
        return (ZeusRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        ZeusRunConfiguration config = this.getConfig();
        String runnerId = this.getRunnerId();
        RubyCommandLineData data = ZeusCommandLineState.createDefaultCommandLine(config, runnerId);
        RubyCommandLine commandLine = data.getCommandLine();
        Sdk sdk = config.getSdk();
        if (sdk != null) {
            Module module = config.getModule();
            String zeusExecutable = ZeusUtil.getZeusExecutable(module, sdk);
            if (module != null && zeusExecutable != null) {
                ParamsGroup runnerParamsGroup = ZeusCommandLineState.addExecutionScriptGroup(ZEUS_RUNNER_ID, data, commandLine, zeusExecutable, sdk, module);
                this.addParameters(runnerParamsGroup);
            }
        }
        return data;
    }

    private void addParameters(ParamsGroup runnerParamsGroup) {
        String options;
        String commandName = this.myConfig.getCommandName();
        if (StringUtil.isNotEmpty((String)commandName)) {
            runnerParamsGroup.addParameter(commandName);
        }
        if (StringUtil.isNotEmpty((String)(options = this.myConfig.getArguments()))) {
            String[] tokens;
            for (String token : tokens = options.split("\\s+")) {
                runnerParamsGroup.addParameter(token);
            }
        }
    }

    @Override
    public List<Filter> createConsoleMessageFilters() {
        List<Filter> filters = super.createConsoleMessageFilters();
        ZeusRunConfiguration config = this.getConfig();
        Project project = config.getProject();
        Module module = config.getModule();
        String workingDir = module != null ? ZeusRunConfigurationType.ZeusRunConfigurationFactory.getWorkingDirectory(module) : project.getBasePath();
        ZeusCommandLineState.addConsoleFilters(filters, project, config.getSdk(), workingDir);
        return filters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/ruby/rails/preload/zeus/ZeusCommandLineState", "<init>"));
    }
}

