/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.spork.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.support.ConfigurationUIUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public class SporkServerRunConfigurationEditor
extends SettingsEditor<SporkServerRunConfiguration>
implements SporkServerRunConfigurationParams,
PanelWithAnchor {
    protected JPanel myContentPane;
    protected TextFieldWithBrowseButton myServerScriptPathTextField;
    protected LabeledComponent myServerScriptComponent;
    private JComponent myAnchor;
    private RawCommandLineEditor myServerArgsEditor;
    protected LabeledComponent myServerArgsComponent;
    private JPanel myCommonOptionsPanel;
    private JRadioButton myAttachTestUnitCB;
    private JRadioButton myAttachRSpecCB;
    private JRadioButton myAttachCucumberSpecCB;
    private JBLabel myTestFrameworkJBLabel;
    private final Project myProject;
    private final RubyCommonRunParamsEditor myCommonEditor;

    public SporkServerRunConfigurationEditor(Project project, SporkServerRunConfiguration configuration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = new RubyCommonRunParamsEditor(configuration);
        this.myCommonOptionsPanel.add((Component)this.myCommonEditor.getMainPanel(), "Center");
        this.initComponents();
        this.setupAnchor();
    }

    protected void resetEditorFrom(@NotNull SporkServerRunConfiguration config) {
        if (config == null) {
            SporkServerRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        SporkServerRunConfiguration.copyParams(config, this);
        this.myCommonEditor.resetEditorFrom(config);
    }

    protected void applyEditorTo(@NotNull SporkServerRunConfiguration config) throws ConfigurationException {
        if (config == null) {
            SporkServerRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        SporkServerRunConfiguration.copyParams(this, config);
        this.myCommonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myContentPane;
        if (jPanel == null) {
            SporkServerRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    protected void initComponents() {
        String title = RBundle.message((String)"spork.server.run.configuration.messages.select.ruby.script.path");
        ConfigurationUIUtil.addFileChooser(title, this.myServerScriptPathTextField, this.myProject);
    }

    protected LabeledComponent createScriptArgsComponent() {
        String text = RBundle.message((String)"spork.server.run.configuration.messages.script.args");
        Ref scriptArgsEditorWrapper = new Ref();
        LabeledComponent<RawCommandLineEditor> myComponent = RunConfigurationUIUtil.createRawEditorComponent((Ref<? super RawCommandLineEditor>)scriptArgsEditorWrapper, text);
        this.myServerArgsEditor = (RawCommandLineEditor)scriptArgsEditorWrapper.get();
        return myComponent;
    }

    private void createUIComponents() {
        this.myServerArgsComponent = this.createScriptArgsComponent();
        Ref scriptTextFieldWrapper = new Ref();
        this.myServerScriptComponent = RunConfigurationUIUtil.createScriptPathComponent((Ref<? super TextFieldWithBrowseButton>)scriptTextFieldWrapper, RBundle.message((String)"spork.server.run.configuration.messages.script.path"));
        this.myServerScriptPathTextField = (TextFieldWithBrowseButton)scriptTextFieldWrapper.get();
    }

    @Override
    @NotNull
    public String getScriptPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myServerScriptPathTextField.getText().trim());
        if (string == null) {
            SporkServerRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getScriptArgs() {
        String string = this.myServerArgsEditor.getText().trim();
        if (string == null) {
            SporkServerRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setScriptPath(String value) {
        this.myServerScriptPathTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)value)));
    }

    @Override
    public void setScriptArgs(String value) {
        this.myServerArgsEditor.setText(value);
    }

    @Override
    public SupportedTestFramework getTestFramework() {
        if (this.myAttachTestUnitCB.isSelected()) {
            return SupportedTestFramework.TEST_UNIT;
        }
        if (this.myAttachCucumberSpecCB.isSelected()) {
            return SupportedTestFramework.CUCUMBER;
        }
        if (this.myAttachRSpecCB.isSelected()) {
            return SupportedTestFramework.RSPEC;
        }
        return SupportedTestFramework.RSPEC;
    }

    @Override
    public void setTestFramework(@NotNull SupportedTestFramework framework) {
        if (framework == null) {
            SporkServerRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        if (":test_spec".equals(framework.getFrameworkId())) {
            return;
        }
        JRadioButton button = switch (framework) {
            case SupportedTestFramework.TEST_UNIT -> this.myAttachTestUnitCB;
            case SupportedTestFramework.RSPEC -> this.myAttachRSpecCB;
            case SupportedTestFramework.CUCUMBER -> this.myAttachCucumberSpecCB;
            default -> throw new IllegalArgumentException("Unexpected option: " + String.valueOf((Object)framework));
        };
        button.setSelected(true);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myServerArgsComponent.setAnchor(anchor);
        this.myServerScriptComponent.setAnchor(anchor);
        this.myCommonEditor.setAnchor(anchor);
        this.myTestFrameworkJBLabel.setAnchor(anchor);
    }

    private void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonEditor, this.myServerArgsComponent, this.myServerScriptComponent});
        if (this.myTestFrameworkJBLabel.getPreferredSize().getWidth() <= this.myAnchor.getPreferredSize().getWidth()) {
            this.myTestFrameworkJBLabel.setAnchor(this.myAnchor);
            return;
        }
        this.setAnchor((JComponent)this.myTestFrameworkJBLabel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTestFrameworkJBLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RBundle", SporkServerRunConfigurationEditor.class).getString("spork.run.configuration.settings.framework"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAttachCucumberSpecCB = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/RBundle", SporkServerRunConfigurationEditor.class).getString("spork.run.settings.cucumber"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAttachRSpecCB = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/RBundle", SporkServerRunConfigurationEditor.class).getString("spork.run.settings.rspec"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAttachTestUnitCB = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/RBundle", SporkServerRunConfigurationEditor.class).getString("spork.run.settings.testunit"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        LabeledComponent labeledComponent = this.myServerScriptComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", SporkServerRunConfigurationEditor.class).getString("spork.server.run.configuration.messages.script.path"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent2 = this.myServerArgsComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", SporkServerRunConfigurationEditor.class).getString("spork.server.run.configuration.messages.script.args"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(5, 0, 1, 2, 0, 1, 0, 3, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(7, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/preload/spork/run/SporkServerRunConfigurationEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/spork/run/SporkServerRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTestFramework";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

