/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.spork.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public class SporkServerRunCommandLineState
extends RubyAbstractCommandLineState {
    @NonNls
    private static final String SPORK_SERVER_PARAMS_GROUP_ID = "ruby.spork.run.script";

    public SporkServerRunCommandLineState(@NotNull SporkServerRunConfiguration config, @NotNull ExecutionEnvironment env) {
        if (config == null) {
            SporkServerRunCommandLineState.$$$reportNull$$$0(0);
        }
        if (env == null) {
            SporkServerRunCommandLineState.$$$reportNull$$$0(1);
        }
        super(config, env, false);
    }

    public SporkServerRunConfiguration getConfig() {
        return (SporkServerRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        SporkServerRunConfiguration config = this.getConfig();
        RubyCommandLineData data = SporkServerRunCommandLineState.createDefaultCommandLine(config, this.getRunnerId());
        RubyCommandLine commandLine = data.getCommandLine();
        ParamsGroup scriptParamsGroup = this.addExecutionScriptGroup(SPORK_SERVER_PARAMS_GROUP_ID, data, commandLine, config.getScriptPath());
        SupportedTestFramework testFramework = config.getTestFramework();
        Sdk sdk = config.getSdk();
        assert (sdk != null);
        String parameter = switch (testFramework) {
            case SupportedTestFramework.RSPEC -> "rspec";
            case SupportedTestFramework.CUCUMBER -> "cucumber";
            case SupportedTestFramework.TEST_UNIT -> "testunit";
            default -> throw new ExecutionException(RBundle.message((String)"spork.server.run.unexpected.framework.exception", (Object[])new Object[]{testFramework.name()}));
        };
        scriptParamsGroup.addParameter(parameter);
        SporkServerRunCommandLineState.addParams(scriptParamsGroup, config.getScriptArgs());
        return data;
    }

    @Override
    public List<Filter> createConsoleMessageFilters() {
        List<Filter> filters = super.createConsoleMessageFilters();
        SporkServerRunConfiguration config = this.getConfig();
        SporkServerRunCommandLineState.addConsoleFilters(filters, config.getProject(), config.getSdk(), VfsUtil.getParentDir((String)config.getScriptPath()));
        return filters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "config";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/rails/preload/spork/run/SporkServerRunCommandLineState";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

