/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryUi;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchService;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyProcessHandlerEx;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public final class PreLoadUtil {
    private static final String SPORK_DEBUGGING_INFO_SHOWN = "spork.debugging.info.shown";
    private static final String ZEUS_DEBUGGING_INFO_SHOWN = "zeus.debugging.info.shown";
    private static final String SPRING_DEBUGGING_INFO_SHOWN = "spring.debugging.info.shown";
    public static final String SPORK_MODE_CUCUMBER = "cucumber";
    public static final String SPORK_MODE_RSPEC = "rspec";
    public static final String SPORK_MODE_TESTUNIT_OR_SHOULDA = "testunit";
    public static final String SPORK_OPTION_BOOTSTRAP = "--bootstrap";
    public static final String SPORK = "spork";
    public static final String MILHOUSE_SPORK_GEM_NAME = "milhouse-spork";
    public static final String SPORK_GEM_EXECUTABLE = "spork";
    private static final String SPORK_TESTUNIT_GEM_NAME = "spork-testunit";
    private static final String SPORK_TESTUNIT_GEM_EXECUTABLE = "testdrb";
    private static final String SPORK_WIN_MINIMAL_SUPPORTED_VERSION = "0.8.3";

    private PreLoadUtil() {
    }

    public static boolean isSporkGemInstalled(Sdk sdk) {
        return PreLoadUtil.getAttachedOrLatestInstalledSporkGem(sdk) != null;
    }

    public static boolean isSporkSupportEnabled() {
        return Registry.is((String)"spork.preload.server.support");
    }

    public static void checkPreloadServerSupportEnabled(@NotNull PreLoadServer preloadServer) throws RuntimeConfigurationWarning {
        if (preloadServer == null) {
            PreLoadUtil.$$$reportNull$$$0(0);
        }
        if (preloadServer == PreLoadServer.Zeus && !ZeusUtil.isZeusSupportEnabled()) {
            throw new RuntimeConfigurationWarning(RBundle.message((String)"zeus.server.run.configuration.retirement.warning"), () -> new RegistryUi().show());
        }
        if (preloadServer == PreLoadServer.DRb && !PreLoadUtil.isSporkSupportEnabled()) {
            throw new RuntimeConfigurationWarning(RBundle.message((String)"spork.server.run.configuration.retirement.warning"), () -> new RegistryUi().show());
        }
    }

    @Nullable
    public static String getSporkExecutablePath(Module module) {
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        GemInfo sporkGem = PreLoadUtil.getAttachedOrLatestInstalledSporkGem(module);
        if (sporkGem == null) {
            sporkGem = PreLoadUtil.getAttachedOrLatestInstalledSporkGem(sdk);
        }
        if (sporkGem == null) {
            return null;
        }
        return RubyGemExecutionContext.getScriptPath(sdk, module, sporkGem.getName(), "spork");
    }

    private static boolean isPreLoadServerRunning(@NotNull Project project, @NotNull String serverName) {
        Pattern serverNamePattern;
        if (project == null) {
            PreLoadUtil.$$$reportNull$$$0(1);
        }
        if (serverName == null) {
            PreLoadUtil.$$$reportNull$$$0(2);
        }
        return !ExecutionHelper.findRunningConsole((Project)project, arg_0 -> PreLoadUtil.lambda$isPreLoadServerRunning$2(serverNamePattern = Pattern.compile(serverName), arg_0)).isEmpty();
    }

    @Nullable
    private static GemInfo getAttachedOrLatestInstalledSporkGem(@Nullable Object moduleOrSdk) {
        GemInfo spork;
        if (moduleOrSdk == null) {
            return null;
        }
        boolean isModule = moduleOrSdk instanceof Module;
        if (!isModule && !(moduleOrSdk instanceof Sdk)) {
            throw new IllegalArgumentException("Module or Sdk expected, but was: " + moduleOrSdk.getClass().getName());
        }
        GemInfo gemInfo = spork = isModule ? RubyProjectGemSearchService.Companion.findGem((Module)moduleOrSdk, "spork") : (GemInfo)ContainerUtil.getFirstItem(RubyGemSearchService.getInstance().findGems((Sdk)moduleOrSdk, "spork"));
        if (SystemInfo.isWindows) {
            if (spork != null && VersionComparatorUtil.compare((String)spork.getVersion(), (String)SPORK_WIN_MINIMAL_SUPPORTED_VERSION) >= 0) {
                return spork;
            }
            return isModule ? RubyProjectGemSearchService.Companion.findGem((Module)moduleOrSdk, MILHOUSE_SPORK_GEM_NAME) : (GemInfo)ContainerUtil.getFirstItem(RubyGemSearchService.getInstance().findGems((Sdk)moduleOrSdk, MILHOUSE_SPORK_GEM_NAME));
        }
        return spork;
    }

    @Nullable
    public static String determinePreferredTUnitSporkDrbRunnerExecutablePath(@Nullable Module module, @Nullable Sdk alternativeSdk) {
        Sdk sdk;
        Object object = alternativeSdk == null ? (module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null) : (sdk = alternativeSdk);
        if (sdk != null) {
            return PreLoadUtil.getTUnitSporkDrbRunnerExecutablePath(module, sdk);
        }
        return null;
    }

    @Nullable
    private static String getTUnitSporkDrbRunnerExecutablePath(@Nullable Module module, @NotNull Sdk sdk) {
        GemInfo gemInfo;
        if (sdk == null) {
            PreLoadUtil.$$$reportNull$$$0(3);
        }
        GemInfo gemInfo2 = gemInfo = (gemInfo = PreLoadUtil.getAttachedSporkTUnitGem(module)) == null ? RubyGemSearchUtil.findGem(module, sdk, SPORK_TESTUNIT_GEM_NAME) : gemInfo;
        if (gemInfo == null) {
            return null;
        }
        return RubyGemExecutionContext.getScriptPath(sdk, module, SPORK_TESTUNIT_GEM_NAME, SPORK_TESTUNIT_GEM_EXECUTABLE);
    }

    @Nullable
    private static GemInfo getAttachedSporkTUnitGem(@Nullable Module module) {
        return module == null ? null : RubyProjectGemSearchService.Companion.findGem(module, SPORK_TESTUNIT_GEM_NAME);
    }

    public static void showDebuggingInfo(@NotNull Project project, @NotNull PreLoadServer server) {
        String topicId;
        String message;
        if (project == null) {
            PreLoadUtil.$$$reportNull$$$0(4);
        }
        if (server == null) {
            PreLoadUtil.$$$reportNull$$$0(5);
        }
        if (!(server == PreLoadServer.DRb && !PropertiesComponent.getInstance((Project)project).isValueSet(SPORK_DEBUGGING_INFO_SHOWN) || server == PreLoadServer.Zeus && !PropertiesComponent.getInstance((Project)project).isValueSet(ZEUS_DEBUGGING_INFO_SHOWN) || server == PreLoadServer.Spring && !PropertiesComponent.getInstance((Project)project).isValueSet(SPRING_DEBUGGING_INFO_SHOWN))) {
            return;
        }
        switch (server) {
            case Zeus: {
                message = RBundle.message((String)"popup.content.debug.zeus.enabled");
                topicId = "Using_Zeus_Server";
                PropertiesComponent.getInstance((Project)project).setValue(ZEUS_DEBUGGING_INFO_SHOWN, "true");
                break;
            }
            case DRb: {
                message = RBundle.message((String)"popup.content.debug.drb.enabled");
                topicId = "topicId431769";
                PropertiesComponent.getInstance((Project)project).setValue(SPORK_DEBUGGING_INFO_SHOWN, "true");
                break;
            }
            case Spring: {
                message = RBundle.message((String)"popup.content.debug.spring.enabled");
                topicId = "Using_Spring_Server";
                PropertiesComponent.getInstance((Project)project).setValue(SPRING_DEBUGGING_INFO_SHOWN, "true");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected pre-load server " + String.valueOf((Object)server));
            }
        }
        Notification notification = new Notification("Ruby Preloader Warning", message, NotificationType.WARNING);
        notification.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"action.more.information.text")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                HelpManager.getInstance().invokeHelp(topicId);
                Notification.get((AnActionEvent)e).expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/rails/preload/PreLoadUtil$1", "actionPerformed"));
            }
        });
        notification.notify(project);
    }

    private static /* synthetic */ Boolean lambda$isPreLoadServerRunning$2(Pattern serverNamePattern, RunContentDescriptor selectedContent) {
        ProcessHandler processHandler = selectedContent.getProcessHandler();
        if (processHandler instanceof RubyProcessHandlerEx && !processHandler.isProcessTerminated()) {
            String commandLine = ((RubyProcessHandlerEx)processHandler).getCommandLine();
            return commandLine != null && serverNamePattern.matcher(FileUtil.toSystemIndependentName((String)commandLine)).find();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preloadServer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/PreLoadUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPreloadServerSupportEnabled";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPreLoadServerRunning";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTUnitSporkDrbRunnerExecutablePath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showDebuggingInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum PreLoadServer {
        None("None", CommonBundle.message((String)"action.text.none", (Object[])new Object[0])){

            @Override
            public boolean isRunning(@Nullable Module module) {
                return false;
            }
        }
        ,
        DRb("spork", RBundle.message((String)"spork.run.drb")){

            @Override
            public boolean isRunning(@Nullable Module module) {
                return module != null && PreLoadUtil.isPreLoadServerRunning(module.getProject(), this.getExecutableName());
            }
        }
        ,
        Zeus("zeus", RBundle.message((String)"zeus.server.name")){

            @Override
            public boolean isRunning(@Nullable Module module) {
                return module != null && PreLoadUtil.isPreLoadServerRunning(module.getProject(), this.getExecutableName());
            }
        }
        ,
        Spring("spring", RBundle.message((String)"spring.pre.loader.name")){

            @Override
            public boolean isRunning(@Nullable Module module) {
                return false;
            }

            @Override
            public boolean isRunning(@Nullable Module module, @NotNull SupportedTestFramework framework) {
                if (framework == null) {
                    4.$$$reportNull$$$0(0);
                }
                return SpringUtil.isTestFrameworkEnabled(module, framework);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "org/jetbrains/plugins/ruby/rails/preload/PreLoadUtil$PreLoadServer$4", "isRunning"));
            }
        };

        @NotNull
        private final String myExecutableName;
        private final String myDisplayName;

        private PreLoadServer(String executableName, String displayName) {
            if (executableName == null) {
                PreLoadServer.$$$reportNull$$$0(0);
            }
            if (displayName == null) {
                PreLoadServer.$$$reportNull$$$0(1);
            }
            this.myExecutableName = executableName;
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getExecutableName() {
            String string = this.myExecutableName;
            if (string == null) {
                PreLoadServer.$$$reportNull$$$0(2);
            }
            return string;
        }

        public abstract boolean isRunning(@Nullable Module var1);

        public boolean isRunning(@Nullable Module module, @NotNull SupportedTestFramework framework) {
            if (framework == null) {
                PreLoadServer.$$$reportNull$$$0(3);
            }
            return this.isRunning(module);
        }

        public String toString() {
            return this.myDisplayName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/preload/PreLoadUtil$PreLoadServer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "framework";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/PreLoadUtil$PreLoadServer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExecutableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isRunning";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

