/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.nameConventions;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbFileType;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.langs.RJSFileType;
import org.jetbrains.plugins.ruby.rails.langs.RXMLFileType;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public final class ViewsConventions {
    private ViewsConventions() {
    }

    public static boolean isErbFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof ErbFileType;
    }

    public static boolean isHTMLFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof HtmlFileType;
    }

    public static boolean isRJSFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof RJSFileType;
    }

    public static boolean isTemplateFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return ViewsConventions.isTemplateFileType(fileType);
    }

    public static boolean isTemplateFileType(FileType fileType) {
        return TemplateIntegrationUtils.getInstance().isTemplateFile(fileType);
    }

    public static boolean isValidRubyBasedViewTemplate(@NotNull VirtualFile file) {
        FileType type;
        if (file == null) {
            ViewsConventions.$$$reportNull$$$0(0);
        }
        return (type = file.getFileType()) instanceof ErbFileType || ViewsConventions.isTemplateFileType(type) || type instanceof RJSFileType || type instanceof RXMLFileType || "rabl".equals(file.getExtension()) || "jbuilder".equals(file.getExtension());
    }

    public static boolean isRXMLFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof RXMLFileType;
    }

    @Nullable
    public static String getRelativePathOfLayoutsFolder(@Nullable String fileUrl, @NotNull Module module) {
        if (module == null) {
            ViewsConventions.$$$reportNull$$$0(1);
        }
        if (fileUrl == null) {
            return null;
        }
        for (String root : RailsPaths.getInstance(module).getUrls("app/views", "layouts")) {
            if (!VfsUtilCore.isEqualOrAncestor((String)root, (String)fileUrl)) continue;
            return VirtualFileUtil.getRelativePath(fileUrl, root);
        }
        return null;
    }

    @Nullable
    public static String getRelativePathOfViewsFolder(@Nullable String fileUrl, @NotNull Module module) {
        if (module == null) {
            ViewsConventions.$$$reportNull$$$0(2);
        }
        return fileUrl != null ? RailsPaths.getInstance(module).getRelativePath("app/views", fileUrl) : null;
    }

    public static List<VirtualFile> findPartialViews(@Nullable VirtualFile folder) {
        ArrayList<VirtualFile> partials = new ArrayList<VirtualFile>();
        if (folder != null) {
            for (VirtualFile file : folder.getChildren()) {
                if (!ViewsConventions.isValidPartialViewFile(file)) continue;
                partials.add(file);
            }
        }
        return partials;
    }

    public static boolean isValidPartialViewFile(@NotNull VirtualFile file) {
        if (file == null) {
            ViewsConventions.$$$reportNull$$$0(3);
        }
        String ext = file.getExtension();
        String name = file.getName();
        return !file.isDirectory() && !StringUtil.isEmpty((String)ext) && ViewsConventions.isPartialViewName(name);
    }

    public static boolean isPartialViewName(@NotNull String fileName) {
        if (fileName == null) {
            ViewsConventions.$$$reportNull$$$0(4);
        }
        return fileName.startsWith("_");
    }

    public static boolean hasValidTemplatePath(@NotNull String viewOrLayotFileUrl, @NotNull RailsPaths settings) {
        if (viewOrLayotFileUrl == null) {
            ViewsConventions.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            ViewsConventions.$$$reportNull$$$0(6);
        }
        return VfsUtilCore.isUnder((String)viewOrLayotFileUrl, settings.getUrls("app/views"));
    }

    public static boolean isValidLayoutFileName(String fileName) {
        return ViewsConventions.isErbFile(fileName) || ViewsConventions.isRXMLFile(fileName) || ViewsConventions.isTemplateFile(fileName);
    }

    public static boolean isApplicationLayoutFile(VirtualFile layout) {
        return "application".equals(ViewsConventions.getViewOrLayoutNameByFileName(layout.getNameWithoutExtension())) && ViewsConventions.isLayoutFile(layout);
    }

    public static boolean isLayoutFile(@Nullable VirtualFile fileOrDir) {
        return fileOrDir != null && !fileOrDir.isDirectory() && ViewsConventions.isValidLayoutFileName(fileOrDir.getName());
    }

    @NotNull
    public static String getActionMethodNameByView(@NotNull VirtualFile viewFile) {
        if (viewFile == null) {
            ViewsConventions.$$$reportNull$$$0(7);
        }
        return ViewsConventions.getViewOrLayoutNameByFileName(viewFile.getName());
    }

    @NotNull
    public static String getViewOrLayoutNameByFileName(@NotNull String viewFileName) {
        int pos;
        if (viewFileName == null) {
            ViewsConventions.$$$reportNull$$$0(8);
        }
        if ((pos = viewFileName.indexOf(46)) > 0) {
            String string = viewFileName.substring(0, pos);
            if (string == null) {
                ViewsConventions.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = viewFileName;
        if (string == null) {
            ViewsConventions.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static List<String> getViewExtensions(@NotNull String viewFileName) {
        if (viewFileName == null) {
            ViewsConventions.$$$reportNull$$$0(11);
        }
        if (viewFileName.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ViewsConventions.$$$reportNull$$$0(12);
            }
            return list;
        }
        int pos = viewFileName.indexOf(46, 1);
        if (pos <= 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ViewsConventions.$$$reportNull$$$0(13);
            }
            return list;
        }
        String exts = viewFileName.substring(pos + 1);
        if (exts.indexOf(46) == -1) {
            List<String> list = Collections.singletonList(exts);
            if (list == null) {
                ViewsConventions.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = StringUtil.split((String)exts, (String)".");
        if (list == null) {
            ViewsConventions.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOrLayotFileUrl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFile";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFileName";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/nameConventions/ViewsConventions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/nameConventions/ViewsConventions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewOrLayoutNameByFileName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidRubyBasedViewTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathOfLayoutsFolder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathOfViewsFolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidPartialViewFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPartialViewName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasValidTemplatePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActionMethodNameByView";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getViewOrLayoutNameByFileName";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getViewExtensions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

