/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.nameConventions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.StringTokenizer;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.nameConventions.HelpersConventions;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class ControllersConventions {
    @Nullable
    public static String getControllerName(VirtualFile controller) {
        return ControllersConventions.getControllerName(controller.getName());
    }

    @Nullable
    public static String getControllerName(@NotNull String controllerFileName) {
        String name;
        if (controllerFileName == null) {
            ControllersConventions.$$$reportNull$$$0(0);
        }
        if (!(name = FileUtilRt.getNameWithoutExtension((String)controllerFileName)).endsWith("_controller")) {
            return null;
        }
        return name.substring(0, name.length() - "_controller".length());
    }

    @Nullable
    public static String getControllerNameByClassName(@Nullable String className, @Nullable Module module) {
        if (className == null) {
            return null;
        }
        String name = NamingConventions.toUnderscoreCase((String)className, (Module)module);
        if (!name.endsWith("_controller")) {
            return null;
        }
        return name.substring(0, name.length() - "Controller".length() - 1);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    public static String getControllerClassName(@Nullable String controllerName, @Nullable Module module) {
        if (controllerName == null) {
            return null;
        }
        return NamingConventions.toCamelCase((String)controllerName, (Module)module) + "Controller";
    }

    @Nullable
    public static String getControllerFileName(@Nullable String controllerClassName, Module module) {
        if (controllerClassName == null) {
            return null;
        }
        return String.format("%s.%s", ControllersConventions.getControllerFileNameWithoutExtension(controllerClassName, module), RubyFileType.RUBY.getDefaultExtension());
    }

    @NotNull
    public static String getControllerFileNameWithoutExtension(@NotNull String controllerClassName, @Nullable Module module) {
        if (controllerClassName == null) {
            ControllersConventions.$$$reportNull$$$0(1);
        }
        StringBuilder builder2 = new StringBuilder();
        if ("ApplicationController".equals(controllerClassName)) {
            builder2.append("application_controller");
        } else {
            builder2.append(NamingConventions.toUnderscoreCase((String)controllerClassName, (Module)module));
        }
        String string = builder2.toString();
        if (string == null) {
            ControllersConventions.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isApplicationControllerFile(@NotNull VirtualFile controller, Module module) {
        if (controller == null) {
            ControllersConventions.$$$reportNull$$$0(3);
        }
        if (!"application_controller".equals(controller.getNameWithoutExtension())) {
            return false;
        }
        return VfsUtilCore.isUnderFiles((VirtualFile)controller, RailsPaths.getInstance(module).findFiles("app/controllers"));
    }

    @Nullable
    public static String getControllerCorrespondingDir(@NotNull String dirUrl, @NotNull Module module) {
        if (dirUrl == null) {
            ControllersConventions.$$$reportNull$$$0(4);
        }
        if (module == null) {
            ControllersConventions.$$$reportNull$$$0(5);
        }
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        RailsPaths paths = RailsPaths.getInstance(module);
        StandardRailsPaths staticPaths = RailsFacetUtil.getRailsAppStaticPaths(module);
        assert (staticPaths != null);
        if (VfsUtilCore.isUnder((String)dirUrl, paths.getUrls("app/controllers"))) {
            return dirUrl;
        }
        if (VfsUtilCore.isUnder((String)dirUrl, paths.getUrls("app/helpers"))) {
            return HelpersConventions.getRelativePathOfHelperFolder(dirUrl, module);
        }
        if (VfsUtilCore.isUnder((String)dirUrl, paths.getUrls("app/views", "layouts"))) {
            return ViewsConventions.getRelativePathOfLayoutsFolder(dirUrl, module);
        }
        if (VfsUtilCore.isUnder((String)dirUrl, paths.getUrls("app/views"))) {
            return ViewsConventions.getRelativePathOfViewsFolder(dirUrl, module);
        }
        return null;
    }

    public static boolean isValidActionName(@Nullable String name) {
        return NamingConventions.isInUnderscoredCase((String)name) && name.charAt(0) != '_';
    }

    @Nullable
    public static String getRelativePathOfControllerFolder(@NotNull String fileUrl, @NotNull Module module) {
        if (fileUrl == null) {
            ControllersConventions.$$$reportNull$$$0(6);
        }
        if (module == null) {
            ControllersConventions.$$$reportNull$$$0(7);
        }
        return RailsPaths.getInstance(module).getRelativePath("app/controllers", fileUrl);
    }

    @Nullable
    public static String getControllerQualifiedNameByViewUrl(@NotNull Collection<String> viewRootUrls, @NotNull String viewFileUrl) {
        if (viewRootUrls == null) {
            ControllersConventions.$$$reportNull$$$0(8);
        }
        if (viewFileUrl == null) {
            ControllersConventions.$$$reportNull$$$0(9);
        }
        String viewRoot = null;
        for (String candidate : viewRootUrls) {
            if (!viewFileUrl.startsWith(candidate)) continue;
            viewRoot = candidate;
            break;
        }
        if (viewRoot == null) {
            return null;
        }
        String name = StringUtil.substringBeforeLast((String)StringUtil.trimStart((String)viewFileUrl, viewRoot), (String)"/");
        return !name.isBlank() ? name : null;
    }

    @Nullable
    public static RClass getControllerByViewFile(Module module, VirtualFile viewFile) {
        RailsPaths paths;
        String fileUrl = viewFile.getUrl();
        if (!ViewsConventions.hasValidTemplatePath(fileUrl, paths = RailsPaths.getInstance(module))) {
            return null;
        }
        String qualifiedName = ControllersConventions.getControllerQualifiedNameByViewUrl(paths.getUrls("app/views"), fileUrl);
        if (qualifiedName == null) {
            return null;
        }
        RailsController controller = RailsController.fromQualifiedName(module, qualifiedName);
        return controller != null ? controller.getRClass() : null;
    }

    public static boolean isCompositeControllerNameValid(@NotNull String name) {
        boolean isValid;
        if (name == null) {
            ControllersConventions.$$$reportNull$$$0(10);
        }
        StringTokenizer st = new StringTokenizer(name, String.valueOf('/'));
        boolean bl = isValid = !name.isEmpty();
        while (st.hasMoreTokens() && isValid) {
            String token = st.nextToken();
            isValid = NamingConventions.isInUnderscoredCase((String)token);
        }
        return isValid;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerFileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/nameConventions/ControllersConventions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirUrl";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRootUrls";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFileUrl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/nameConventions/ControllersConventions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerFileNameWithoutExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getControllerName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getControllerFileNameWithoutExtension";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicationControllerFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getControllerCorrespondingDir";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathOfControllerFolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getControllerQualifiedNameByViewUrl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCompositeControllerNameValid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

