/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.facet.Facet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsLayoutOrView;
import org.jetbrains.plugins.ruby.rails.model.RailsPartialView;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecViewTest;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RailsView
extends RailsFileItem
implements RailsLayoutOrView {
    private final RailsController myController;

    RailsView(VirtualFile viewFile, Module module, RailsController controller) {
        super(viewFile, module);
        this.myController = controller;
    }

    @Nullable
    public static RailsView fromFile(PsiFile file) {
        VirtualFile vFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)file);
        return vFile == null ? null : RailsView.fromFile(vFile, ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
    }

    @Nullable
    public static RailsView fromFile(@NotNull VirtualFile file, @Nullable Module module) {
        RailsController controller;
        if (file == null) {
            RailsView.$$$reportNull$$$0(0);
        }
        if (file.getParent() == null || file.isDirectory() || module == null || !RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        BaseRailsFacetConfiguration config = (BaseRailsFacetConfiguration)ObjectUtils.doIfNotNull((Object)((Object)BaseRailsFacet.getInstance(module)), Facet::getConfiguration);
        if (config == null) {
            return null;
        }
        if (!VfsUtilCore.isUnderFiles((VirtualFile)file, RailsPaths.getInstance(module).findFiles("app/views"))) {
            return null;
        }
        if (VfsUtilCore.isUnderFiles((VirtualFile)file, RailsPaths.getInstance(module).findFiles("app/views", "shared"))) {
            return null;
        }
        RClass rClass = ControllersConventions.getControllerByViewFile(module, file);
        if (rClass != null) {
            controller = RailsController.fromClass(rClass, RailsApp.fromModule(module));
        } else if (!VfsUtilCore.isUnderFiles((VirtualFile)file, RailsPaths.getInstance(module).findFiles("app/views", "layouts"))) {
            controller = RailsPartialView.createControllerByPartialView(file, module);
        } else {
            return null;
        }
        return new RailsView(file, module, controller);
    }

    @Override
    @Nullable
    public RailsController getController() {
        return this.myController;
    }

    @Nullable
    public RailsAction getAction() {
        RailsController controller = this.getController();
        if (controller == null) {
            return null;
        }
        String nameWithoutExt = FileUtilRt.getNameWithoutExtension((String)this.myFile.getName());
        String view_name = ViewsConventions.getViewOrLayoutNameByFileName(nameWithoutExt);
        RMethod actionMethod = RubyPsiUtil.getMethodWithPossibleZeroArgsByName((RContainer)controller.myClass, view_name);
        return actionMethod != null ? RailsAction.fromControllerMethod(controller, actionMethod) : null;
    }

    @Nullable
    public RailsRSpecViewTest getSpecTest() {
        return RailsRSpecViewTest.fromView(this);
    }

    public String toString() {
        return this.myFile.getName();
    }

    @Override
    public boolean isPartial() {
        return RailsPartialView.fromView(this) != null;
    }

    @Override
    public RailsViewOwner getViewOwner() {
        return this.myController;
    }

    @Override
    public RMethod getMethod() {
        RailsAction action = this.getAction();
        return action != null ? action.getMethod() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/rails/model/RailsView", "fromFile"));
    }
}

