/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public class RailsPartialView
extends RailsFileItem
implements RailsBaseView {
    private final RailsController myController;

    RailsPartialView(VirtualFile viewFile, Module module, RailsController controller) {
        super(viewFile, module);
        this.myController = controller;
    }

    @Nullable
    public static RailsPartialView fromFile(PsiFile file) {
        VirtualFile vFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)file);
        return vFile == null ? null : RailsPartialView.fromFile(vFile, ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
    }

    @Nullable
    public static RailsPartialView fromView(RailsView view) {
        VirtualFile viewFile = view.getFile();
        if (!RailsPartialView.validatePartialName(viewFile)) {
            return null;
        }
        Module module = view.getModule();
        RailsController controller = view.getController();
        return new RailsPartialView(viewFile, module, controller);
    }

    @Nullable
    public static RailsPartialView fromFile(@NotNull VirtualFile file, @Nullable Module module) {
        if (file == null) {
            RailsPartialView.$$$reportNull$$$0(0);
        }
        if (file.getParent() == null) {
            return null;
        }
        if (module == null || !RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        if (!RailsPartialView.validatePartialName(file)) {
            return null;
        }
        if (!VfsUtilCore.isUnderFiles((VirtualFile)file, RailsPaths.getInstance(module).findFiles("app/views"))) {
            return null;
        }
        RClass rClass = ControllersConventions.getControllerByViewFile(module, file);
        RailsController controller = rClass != null ? RailsController.fromClass(rClass) : RailsPartialView.createControllerByPartialView(file, module);
        return new RailsPartialView(file, module, controller);
    }

    private static boolean validatePartialName(VirtualFile file) {
        return ViewsConventions.isPartialViewName(file.getName());
    }

    public boolean isSharedPartialView() {
        return this.myController == null;
    }

    @Nullable
    public RailsController getController() {
        return this.myController;
    }

    public String toString() {
        return this.myFile.getName();
    }

    @Override
    public RailsViewOwner getViewOwner() {
        return this.myController;
    }

    @Override
    public RMethod getMethod() {
        return null;
    }

    @Nullable
    protected static RailsController createControllerByPartialView(@NotNull VirtualFile file, @NotNull Module module) {
        VirtualFile parentDir;
        if (file == null) {
            RailsPartialView.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RailsPartialView.$$$reportNull$$$0(2);
        }
        if (ViewsConventions.isPartialViewName(file.getName()) && (parentDir = file.getParent()) != null) {
            return RailsController.createControllerByViewsSubfolder(file, module);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsPartialView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fromFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createControllerByPartialView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

