/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsClassItem;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public class RailsMailerTemplate
extends RailsFileItem
implements RailsBaseView {
    RailsMailerTemplate(@NotNull VirtualFile viewFile, Module module) {
        if (viewFile == null) {
            RailsMailerTemplate.$$$reportNull$$$0(0);
        }
        super(viewFile, module);
    }

    @Nullable
    public static RailsMailerTemplate fromFile(PsiFile psiFile) {
        RailsApp app = RailsApp.fromPsiElement((PsiElement)psiFile);
        if (app == null) {
            return null;
        }
        VirtualFile vFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)psiFile);
        if (vFile == null) {
            return null;
        }
        if (RailsMailerTemplate.findMailerFile(app, vFile) == null) {
            return null;
        }
        return new RailsMailerTemplate(vFile, app.getModule());
    }

    @Nullable
    private static VirtualFile findMailerFile(@NotNull RailsApp app, @NotNull VirtualFile templateFile) {
        VirtualFile parent;
        if (app == null) {
            RailsMailerTemplate.$$$reportNull$$$0(1);
        }
        if (templateFile == null) {
            RailsMailerTemplate.$$$reportNull$$$0(2);
        }
        if ((parent = templateFile.getParent()) == null) {
            return null;
        }
        String relativePath = app.getPaths().getRelativePath("app/views", parent.getUrl());
        if (relativePath == null) {
            return null;
        }
        return (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsMailer.fromQualifiedName(app.getModule(), relativePath), RailsClassItem::getFile);
    }

    @Override
    public RailsMailer getViewOwner() {
        RailsApp app = this.getApp();
        return RailsMailer.fromFile(this.getModule(), RailsMailerTemplate.findMailerFile(app, this.getFile()));
    }

    @Override
    public RMethod getMethod() {
        RailsMailer mailer = this.getViewOwner();
        return mailer == null ? null : mailer.getRClass().findMethodByName(this.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsMailerTemplate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findMailerFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

