/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsLayoutOrView;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public class RailsLayout
extends RailsFileItem
implements RailsLayoutOrView {
    @Nullable
    private final RailsViewOwner myViewOwner;

    protected RailsLayout(@NotNull VirtualFile layoutFile, Module module, @Nullable RailsViewOwner viewOwner) {
        if (layoutFile == null) {
            RailsLayout.$$$reportNull$$$0(0);
        }
        super(layoutFile, module);
        this.myViewOwner = viewOwner;
    }

    @Nullable
    public static RailsLayout fromFile(PsiFile file) {
        VirtualFile vFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)file);
        return vFile == null ? null : RailsLayout.fromFile(vFile, ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
    }

    @Nullable
    public static RailsLayout fromFile(VirtualFile layoutFile, Module module) {
        RailsApp app = RailsApp.fromModule(module);
        if (app == null || !ViewsConventions.isLayoutFile(layoutFile)) {
            return null;
        }
        if (!VfsUtilCore.isUnderFiles((VirtualFile)layoutFile, app.getPaths().findFiles("app/views", "layouts"))) {
            return null;
        }
        String relativePath = ViewsConventions.getRelativePathOfLayoutsFolder(layoutFile.getParent().getUrl(), module);
        String nameWithoutExt = FileUtilRt.getNameWithoutExtension((String)layoutFile.getName());
        String layoutName = ViewsConventions.getViewOrLayoutNameByFileName(nameWithoutExt);
        Object qualifiedName = StringUtil.isEmpty((String)relativePath) ? layoutName : relativePath + "/" + layoutName;
        RailsViewOwner viewOwner = RailsController.fromQualifiedName(module, (String)qualifiedName);
        if (viewOwner == null) {
            viewOwner = RailsMailer.fromQualifiedName(module, (String)qualifiedName);
        }
        return new RailsLayout(layoutFile, module, viewOwner);
    }

    @Override
    @Nullable
    public RailsController getController() {
        return (RailsController)ObjectUtils.tryCast((Object)this.myViewOwner, RailsController.class);
    }

    @Override
    public boolean isPartial() {
        return false;
    }

    @Override
    @Nullable
    public RailsViewOwner getViewOwner() {
        return this.myViewOwner;
    }

    @Override
    @Nullable
    public RMethod getMethod() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutFile", "org/jetbrains/plugins/ruby/rails/model/RailsLayout", "<init>"));
    }
}

