/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.langs.RJSFileType;
import org.jetbrains.plugins.ruby.rails.langs.RXMLFileType;
import org.jetbrains.plugins.ruby.rails.model.RailsFileBasedItem;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;

public abstract class RailsFileItem
extends RailsFileBasedItem
implements Navigatable {
    @NotNull
    protected final VirtualFile myFile;

    protected RailsFileItem(@NotNull VirtualFile viewFile, Module module) {
        if (viewFile == null) {
            RailsFileItem.$$$reportNull$$$0(0);
        }
        super(module);
        this.myFile = viewFile;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            RailsFileItem.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public PsiFile getPsiFile() {
        return PsiManager.getInstance((Project)this.myModule.getProject()).findFile(this.myFile);
    }

    public String getName() {
        return ViewsConventions.getViewOrLayoutNameByFileName(this.getFile().getName());
    }

    public boolean isRJS() {
        return this.myFile.getFileType() instanceof RJSFileType;
    }

    public boolean isBuilder() {
        return this.myFile.getFileType() instanceof RXMLFileType;
    }

    public boolean isJBuilder() {
        return "jbuilder".equals(this.myFile.getExtension());
    }

    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().createNavigatable(this.myModule.getProject(), this.myFile, -1).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return new OpenFileDescriptor(this.myModule.getProject(), this.myFile).canNavigate();
    }

    public boolean canNavigateToSource() {
        return new OpenFileDescriptor(this.myModule.getProject(), this.myFile).canNavigateToSource();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsFileItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsFileItem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

