/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsSymbolProvider;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsExternalController;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.rails.rspec.RailsRSpecUtil;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecControllerTest;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RailsController
extends RailsViewOwner {
    private String myQualifiedName;

    protected RailsController(@NotNull Module module, @NotNull RClass aClass) {
        if (module == null) {
            RailsController.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            RailsController.$$$reportNull$$$0(1);
        }
        super(module, aClass);
    }

    public List<? extends RailsBaseView> getAllViewsAndPartials() {
        ArrayList<? extends RailsView> result = new ArrayList<RailsView>();
        result.addAll(this.getAllViews());
        result.addAll(this.getPartialViews());
        return result;
    }

    @Override
    public boolean isAbstract() {
        return this.getRClass().getFQNWithNesting().equals(RailsSymbolProvider.ACTION_CONTROLLER_BASE_FQN);
    }

    @Contract(value="null -> null")
    @Nullable
    public static RailsController fromClass(@Nullable RClass rClass) {
        if (rClass == null) {
            return null;
        }
        return RailsController.fromClass(rClass, RailsApp.fromPsiElement((PsiElement)rClass));
    }

    @Contract(value="null, _ -> null; _, null -> null")
    @Nullable
    public static RailsController fromClass(@Nullable RClass rClass, @Nullable RailsApp railsApp) {
        if (rClass == null) {
            return null;
        }
        if (railsApp == null) {
            return null;
        }
        if (RailsApp.fromPsiElement((PsiElement)rClass) != null) {
            if (!RailsController.isControllerClass(rClass, railsApp.getModule())) {
                return null;
            }
            return new RailsController(railsApp.getModule(), rClass);
        }
        return RailsExternalController.fromExternalClass(rClass, railsApp);
    }

    @Nullable
    public static RailsController fromFile(@NotNull PsiFile psiFile) {
        VirtualFile file;
        if (psiFile == null) {
            RailsController.$$$reportNull$$$0(2);
        }
        return (file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)psiFile)) == null ? null : RailsController.fromFile(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile), file);
    }

    @Deprecated
    @Nullable
    public static RailsController fromFile(@Nullable Module module, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            RailsController.$$$reportNull$$$0(3);
        }
        return (RailsController)ReadAction.compute(() -> {
            if (module == null || module.isDisposed() || !virtualFile.isValid()) {
                return null;
            }
            PsiFile patt5250$temp = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
            if (!(patt5250$temp instanceof RFile)) {
                return null;
            }
            RFile file = (RFile)patt5250$temp;
            RClass clazz = (RClass)ContainerUtil.find(RContainerUtil.getAllClasses((RContainer)file), clazz1 -> RailsController.isControllerClass(clazz1, module));
            return clazz != null ? new RailsController(module, clazz) : null;
        });
    }

    @Nullable
    public static RailsController fromViewsFolder(Module module, String viewsFolderUrl) {
        RailsApp app = RailsApp.fromModule(module);
        if (app == null || viewsFolderUrl == null) {
            return null;
        }
        for (String url : RailsController.getControllerUrlsByViewsFolderUrl(viewsFolderUrl, app)) {
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file == null) continue;
            return RailsController.fromFile(module, file);
        }
        VirtualFile viewsFolder = VirtualFileManager.getInstance().findFileByUrl(viewsFolderUrl);
        return viewsFolder == null ? null : RailsController.createControllerByViewsSubfolder(viewsFolder, module);
    }

    @NotNull
    private static List<String> getControllerUrlsByViewsFolderUrl(@NotNull String folderUrl, @NotNull RailsApp app) {
        String controllerQualifiedName;
        if (folderUrl == null) {
            RailsController.$$$reportNull$$$0(4);
        }
        if (app == null) {
            RailsController.$$$reportNull$$$0(5);
        }
        if ((controllerQualifiedName = app.getPaths().getRelativePath("app/views", folderUrl)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RailsController.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<String> list = app.getPaths().getUrls("app/controllers", controllerQualifiedName + "_controller." + RubyFileType.RUBY.getDefaultExtension());
        if (list == null) {
            RailsController.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public static RailsController fromLayout(Module module, String layoutParentFolderUrl, String layoutFileName) {
        String nameWithoutExt = FileUtilRt.getNameWithoutExtension((String)layoutFileName);
        String layout_name = ViewsConventions.getViewOrLayoutNameByFileName(nameWithoutExt);
        String relativePath = ViewsConventions.getRelativePathOfLayoutsFolder(layoutParentFolderUrl, module);
        String controllerQualifiedName = StringUtil.isEmpty((String)relativePath) ? layout_name : relativePath + "/" + layout_name;
        return RailsController.fromQualifiedName(module, controllerQualifiedName);
    }

    @Nullable
    public static RailsController fromClassFullyQualifiedName(Module module, @NotNull FQN fullQualifiedName) {
        if (fullQualifiedName == null) {
            RailsController.$$$reportNull$$$0(8);
        }
        String controllerFullName = NamingConventions.toUnderscoreCase((String)ControllersConventions.getControllerNameByClassName(fullQualifiedName.getFullPath(), module), (Module)module);
        return RailsController.fromQualifiedName(module, controllerFullName);
    }

    @Nullable
    public static RailsController fromQualifiedName(Module module, @NotNull String fullQualifiedName) {
        RailsApp app;
        if (fullQualifiedName == null) {
            RailsController.$$$reportNull$$$0(9);
        }
        if ((app = RailsApp.fromModule(module)) == null || !RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        FQN fqn = FQN.of((String)NamingConventions.toCamelCase((String)(app.appendProjectPrefix(fullQualifiedName) + "_controller"), (Module)module));
        RContainer container = RubyFQNUtil.findContainerByFQN(module.getProject(), SymbolUtil.getClassTypes(), fqn, null);
        return RailsController.fromClass((RClass)ObjectUtils.tryCast((Object)container, RClass.class), app);
    }

    @Nullable
    public static RailsController fromName(Module module, @NotNull String name) {
        if (name == null) {
            RailsController.$$$reportNull$$$0(10);
        }
        if (module == null || !RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        return RailsController.fromQualifiedName(module, name);
    }

    @Override
    @NotNull
    public String getName() {
        String name = ControllersConventions.getControllerNameByClassName(this.myClass.getName(), this.myModule);
        assert (name != null);
        String string = name;
        if (string == null) {
            RailsController.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public FQN getFqnWithNesting() {
        FQN fQN = FQN.of((String)ControllersConventions.getControllerClassName(this.getQualifiedName(), this.myModule));
        if (fQN == null) {
            RailsController.$$$reportNull$$$0(12);
        }
        return fQN;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        if (this.myQualifiedName == null) {
            this.myQualifiedName = ControllersConventions.getControllerNameByClassName(this.myClass.getFQNWithNesting().getFullPath(), this.myModule);
        }
        String string = this.myQualifiedName;
        if (string == null) {
            RailsController.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public RMethod getAction(String view_name) {
        return RubyPsiUtil.getMethodWithPossibleZeroArgsByName((RContainer)this.myClass, view_name);
    }

    @Nullable
    public RMethod getActionByFileName(String fileName) {
        String nameWithoutExt = FileUtilRt.getNameWithoutExtension((String)fileName);
        String view_name = ViewsConventions.getViewOrLayoutNameByFileName(nameWithoutExt);
        return RubyPsiUtil.getMethodWithPossibleZeroArgsByName((RContainer)this.myClass, view_name);
    }

    @NotNull
    public List<PsiElement> getRoutes() {
        List<PsiElement> list = RoutesParser.getInstance(this.getModule()).getElementsForControllerFqn(this.getFqnWithNesting());
        if (list == null) {
            RailsController.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getViewsFolderUrls() {
        String path = NamingConventions.toUnderscoreCase((String)this.myClass.getFQNWithNesting().getCallerFQN().getFullPath(), (Module)this.myModule);
        ArrayList<String> urls = new ArrayList<String>();
        for (String viewsRootUrl : RailsPaths.getInstance(this.myModule).getUrls("app/views")) {
            String name;
            StringBuilder buff = new StringBuilder();
            buff.append(viewsRootUrl);
            if (!StringUtil.isEmpty((String)path)) {
                buff.append('/');
                buff.append(path);
            }
            if (!StringUtil.isEmpty((String)(name = this.getName()))) {
                buff.append('/');
                buff.append(name);
            }
            urls.add(buff.toString());
        }
        ArrayList<String> arrayList = urls;
        if (arrayList == null) {
            RailsController.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public List<RailsView> getViews(String actionName) {
        List list = ContainerUtil.flatMap(this.getViewsFolders(), it -> this.findViewsInFolder(actionName, (VirtualFile)it));
        if (list == null) {
            RailsController.$$$reportNull$$$0(16);
        }
        return list;
    }

    private List<RailsView> findViewsInFolder(@NotNull String actionName, @Nullable VirtualFile viewsDir) {
        if (actionName == null) {
            RailsController.$$$reportNull$$$0(17);
        }
        ArrayList<RailsView> viewFiles = new ArrayList<RailsView>();
        if (viewsDir != null) {
            VirtualFile[] files;
            for (VirtualFile file : files = viewsDir.getChildren()) {
                if (file.isDirectory() || !actionName.equals(ViewsConventions.getActionMethodNameByView(file))) continue;
                viewFiles.add(new RailsView(file, this.myModule, this));
            }
        }
        return viewFiles;
    }

    @NotNull
    public List<RailsView> getPartialViews() {
        ArrayList<RailsView> result = new ArrayList<RailsView>();
        List files = ContainerUtil.flatMap(this.getViewsFolders(), it -> ViewsConventions.findPartialViews(it));
        for (VirtualFile file : files) {
            result.add(new RailsView(file, this.myModule, this));
        }
        ArrayList<RailsView> arrayList = result;
        if (arrayList == null) {
            RailsController.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Nullable
    public RailsHelper getOwnHelper() {
        String relativePathToHelperDirectory = NamingConventions.toUnderscoreCase((String)this.myClass.getFQNWithNesting().getCallerFQN().getFullPath(), (Module)this.myModule);
        if (StringUtil.isEmpty((String)relativePathToHelperDirectory)) {
            return this.getApp().findHelper(this.getName());
        }
        return this.getApp().findHelper(relativePathToHelperDirectory + "/" + this.getName());
    }

    @Override
    @NotNull
    public List<String> getLayoutsFolderUrls() {
        String path = NamingConventions.toUnderscoreCase((String)this.myClass.getFQNWithNesting().getCallerFQN().getFullPath(), (Module)this.myModule);
        if (StringUtil.isEmpty((String)path)) {
            List<String> list = RailsPaths.getInstance(this.myModule).getUrls("app/views", "layouts");
            if (list == null) {
                RailsController.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<String> list = RailsPaths.getInstance(this.myModule).getUrls("app/views", "layouts", path);
        if (list == null) {
            RailsController.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Nullable
    public RClass getFunctionalTestClass() {
        RailsApp app = this.getApp();
        return this.getTestClass(this.getApp().getFunctionalTestsRoot(), app.getPaths().findFiles("app/controllers"), this.getFile().getNameWithoutExtension(), this.myClass.getName());
    }

    @Nullable
    public RClass getUnitTestClass() {
        RailsApp app = this.getApp();
        return this.getTestClass(this.getApp().getUnitTestsRoot(), app.getPaths().findFiles("app/controllers"), this.getFile().getNameWithoutExtension(), this.myClass.getName());
    }

    @Nullable
    public RailsRSpecControllerTest getSpecTest() {
        return RailsRSpecControllerTest.fromController(this);
    }

    @Nullable
    public RailsModel getModel() {
        String qualifiedName = this.getQualifiedName();
        RailsModel model = this.getApp().findModelByName(qualifiedName);
        InflectorService service = InflectorService.getInstance(this.myModule);
        if (model != null || !service.isInflectorAvailable()) {
            return model;
        }
        String shortName = this.getName();
        String singular = service.singularize(shortName);
        String relativePath = qualifiedName.substring(0, qualifiedName.length() - shortName.length());
        return this.getApp().findModelByName(relativePath + singular);
    }

    public boolean isApplicationController() {
        String qName = this.getQualifiedName();
        return qName.equals("application");
    }

    @Nullable
    public VirtualFile getViewsSpecsFolder() {
        RailsApp app = this.getApp();
        for (VirtualFile viewsFolder : this.getViewsFolders()) {
            VirtualFile file = RailsRSpecUtil.getSpecTest(app.getSpecTestsViewsRoot(), app.getPaths().findFiles("app/views"), viewsFolder, null);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public VirtualFile getRequestSpec() {
        RailsApp app = this.getApp();
        VirtualFile specTestsRoot = app.getSpecTestsRoot();
        String requestSpecName = NamingConventions.toUnderscoreCase((String)this.getQualifiedName(), (Module)this.myModule) + "_spec.rb";
        VirtualFile path = null;
        if (specTestsRoot != null) {
            path = specTestsRoot.findFileByRelativePath("/requests/" + requestSpecName);
        }
        return path;
    }

    @Nullable
    public VirtualFile getRoutingSpec() {
        RailsApp app = this.getApp();
        VirtualFile specTestsRoot = app.getSpecTestsRoot();
        String routingSpecName = NamingConventions.toUnderscoreCase((String)this.getQualifiedName(), (Module)this.myModule) + "_routing_spec.rb";
        VirtualFile path = null;
        if (specTestsRoot != null) {
            path = specTestsRoot.findFileByRelativePath("/routing/" + routingSpecName);
        }
        return path;
    }

    private static boolean isControllerClass(@NotNull RClass clazz, @Nullable Module module) {
        if (clazz == null) {
            RailsController.$$$reportNull$$$0(21);
        }
        if (ControllersConventions.getControllerNameByClassName(clazz.getName(), module) == null) {
            return false;
        }
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)clazz, null);
        return symbol != null && SymbolHierarchy.isInheritor(symbol, FQN.of((String)"ActionController::Metal"), null);
    }

    @Nullable
    protected static RailsController createControllerByViewsSubfolder(@NotNull VirtualFile file, @NotNull Module module) {
        if (file == null) {
            RailsController.$$$reportNull$$$0(22);
        }
        if (module == null) {
            RailsController.$$$reportNull$$$0(23);
        }
        if (!file.isDirectory()) {
            return null;
        }
        String relativePath = RailsPaths.getInstance(module).getRelativePath("app/views", file.getUrl());
        if (relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        return RailsController.fromName(module, relativePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 11, 12, 13, 14, 15, 16, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsController";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullQualifiedName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsController";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerUrlsByViewsFolderUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqnWithNesting";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewsFolderUrls";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getViews";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartialViews";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutsFolderUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getControllerUrlsByViewsFolderUrl";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromClassFullyQualifiedName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifiedName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findViewsInFolder";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isControllerClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createControllerByViewsSubfolder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 11, 12, 13, 14, 15, 16, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

