/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.model.RailsFileBasedItem;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public abstract class RailsClassItem
extends RailsFileBasedItem {
    @NotNull
    protected final RClass myClass;

    protected RailsClassItem(@NotNull Module module, @NotNull RClass aClass) {
        if (module == null) {
            RailsClassItem.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            RailsClassItem.$$$reportNull$$$0(1);
        }
        super(module);
        this.myClass = aClass;
    }

    @Override
    public VirtualFile getFile() {
        return RubyPsiUtil.getVirtualFileFromElement((PsiElement)this.myClass);
    }

    @Override
    public PsiFile getPsiFile() {
        return this.myClass.getContainingFile();
    }

    @NotNull
    public RClass getRClass() {
        RClass rClass = this.myClass;
        if (rClass == null) {
            RailsClassItem.$$$reportNull$$$0(2);
        }
        return rClass;
    }

    protected static boolean checkPathEndsWithQualifiedName(@NotNull RClass rClass, @NotNull List<? extends VirtualFile> roots) {
        VirtualFile file;
        if (rClass == null) {
            RailsClassItem.$$$reportNull$$$0(3);
        }
        if (roots == null) {
            RailsClassItem.$$$reportNull$$$0(4);
        }
        if ((file = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rClass)) == null) {
            return false;
        }
        if (roots.isEmpty() || !VfsUtilCore.isUnderFiles((VirtualFile)file, roots)) {
            return false;
        }
        String filePath = file.getPath();
        LinkedList path = new LinkedList();
        RModule containingModule = RubyPsiUtil.getContainingRModule((PsiElement)rClass);
        while (containingModule != null) {
            path.addAll(0, containingModule.getFQN().asList());
            containingModule = RubyPsiUtil.getContainingRModule((PsiElement)containingModule);
        }
        path.addAll(rClass.getFQN().asList());
        StringBuilder buff = new StringBuilder();
        for (String name : path) {
            buff.append('/');
            buff.append(NamingConventions.toUnderscoreCase((String)name, (Module)((Module)ObjectUtils.doIfNotNull((Object)containingModule, ModuleUtilCore::findModuleForPsiElement))));
        }
        buff.append('.').append(RubyFileType.RUBY.getDefaultExtension());
        return filePath.endsWith(buff.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsClassItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsClassItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkPathEndsWithQualifiedName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

