/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsChannel;
import org.jetbrains.plugins.ruby.rails.model.RailsItem;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RailsChannelAction
extends RailsItem {
    private final RMethod myMethod;
    private final RailsChannel myChannel;
    public static final List<String> SUBSCRIPTION_METHODS = List.of("subscribed", "unsubscribed");

    protected RailsChannelAction(@NotNull RailsChannel channel, @NotNull RMethod method) {
        if (channel == null) {
            RailsChannelAction.$$$reportNull$$$0(0);
        }
        if (method == null) {
            RailsChannelAction.$$$reportNull$$$0(1);
        }
        super(channel.getModule());
        this.myMethod = method;
        this.myChannel = channel;
    }

    @NotNull
    public String getName() {
        String result = this.myMethod.getName();
        assert (result != null);
        String string = result;
        if (string == null) {
            RailsChannelAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static RailsChannelAction fromMethod(@NotNull RMethod method) {
        if (method == null) {
            RailsChannelAction.$$$reportNull$$$0(3);
        }
        if (!RailsChannelAction.validateMethod(method)) {
            return null;
        }
        RContainer container = method.getParentContainer();
        if (!(container instanceof RClass)) {
            return null;
        }
        RailsChannel channel = RailsChannel.fromClass((RClass)container);
        return channel != null ? new RailsChannelAction(channel, method) : null;
    }

    private static boolean validateMethod(RMethod method) {
        return !(method instanceof RSingletonMethod) && method.getVisibility() == Visibility.PUBLIC && !SUBSCRIPTION_METHODS.contains(method.getName());
    }

    public RMethod getMethod() {
        return this.myMethod;
    }

    public RailsChannel getChannel() {
        return this.myChannel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsChannelAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsChannelAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

