/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwnerAction;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public class RailsAction
extends RailsViewOwnerAction {
    private final RMethod myMethod;
    private final RailsController myController;

    RailsAction(@NotNull RailsController controller, @NotNull RMethod method) {
        if (controller == null) {
            RailsAction.$$$reportNull$$$0(0);
        }
        if (method == null) {
            RailsAction.$$$reportNull$$$0(1);
        }
        super(controller.getModule());
        this.myMethod = method;
        this.myController = controller;
    }

    @NotNull
    public RMethod getMethod() {
        RMethod rMethod = this.myMethod;
        if (rMethod == null) {
            RailsAction.$$$reportNull$$$0(2);
        }
        return rMethod;
    }

    @Override
    @NotNull
    public RailsController getViewOwner() {
        RailsController railsController = this.myController;
        if (railsController == null) {
            RailsAction.$$$reportNull$$$0(3);
        }
        return railsController;
    }

    @Nullable
    public static RailsAction fromMethod(@NotNull RMethod method) {
        if (method == null) {
            RailsAction.$$$reportNull$$$0(4);
        }
        if (!RailsAction.isActionMethod(method)) {
            return null;
        }
        RContainer container = method.getParentContainer();
        if (!(container instanceof RClass)) {
            return null;
        }
        RailsController controller = RailsController.fromClass((RClass)container);
        return controller != null ? new RailsAction(controller, method) : null;
    }

    @Nullable
    public static RailsAction fromControllerMethod(@NotNull RailsController controller, @NotNull RMethod method) {
        if (controller == null) {
            RailsAction.$$$reportNull$$$0(5);
        }
        if (method == null) {
            RailsAction.$$$reportNull$$$0(6);
        }
        if (!RailsAction.isActionMethod(method)) {
            return null;
        }
        return new RailsAction(controller, method);
    }

    private static boolean isActionMethod(@NotNull RMethod method) {
        if (method == null) {
            RailsAction.$$$reportNull$$$0(7);
        }
        if (method instanceof RSingletonMethod || method.getVisibility() != Visibility.PUBLIC) {
            return false;
        }
        return ContainerUtil.and((Iterable)method.getArgumentInfos(), it -> it.getType().isOptional());
    }

    @NotNull
    public List<PsiElement> getRoutes() {
        List<PsiElement> list = RoutesParser.getInstance(this.getModule()).getElementsForActionFqn(this.myMethod.getFQNWithNesting());
        if (list == null) {
            RailsAction.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<RailsView> getViews() {
        List<RailsView> list = this.myController.getViews(this.getName());
        if (list == null) {
            RailsAction.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myMethod.getName();
        if (string == null) {
            RailsAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isHiddenAction() {
        RClass rClass = this.myController.getRClass();
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        Ref refValue = Ref.create((Object)false);
        if (symbol instanceof ClassModuleSymbol) {
            Processor processor = superclass -> {
                if (superclass.getFQNWithNesting().equals(FQN.Builder.fromString((String)"ActionController::Base"))) {
                    return false;
                }
                PsiElement declaration = symbol.getPsiElement();
                if (declaration instanceof RClass) {
                    RClass clazz = (RClass)declaration;
                    List structureElements = clazz.getStructureElements();
                    for (RPsiStructureElement structureElement : structureElements) {
                        if (!RailsAction.isHiddenAction(this.myMethod, structureElement)) continue;
                        refValue.set((Object)true);
                        return false;
                    }
                }
                return true;
            };
            ((ClassModuleSymbol)symbol).processSuperClassSymbols((Processor<? super Symbol>)processor, (PsiElement)rClass, false);
        }
        return (Boolean)refValue.get();
    }

    @Nullable
    public static RailsAction fromMethodFqn(@NotNull Module module, @NotNull FQN fqn) {
        RailsController controller;
        if (module == null) {
            RailsAction.$$$reportNull$$$0(11);
        }
        if (fqn == null) {
            RailsAction.$$$reportNull$$$0(12);
        }
        if ((controller = RailsController.fromClassFullyQualifiedName(module, fqn.getCallerFQN())) == null) {
            return null;
        }
        RMethod method = controller.getAction(fqn.getShortName());
        return method != null ? RailsAction.fromControllerMethod(controller, method) : null;
    }

    private static boolean isHiddenAction(RMethod method, RPsiStructureElement structureElement) {
        if (!(structureElement instanceof RCall)) {
            return false;
        }
        RCall call = (RCall)structureElement;
        RubyCallType callType = call.getCallType();
        if (callType == RailsCallTypeProvider.HIDE_ACTION_CALL) {
            for (String arg : (List)call.getData(new RubyCallType[]{RailsCallTypeProvider.HIDE_ACTION_CALL})) {
                if (!Comparing.strEqual((String)method.getName(), (String)arg)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewOwner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getViews";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromControllerMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isActionMethod";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromMethodFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

