/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.database.MigrationParser;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.ModelsTableMappingUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class ActiveRecordModel
extends RailsModel {
    public static final String ACTIVE_RECORD_BASE = "ActiveRecord::Base";
    public static final String APPLICATION_RECORD = "ApplicationRecord";
    private String myTableName;

    protected ActiveRecordModel(@NotNull Module module, RClass rClass) {
        if (module == null) {
            ActiveRecordModel.$$$reportNull$$$0(0);
        }
        super(module, rClass);
    }

    @Nullable
    public static ActiveRecordModel fromFile(Module module, VirtualFile vFile) {
        return ActiveRecordModel.fromFile(PsiManager.getInstance((Project)module.getProject()).findFile(vFile));
    }

    @Nullable
    public static ActiveRecordModel fromClass(RClass rClass) {
        if (rClass == null || !rClass.isValid()) {
            return null;
        }
        PsiFile psiFile = rClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile vFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)psiFile);
        if (vFile == null) {
            return null;
        }
        String nameWithoutExt = vFile.getNameWithoutExtension();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rClass);
        if (module != null && !Objects.equals(rClass.getName(), NamingConventions.toCamelCase((String)nameWithoutExt, (Module)module))) {
            return null;
        }
        ActiveRecordModel railsModel = ActiveRecordModel.fromFile(psiFile);
        if (railsModel != null && rClass == railsModel.getRClass()) {
            return railsModel;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static ActiveRecordModel fromFile(@Nullable PsiFile psiFile) {
        if (!(psiFile instanceof RFile)) {
            return null;
        }
        RFile rFile = (RFile)psiFile;
        return ActiveRecordModel.fromFile(rFile);
    }

    @Nullable
    public static ActiveRecordModel fromFile(RFile rFile) {
        RailsModel railsModel = RailsModel.fromFile((PsiFile)rFile);
        return railsModel != null ? ActiveRecordModel.fromModel(railsModel) : null;
    }

    @Nullable
    public static ActiveRecordModel fromModel(@NotNull RailsModel model) {
        RClass modelClass;
        if (model == null) {
            ActiveRecordModel.$$$reportNull$$$0(1);
        }
        return ActiveRecordModel.isActiveRecordClass(modelClass = model.getRClass()) ? new ActiveRecordModel(model.getModule(), modelClass) : null;
    }

    @Nullable
    public static ActiveRecordModel fromModelName(@Nullable Module module, @Nullable String modelName) {
        return (ActiveRecordModel)ObjectUtils.doIfNotNull((Object)RailsModel.fromModelName(module, modelName), ActiveRecordModel::fromModel);
    }

    @Nullable
    public static Collection<MigrationField> getFields(Module module, String modelName) {
        ActiveRecordModel railsModel = ActiveRecordModel.fromModelName(module, modelName);
        return railsModel != null ? railsModel.getDBFields() : Collections.emptyList();
    }

    @Nullable
    public static Collection<MigrationField> getFields(Module module, RClass clazz) {
        ActiveRecordModel railsModel = ActiveRecordModel.fromClass(clazz);
        return railsModel != null ? railsModel.getDBFields() : Collections.emptyList();
    }

    @NotNull
    public static Collection<? extends MigrationField> determineFieldsInternal(@NotNull Module module, @NotNull RClass rClass) {
        String tableName;
        if (module == null) {
            ActiveRecordModel.$$$reportNull$$$0(2);
        }
        if (rClass == null) {
            ActiveRecordModel.$$$reportNull$$$0(3);
        }
        if ((tableName = ActiveRecordModel.determineRealTableName(rClass)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ActiveRecordModel.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection<MigrationField> fields = MigrationParser.getInstance(module).getFieldsByTableName(tableName);
        Collection<MigrationField> collection = fields != null ? fields : Collections.emptyList();
        if (collection == null) {
            ActiveRecordModel.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public static boolean isActiveRecordClass(@Nullable Symbol symbol) {
        if (symbol == null) {
            return false;
        }
        return SymbolHierarchy.isInheritor(symbol, RailsModelSymbol.ACTIVE_RECORD_BASE_FQN, null) || SymbolHierarchy.isInheritor(symbol, FQN.of((String)APPLICATION_RECORD), null);
    }

    public static boolean isActiveRecordClass(@Nullable RClass rClass) {
        return ActiveRecordModel.isActiveRecordClass(SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass, null));
    }

    @Nullable
    public String getTableName() {
        if (this.myTableName == null) {
            RClass rClass = this.getRClass();
            this.myTableName = ActiveRecordModel.determineRealTableName(rClass);
        }
        return this.myTableName;
    }

    @Nullable
    public Collection<MigrationField> getDBFields() {
        String tableName = this.getTableName();
        return tableName == null ? null : MigrationParser.getInstance(this.myModule).getFieldsByTableName(tableName);
    }

    @Nullable
    public PsiFile getSchemaFile() {
        return (PsiFile)ContainerUtil.getFirstItem((List)ContainerUtil.mapNotNull(RailsPaths.getInstance(this.myModule).findFiles("db", "schema.rb"), arg_0 -> ((PsiManager)this.myClass.getManager()).findFile(arg_0)));
    }

    @Nullable
    public PsiElement getSchemaCreateTableElement() {
        return (PsiElement)ObjectUtils.doIfNotNull((Object)this.getTableName(), MigrationParser.getInstance(this.myModule)::getTableDef);
    }

    @Nullable
    private static String determineRealTableName(@NotNull RClass clazz) {
        if (clazz == null) {
            ActiveRecordModel.$$$reportNull$$$0(6);
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)clazz, () -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
            String tableName = module != null ? ActiveRecordModel.determineRealTableName(module, clazz, new HashSet<FQN>()) : null;
            return CachedValueProvider.Result.create((Object)tableName, RubyModificationTrackers.getModelModificationTrackers(clazz.getProject()));
        });
    }

    @Nullable
    private static String determineRealTableName(@NotNull Module module, @NotNull RClass clazz, @NotNull Set<FQN> visited) {
        RClass superclass2;
        FQN fqn;
        if (module == null) {
            ActiveRecordModel.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            ActiveRecordModel.$$$reportNull$$$0(8);
        }
        if (visited == null) {
            ActiveRecordModel.$$$reportNull$$$0(9);
        }
        if (!visited.add(fqn = clazz.getFQNWithNesting())) {
            return null;
        }
        String explicitTableName = ModelsTableMappingUtil.getExplicitTableName(clazz);
        if (explicitTableName != null) {
            return explicitTableName;
        }
        if (FQN.same((FQN)fqn, (String)ACTIVE_RECORD_BASE)) {
            return null;
        }
        if (ModelsTableMappingUtil.isAbstract(clazz)) {
            return (String)ObjectUtils.doIfNotNull((Object)ActiveRecordModel.getParentModel(clazz), superclass -> ActiveRecordModel.determineRealTableName(module, superclass, visited));
        }
        RClass baseClass = clazz;
        do {
            String superclassTableName;
            if ((superclass2 = ActiveRecordModel.getParentModel(baseClass)) == null) {
                return null;
            }
            if (!ModelsTableMappingUtil.isAbstract(superclass2)) continue;
            String string = superclassTableName = baseClass.equals(clazz) ? ActiveRecordModel.determineRealTableName(module, superclass2, visited) : null;
            if (!StringUtil.isNotEmpty((String)superclassTableName)) break;
            return superclassTableName;
        } while (!(baseClass = superclass2).equals(clazz));
        if (!baseClass.equals(clazz)) {
            return ActiveRecordModel.determineRealTableName(module, baseClass, visited);
        }
        String prefix = ModelsTableMappingUtil.getExplicitTableNamePrefix(clazz);
        String contained = ModelsTableMappingUtil.getImplicitTableNameContained(clazz);
        String name = ModelsTableMappingUtil.getImplicitTableName(FQN.of((String)clazz.getFQN().getShortName()), module);
        String suffix = ModelsTableMappingUtil.getExplicitTableNameSuffix(clazz);
        return prefix != null && contained != null && name != null && suffix != null ? prefix + contained + name + suffix : null;
    }

    @Nullable
    public static RClass getParentModel(RClass model) {
        List<RClass> classes = RubyClassResolveUtil.resolveSuperClass(model, (PsiElement)model);
        return classes.isEmpty() ? null : classes.get(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/ActiveRecordModel";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/ActiveRecordModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "determineFieldsInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "determineFieldsInternal";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "determineRealTableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

