/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbElementTypes;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormatterUtil;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;

public class ErbWrapProcessor
extends RubyFormattingProcessor {
    public ErbWrapProcessor(CommonCodeStyleSettings settings) {
        super(settings);
    }

    public Wrap getWrapForNode(ASTNode node, @Nullable FileViewProvider fileViewProvider) {
        if (node == null) {
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
        }
        IElementType nodeType = node.getElementType();
        if ((nodeType == ErbElementTypes.ERB_XML_TAG || nodeType == ErbTokenTypes.ERB_INJECTION_IN_HTML) && fileViewProvider != null && ErbFormatterUtil.isScripletErbXmlTagNode(node)) {
            PsiElement psiElement = fileViewProvider.findElementAt(node.getStartOffset() - 1, (Language)HTMLLanguage.INSTANCE);
            String text = ErbWrapProcessor.trimEndSpaces(psiElement != null ? psiElement.getText() : null);
            boolean shouldIgnoreIndent = text != null && text.endsWith("\n");
            return Wrap.createWrap((WrapType)(shouldIgnoreIndent ? WrapType.NONE : WrapType.ALWAYS), (boolean)true);
        }
        if (nodeType instanceof RubyElementType) {
            Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
        }
        return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
    }

    @Nullable
    private static String trimEndSpaces(@Nullable String text) {
        int i;
        if (text == null) {
            return null;
        }
        for (i = text.length() - 1; i >= 0 && text.charAt(i) == ' '; --i) {
        }
        if (i >= 0) {
            text = text.substring(0, i + 1);
        }
        return text;
    }

    public static Wrap createTagAttributesWrap(WrapType wrapType) {
        return Wrap.createWrap((WrapType)wrapType, (boolean)false);
    }

    public static Wrap createTagTextWrap(WrapType wrapType) {
        return Wrap.createWrap((WrapType)wrapType, (boolean)true);
    }
}

