/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbElementTypes;
import org.jetbrains.plugins.ruby.erb.formatter.ErbGraphQLInjectedBlockBuilder;
import org.jetbrains.plugins.ruby.erb.psi.ErbCodeInjectionTag;
import org.jetbrains.plugins.ruby.erb.psi.ErbOuterLanguageElement;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.erb.psi.impl.ErbRubyInjectionTagNavigator;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.ForeignLanguageBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbCodeInjectionBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbCommentBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbHtmlBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbHtmlTagBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormatterUtil;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormattingHelper;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormattingProcessor;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.nodeInfo.ErbNodeInfo;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.nodeInfo.NodeInfo;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.nodeInfo.TemplateNodeInfo;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;

public class ErbBlockGenerator
extends ErbFormattingProcessor {
    protected static final List<Block> EMPTY = Collections.unmodifiableList(new ArrayList(0));
    private static final Logger LOG = Logger.getInstance(ErbBlockGenerator.class);
    private final ErbFormattingHelper myHelper;
    private final ErbGraphQLInjectedBlockBuilder myErbGraphQLInjectedBlockBuilder;

    public ErbBlockGenerator(ErbFormattingHelper helper) {
        super(helper.getXmlFormattingPolicy());
        this.myHelper = helper;
        this.myErbGraphQLInjectedBlockBuilder = new ErbGraphQLInjectedBlockBuilder(this.myHelper.getRootSettings());
    }

    @NotNull
    public ErbGraphQLInjectedBlockBuilder getErbGraphQLInjectedLanguageBlockBuilder() {
        ErbGraphQLInjectedBlockBuilder erbGraphQLInjectedBlockBuilder = this.myErbGraphQLInjectedBlockBuilder;
        if (erbGraphQLInjectedBlockBuilder == null) {
            ErbBlockGenerator.$$$reportNull$$$0(0);
        }
        return erbGraphQLInjectedBlockBuilder;
    }

    public List<Block> createErbSubBlocks(@NotNull ASTNode node, ErbBlock erbBlock, @NotNull FileViewProvider provider) {
        if (node == null) {
            ErbBlockGenerator.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            ErbBlockGenerator.$$$reportNull$$$0(2);
        }
        TextRange nodeBoundsTRange = erbBlock.getTextRange();
        if (node instanceof CompositeElement) {
            RCompoundStatement nodeRCmpSt = ErbFormatterUtil.getParentRCmpStByErbOrHTMLChildNode(provider, node);
            ArrayList<Block> subBlocks = new ArrayList<Block>(5);
            ASTNode childNode = node.getFirstChildNode();
            NodeInfo childNodeInfo = NodeInfo.createErbInfo(node, null, childNode);
            while (childNode != null) {
                childNodeInfo = ErbFormatterUtil.canBeCorrectBlock(childNode) ? this.processContentChildNode(childNode, childNodeInfo, node, subBlocks, nodeRCmpSt, provider, nodeBoundsTRange, null, null) : NodeInfo.createErbInfo(node, childNode, childNode.getTreeNext());
                childNode = NodeInfo.getNextErbNodeByInfo(childNodeInfo);
            }
            return subBlocks;
        }
        return EMPTY;
    }

    @NotNull
    public NodeInfo processContentChildNode(@NotNull ASTNode childNode, @NotNull NodeInfo info, ASTNode parentNode, List<Block> subBlocks, RCompoundStatement nodeRCmpSt, @NotNull FileViewProvider fileViewProvider, @NotNull TextRange parentNodeTextRange, @Nullable Alignment alignment, @Nullable Indent erbIndentIfWasCalculated) {
        Indent indent;
        TextRange childTextRange;
        if (childNode == null) {
            ErbBlockGenerator.$$$reportNull$$$0(3);
        }
        if (info == null) {
            ErbBlockGenerator.$$$reportNull$$$0(4);
        }
        if (fileViewProvider == null) {
            ErbBlockGenerator.$$$reportNull$$$0(5);
        }
        if (parentNodeTextRange == null) {
            ErbBlockGenerator.$$$reportNull$$$0(6);
        }
        LOG.assertTrue((childTextRange = info.getNextNodeTRange()) != null);
        if (!parentNodeTextRange.intersectsStrict(childTextRange)) {
            ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, childNode, null);
            if (erbNodeInfo == null) {
                ErbBlockGenerator.$$$reportNull$$$0(7);
            }
            return erbNodeInfo;
        }
        IElementType childNodeType = childNode.getElementType();
        if (ErbFormatterUtil.isHTMLDocumentRootOrProlog(childNode)) {
            Wrap wrap = this.myHelper.getWrapProcessor().getWrapForNode(childNode, fileViewProvider);
            subBlocks.add((Block)new ErbBlock(childNode, Indent.getNoneIndent(), wrap, this.myHelper));
            ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, childNode, childNode.getTreeNext());
            if (erbNodeInfo == null) {
                ErbBlockGenerator.$$$reportNull$$$0(8);
            }
            return erbNodeInfo;
        }
        RCompoundStatement childRCmpSt = ErbFormatterUtil.getParentRCmpStByErbOrHTMLChildNode(fileViewProvider, childNode);
        Indent indent2 = indent = erbIndentIfWasCalculated != null ? erbIndentIfWasCalculated : this.myHelper.getIndentProcessor().calcErbIndentForChild(childRCmpSt, nodeRCmpSt, parentNode, true);
        if (childNodeType == ErbTokenTypes.TEMPLATE_CHARACTERS_IN_ERB) {
            NodeInfo nodeInfo = this.processHTMLTemplateData(childNode, childTextRange, parentNode, subBlocks, indent, alignment, childRCmpSt, parentNodeTextRange, fileViewProvider);
            if (nodeInfo == null) {
                ErbBlockGenerator.$$$reportNull$$$0(9);
            }
            return nodeInfo;
        }
        if (childNodeType == ErbElementTypes.ERB_XML_TAG || childNodeType == ErbTokenTypes.ERB_INJECTION_IN_HTML) {
            return this.processErbInjectionTag(childNode, parentNode, subBlocks, indent, alignment, nodeRCmpSt, fileViewProvider);
        }
        if (childNodeType == ErbElementTypes.ERB_COMMENT_ELEMENT) {
            PsiElement psiElement = fileViewProvider.findElementAt(childNode.getStartOffset() - 1, (Language)HTMLLanguage.INSTANCE);
            String text = psiElement != null ? psiElement.getText() : null;
            boolean shouldIgnoreIndent = text != null && text.endsWith("\n");
            Indent commentIndent = shouldIgnoreIndent ? Indent.getAbsoluteNoneIndent() : indent;
            Alignment commentAlignment = shouldIgnoreIndent ? null : alignment;
            Wrap commentWrap = this.myHelper.getWrapProcessor().getWrapForNode(childNode, fileViewProvider);
            subBlocks.add((Block)new ErbCommentBlock(childNode, commentIndent, commentAlignment, commentWrap, this.myHelper));
            ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, childNode, childNode.getTreeNext());
            if (erbNodeInfo == null) {
                ErbBlockGenerator.$$$reportNull$$$0(10);
            }
            return erbNodeInfo;
        }
        ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, childNode, childNode.getTreeNext());
        if (erbNodeInfo == null) {
            ErbBlockGenerator.$$$reportNull$$$0(11);
        }
        return erbNodeInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public NodeInfo processHTMLTemplateData(ASTNode templateNode, @NotNull TextRange templateRange, @NotNull ASTNode parentNode, @NotNull List<Block> subBlocks, @NotNull Indent indent, @Nullable Alignment alignment, @Nullable RCompoundStatement childRCmpSt, @NotNull TextRange parentNodeTextRange, @NotNull FileViewProvider vProvider) {
        int htmlPsiEndOffset;
        TextRange htmlPsiTRange;
        int templateRangeEnd;
        block31: {
            boolean isJSEmbeddedContent;
            boolean isTag;
            PsiElement htmlPsi;
            TextRange boundsTRange;
            block32: {
                block33: {
                    if (templateRange == null) {
                        ErbBlockGenerator.$$$reportNull$$$0(12);
                    }
                    if (parentNode == null) {
                        ErbBlockGenerator.$$$reportNull$$$0(13);
                    }
                    if (subBlocks == null) {
                        ErbBlockGenerator.$$$reportNull$$$0(14);
                    }
                    if (indent == null) {
                        ErbBlockGenerator.$$$reportNull$$$0(15);
                    }
                    if (parentNodeTextRange == null) {
                        ErbBlockGenerator.$$$reportNull$$$0(16);
                    }
                    if (vProvider == null) {
                        ErbBlockGenerator.$$$reportNull$$$0(17);
                    }
                    int templateRangeStart = templateRange.getStartOffset();
                    templateRangeEnd = templateRange.getEndOffset();
                    if (childRCmpSt == null) {
                        boundsTRange = parentNodeTextRange;
                    } else {
                        LOG.assertTrue(childRCmpSt.getTextLength() != 0, childRCmpSt.getTextLength() != 0 ? "" : "Unexpected empty Ruby compound....:\nchildRCmpSt = " + String.valueOf(childRCmpSt) + "\n range = " + String.valueOf(childRCmpSt.getTextRange()) + "\n Dump: \n" + DebugUtil.psiToString((PsiElement)childRCmpSt.getContainingFile(), (boolean)true, (boolean)true));
                        boundsTRange = parentNodeTextRange.intersection(ErbBlockGenerator.getHTMLBoundsInRCmpSt(childRCmpSt, vProvider));
                    }
                    assert (boundsTRange != null);
                    htmlPsi = ErbFormatterUtil.findUpperHTMLElement(vProvider, templateRangeStart, templateRange);
                    if (htmlPsi == null) {
                        ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, templateNode, null);
                        if (erbNodeInfo == null) {
                            ErbBlockGenerator.$$$reportNull$$$0(18);
                        }
                        return erbNodeInfo;
                    }
                    htmlPsiTRange = htmlPsi.getTextRange();
                    if (!boundsTRange.intersectsStrict(htmlPsiTRange)) {
                        ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, templateNode, null);
                        if (erbNodeInfo == null) {
                            ErbBlockGenerator.$$$reportNull$$$0(19);
                        }
                        return erbNodeInfo;
                    }
                    ASTNode htmlPsiNode = htmlPsi.getNode();
                    if (!ErbFormatterUtil.canBeCorrectBlock(htmlPsiNode)) break block31;
                    isTag = htmlPsi instanceof XmlTag;
                    isJSEmbeddedContent = ErbFormatterUtil.isJSEmbeddedContent(htmlPsi);
                    if (!boundsTRange.contains(htmlPsiTRange)) break block32;
                    if (!isTag && !ErbFormatterUtil.isTagOrAttrElementOrAttrValue(htmlPsi) && !isJSEmbeddedContent) break block33;
                    if (templateRange.contains(htmlPsiTRange)) {
                        if (isJSEmbeddedContent) {
                            this.createAnotherLanguageBlockWrapper(htmlPsi.getLanguage(), htmlPsiNode, subBlocks, indent);
                            break block31;
                        } else {
                            this.createAndAddErbHtml(isTag, htmlPsi, subBlocks, htmlPsiTRange, indent, alignment, vProvider);
                        }
                        break block31;
                    } else {
                        PsiElement lastChild = htmlPsi.getLastChild();
                        LOG.assertTrue(lastChild != null, (Object)"LastChild here can't be null");
                        ASTNode htmlPsiEndNode = lastChild.getNode();
                        assert (htmlPsiEndNode != null);
                        RCompoundStatement htmlPsiEndRCmpSt = ErbFormatterUtil.getParentRCmpStByErbOrHTMLChildNode(vProvider, htmlPsiEndNode);
                        if (childRCmpSt != htmlPsiEndRCmpSt) {
                            this.createAndAddUnClosedErb(isTag || isJSEmbeddedContent, subBlocks, boundsTRange, htmlPsi, htmlPsiTRange, indent, alignment, vProvider);
                            TextRange childCoveringRCmpStRange = childRCmpSt == null ? ErbBlockGenerator.getCoveringRCompSRangeForCorruptedPsi(templateNode, vProvider) : childRCmpSt.getTextRange();
                            PsiElement erbForHtmlCmpStEnd = ErbFormatterUtil.findErbElementByStartOffset(vProvider, childCoveringRCmpStRange.getEndOffset(), true);
                            ErbCodeInjectionTag nextPsi = erbForHtmlCmpStEnd != null ? ErbRubyInjectionTagNavigator.getByPsiElement(erbForHtmlCmpStEnd) : null;
                            ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, templateNode, nextPsi != null ? nextPsi.getNode() : null);
                            if (erbNodeInfo == null) {
                                ErbBlockGenerator.$$$reportNull$$$0(20);
                            }
                            return erbNodeInfo;
                        }
                        if (isJSEmbeddedContent) {
                            this.createAnotherLanguageBlockWrapper(htmlPsi.getLanguage(), htmlPsiNode, subBlocks, indent);
                        } else {
                            this.createAndAddErbHtml(isTag, htmlPsi, subBlocks, htmlPsiTRange, indent, alignment, vProvider);
                        }
                        int htmlPsiEndOffset2 = htmlPsiTRange.getEndOffset();
                        PsiElement htmlEndInErb = ErbFormatterUtil.findErbElementByStartOffset(vProvider, htmlPsiEndOffset2 - 1, false);
                        assert (htmlEndInErb != null);
                        int htmlEndInErbEnd = htmlEndInErb.getTextRange().getEndOffset();
                        if (htmlEndInErbEnd == htmlPsiEndOffset2) {
                            PsiElement nextErb = htmlEndInErb.getNextSibling();
                            ASTNode nextErbNode = nextErb == null ? null : nextErb.getNode();
                            ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, templateNode, nextErbNode);
                            if (erbNodeInfo == null) {
                                ErbBlockGenerator.$$$reportNull$$$0(21);
                            }
                            return erbNodeInfo;
                        }
                        PsiElement nextHtml = ErbFormatterUtil.findUpperHTMLElement(vProvider, htmlPsiEndOffset2, parentNodeTextRange);
                        ASTNode nextHtmlNode = nextHtml == null ? null : nextHtml.getNode();
                        TextRange nextNodeTRange = nextHtmlNode == null ? null : ErbFormatterUtil.safelyCreateTextRange(htmlPsiEndOffset2, htmlEndInErbEnd);
                        ASTNode htmlEndInErbNode = htmlEndInErb.getNode();
                        LOG.assertTrue(htmlEndInErbNode != null, (Object)("Can't be null here! " + String.valueOf(htmlEndInErb)));
                        TemplateNodeInfo templateNodeInfo = NodeInfo.createTemplateInfo(parentNode, htmlEndInErbNode, nextHtmlNode, nextNodeTRange);
                        if (templateNodeInfo == null) {
                            ErbBlockGenerator.$$$reportNull$$$0(22);
                        }
                        return templateNodeInfo;
                    }
                }
                LOG.assertTrue(templateRange.contains(htmlPsiTRange));
                this.createAndAddErbHtml(false, htmlPsi, subBlocks, htmlPsiTRange, indent, alignment, vProvider);
                break block31;
            }
            if (htmlPsi instanceof XmlTag || isJSEmbeddedContent) {
                ErbCodeInjectionTag injectionTag;
                this.createAndAddUnClosedErb(isTag, subBlocks, boundsTRange, htmlPsi, htmlPsiTRange, indent, alignment, vProvider);
                TextRange childRCmpStTRange = childRCmpSt == null ? ErbBlockGenerator.getCoveringRCompSRangeForCorruptedPsi(templateNode, vProvider) : childRCmpSt.getTextRange();
                int childRCmpStEndOffset = childRCmpStTRange.getEndOffset();
                LOG.assertTrue(childRCmpStEndOffset >= boundsTRange.getEndOffset(), (Object)"Must be true in case of hidden html end tag.");
                PsiElement endRubyElementCodeInErb = ErbFormatterUtil.findErbElementByStartOffset(vProvider, childRCmpStEndOffset, true);
                ASTNode nextNode = endRubyElementCodeInErb == null ? null : ((injectionTag = ErbRubyInjectionTagNavigator.getByPsiElement(endRubyElementCodeInErb)) != null ? injectionTag.getNode() : endRubyElementCodeInErb.getNode());
                ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, templateNode, nextNode);
                if (erbNodeInfo == null) {
                    ErbBlockGenerator.$$$reportNull$$$0(23);
                }
                return erbNodeInfo;
            }
            LOG.error("Unexpected composite element: " + String.valueOf(htmlPsi));
        }
        if ((htmlPsiEndOffset = htmlPsiTRange.getEndOffset()) < templateRangeEnd) {
            PsiElement nextHTML = ErbFormatterUtil.findUpperHTMLElement(vProvider, htmlPsiEndOffset, parentNodeTextRange);
            ASTNode nextHtmlNode = nextHTML == null ? null : nextHTML.getNode();
            TextRange nextNodeTRange = nextHtmlNode == null ? null : ErbFormatterUtil.safelyCreateTextRange(htmlPsiEndOffset, templateRangeEnd);
            TemplateNodeInfo templateNodeInfo = NodeInfo.createTemplateInfo(parentNode, templateNode, nextHtmlNode, nextNodeTRange);
            if (templateNodeInfo == null) {
                ErbBlockGenerator.$$$reportNull$$$0(24);
            }
            return templateNodeInfo;
        }
        ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, templateNode, templateNode.getTreeNext());
        if (erbNodeInfo == null) {
            ErbBlockGenerator.$$$reportNull$$$0(25);
        }
        return erbNodeInfo;
    }

    public void createAnotherLanguageBlockWrapper(Language childLanguage, ASTNode child, List<Block> result, Indent indent) {
        PsiElement childPsi = child.getPsi();
        FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext(childLanguage, childPsi);
        LOG.assertTrue(builder2 != null);
        FormattingModel childModel = builder2.createModel(FormattingContext.create((PsiElement)childPsi, (CodeStyleSettings)this.myHelper.getRootSettings()));
        result.add((Block)new ForeignLanguageBlock(child, this.myHelper.getXmlFormattingPolicy(), childModel.getRootBlock(), indent));
    }

    private void createAndAddErbHtml(boolean isTag, PsiElement psiElement, List<Block> subBlocks, TextRange textRange, Indent indent, Alignment alignment, FileViewProvider provider) {
        TextRange textRangeWithoutTrailingWhiteSpaces;
        Wrap wrap = this.myHelper.getWrapProcessor().getWrapForNode(psiElement.getNode(), provider);
        ASTNode node = psiElement.getNode();
        if (textRange != null) {
            int tRangeStart = textRange.getStartOffset();
            int lastElemInTRangeOffset = textRange.getEndOffset();
            PsiElement lastElemInTRange = provider.findElementAt(lastElemInTRangeOffset - 1, (Language)HTMLLanguage.INSTANCE);
            while (lastElemInTRange != null && tRangeStart <= lastElemInTRangeOffset && !ErbFormatterUtil.canBeCorrectBlock(lastElemInTRange.getNode())) {
                lastElemInTRange = provider.findElementAt((lastElemInTRangeOffset -= lastElemInTRange.getTextLength()) - 1, (Language)HTMLLanguage.INSTANCE);
            }
            LOG.assertTrue(tRangeStart < lastElemInTRangeOffset);
            textRangeWithoutTrailingWhiteSpaces = new TextRange(tRangeStart, lastElemInTRangeOffset);
        } else {
            textRangeWithoutTrailingWhiteSpaces = null;
        }
        Object block = isTag ? new ErbHtmlTagBlock(node, wrap, alignment, this.myHelper, indent, provider, textRangeWithoutTrailingWhiteSpaces) : new ErbHtmlBlock(node, wrap, alignment, this.myHelper, indent, provider, textRangeWithoutTrailingWhiteSpaces);
        subBlocks.add((Block)block);
    }

    private void createAndAddUnClosedErb(boolean isTag, List<Block> subBlocks, TextRange boundsTRange, PsiElement htmlPsi, TextRange htmlPsiTRange, Indent indent, Alignment alignment, FileViewProvider provider) {
        TextRange tagBounds = new TextRange(htmlPsiTRange.getStartOffset(), boundsTRange.getEndOffset());
        this.createAndAddErbHtml(isTag, htmlPsi, subBlocks, tagBounds, indent, alignment, provider);
    }

    @NotNull
    private ErbNodeInfo processErbInjectionTag(@NotNull ASTNode erbTagNode, ASTNode parentNode, @NotNull List<Block> blockList, @NotNull Indent indent, @Nullable Alignment alignment, RCompoundStatement parentNodeRCmpSt, FileViewProvider fileViewProvider) {
        if (erbTagNode == null) {
            ErbBlockGenerator.$$$reportNull$$$0(26);
        }
        if (blockList == null) {
            ErbBlockGenerator.$$$reportNull$$$0(27);
        }
        if (indent == null) {
            ErbBlockGenerator.$$$reportNull$$$0(28);
        }
        Wrap wrap = this.myHelper.getWrapProcessor().getWrapForNode(erbTagNode, fileViewProvider);
        blockList.add((Block)new ErbCodeInjectionBlock(erbTagNode, indent, wrap, this.myHelper, alignment, parentNode, parentNodeRCmpSt));
        ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(parentNode, erbTagNode, erbTagNode.getTreeNext());
        if (erbNodeInfo == null) {
            ErbBlockGenerator.$$$reportNull$$$0(29);
        }
        return erbNodeInfo;
    }

    private static TextRange getHTMLBoundsInRCmpSt(@NotNull RCompoundStatement st, @NotNull FileViewProvider vProvider) {
        int resultEnd;
        int resultStart;
        if (st == null) {
            ErbBlockGenerator.$$$reportNull$$$0(30);
        }
        if (vProvider == null) {
            ErbBlockGenerator.$$$reportNull$$$0(31);
        }
        TextRange range = st.getTextRange();
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        PsiElement startRubyCodeInErb = ErbFormatterUtil.findErbElementByStartOffset(vProvider, startOffset, true);
        if (startRubyCodeInErb == null) {
            resultStart = startOffset;
        } else {
            ErbCodeInjectionTag startInjection = (ErbCodeInjectionTag)(startRubyCodeInErb instanceof ErbCodeInjectionTag ? startRubyCodeInErb : ErbRubyInjectionTagNavigator.getByPsiElement(startRubyCodeInErb));
            resultStart = startInjection != null ? startInjection.getTextRange().getEndOffset() : startOffset;
        }
        PsiElement endRubyCodeInErb = ErbFormatterUtil.findErbElementByStartOffset(vProvider, endOffset, true);
        if (endRubyCodeInErb == null) {
            resultEnd = endOffset;
        } else {
            ErbCodeInjectionTag enInjectionTag = (ErbCodeInjectionTag)(endRubyCodeInErb instanceof ErbCodeInjectionTag ? endRubyCodeInErb : ErbRubyInjectionTagNavigator.getByPsiElement(endRubyCodeInErb));
            resultEnd = enInjectionTag != null ? enInjectionTag.getTextRange().getStartOffset() : endOffset;
        }
        return new TextRange(resultStart, resultEnd);
    }

    @NotNull
    private static TextRange getCoveringRCompSRangeForCorruptedPsi(ASTNode templateNode, FileViewProvider vProvider) {
        TextRange childCoveringRCmpStRange;
        int boundsStart = templateNode.getStartOffset();
        PsiElement rubyPsi = vProvider.findElementAt(boundsStart, (Language)RubyLanguage.INSTANCE);
        if (rubyPsi == null) {
            childCoveringRCmpStRange = null;
        } else {
            boolean isRCompStMissed = rubyPsi.getParent() instanceof RFile || rubyPsi instanceof ErbOuterLanguageElement;
            TextRange textRange = childCoveringRCmpStRange = isRCompStMissed ? rubyPsi.getParent().getTextRange() : null;
        }
        assert (childCoveringRCmpStRange != null) : "Covering compound statement wasn't found!\nChild range: " + templateNode.getTextRange().toString() + "\nChild parent = " + String.valueOf(templateNode.getPsi().getParent()) + "\nFile:\n\n" + templateNode.getPsi().getContainingFile().getText();
        TextRange textRange = childCoveringRCmpStRange;
        if (textRange == null) {
            ErbBlockGenerator.$$$reportNull$$$0(32);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 12, 13, 14, 15, 16, 17, 26, 27, 28, 30, 31 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/helpers/ErbBlockGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileViewProvider";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNodeTextRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRange";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subBlocks";
                break;
            }
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vProvider";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "erbTagNode";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockList";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "st";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getErbGraphQLInjectedLanguageBlockBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/helpers/ErbBlockGenerator";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processContentChildNode";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "processHTMLTemplateData";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "processErbInjectionTag";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveringRCompSRangeForCorruptedPsi";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createErbSubBlocks";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processContentChildNode";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processHTMLTemplateData";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processErbInjectionTag";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getHTMLBoundsInRCmpSt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 12, 13, 14, 15, 16, 17, 26, 27, 28, 30, 31 -> new IllegalArgumentException(string);
        };
    }
}

