/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AbstractSyntheticBlock;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbElementTypes;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.ErbOuterLanguageElement;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.erb.psi.IErbElementType;
import org.jetbrains.plugins.ruby.erb.psi.IErbOuterElementType;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbCodeInjectionBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbHtmlBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormatterUtil;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormattingHelper;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbWrapProcessor;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.nodeInfo.ErbNodeInfo;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.nodeInfo.NodeInfo;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.nodeInfo.TemplateNodeInfo;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;

public class ErbHtmlTagBlock
extends XmlTagBlock {
    private static final Logger LOG = Logger.getInstance(ErbHtmlTagBlock.class);
    private static final TokenSet TAG_BRACKETS = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_TAG_END});
    private final TextRange myTextRange;
    private final FileViewProvider myViewProvider;
    private final RCompoundStatement myNodeCmpSt;
    private final ErbFormattingHelper myHelper;

    public ErbHtmlTagBlock(ASTNode node, Wrap wrap, Alignment alignment, @NotNull ErbFormattingHelper helper, Indent indent, FileViewProvider viewProvider, @Nullable TextRange textRange) {
        if (helper == null) {
            ErbHtmlTagBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment, helper.getXmlFormattingPolicy(), indent);
        this.myHelper = helper;
        this.myTextRange = textRange == null ? this.myNode.getTextRange() : textRange;
        this.myViewProvider = viewProvider;
        this.myNodeCmpSt = ErbFormatterUtil.getParentRCmpStByErbOrHTMLChildNode(this.myViewProvider, this.myNode);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        XmlTag tag = this.getTag();
        if (tag != null && this.myXmlFormattingPolicy.indentChildrenOf(tag)) {
            return new ChildAttributes(this.getTagContentChildIndent(newChildIndex), null);
        }
        return new ChildAttributes(Indent.getNoneIndent(), null);
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            ErbHtmlTagBlock.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    protected NodeInfo processChildAndGetNext(List<Block> result, ASTNode htmlChild, NodeInfo childNodeInfo, Wrap wrap, Alignment alignment, Indent erbIndent) {
        IElementType htmlChildElementType = htmlChild.getElementType();
        if (htmlChildElementType == XmlElementType.XML_DOCTYPE) {
            result.add((Block)new XmlBlock(htmlChild, wrap, alignment, this.myXmlFormattingPolicy, erbIndent, null){

                protected Wrap getDefaultWrap(ASTNode node) {
                    IElementType type = node.getElementType();
                    Wrap wrap = ErbWrapProcessor.createTagAttributesWrap(1.getWrapType((int)ErbHtmlTagBlock.this.myXmlFormattingPolicy.getAttributesWrap()));
                    return type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN ? wrap : null;
                }
            });
            ErbNodeInfo erbNodeInfo = NodeInfo.createErbInfo(this.myNode, htmlChild, htmlChild.getTreeNext());
            if (erbNodeInfo == null) {
                ErbHtmlTagBlock.$$$reportNull$$$0(2);
            }
            return erbNodeInfo;
        }
        Language language = htmlChildElementType.getLanguage();
        if (language == RubyLanguage.INSTANCE || htmlChildElementType instanceof IErbElementType || htmlChildElementType instanceof IErbOuterElementType || htmlChild instanceof XmlTag || htmlChild instanceof XmlText || htmlChild instanceof CompositeElement && htmlChildElementType != TokenType.ERROR_ELEMENT) {
            if (childNodeInfo.isTemplate()) {
                ASTNode childNode = ((TemplateNodeInfo)childNodeInfo).getTemplateDataNode();
                NodeInfo nodeInfo = this.myHelper.getBlockGenerator().processContentChildNode(childNode, childNodeInfo, this.myNode, result, this.myNodeCmpSt, this.myViewProvider, this.getTextRange(), alignment, erbIndent);
                if (nodeInfo == null) {
                    ErbHtmlTagBlock.$$$reportNull$$$0(3);
                }
                return nodeInfo;
            }
            int childStartOffset = htmlChild.getStartOffset();
            PsiElement erbProjection = ErbFormatterUtil.findErbElementByStartOffset(this.myViewProvider, childStartOffset, true);
            LOG.assertTrue(erbProjection != null);
            ASTNode erbNode = erbProjection.getNode();
            int erbEnd = erbNode.getTextRange().getEndOffset();
            ErbNodeInfo info = erbNode.getElementType() == ErbElementTypes.ERB_XML_TAG ? NodeInfo.createErbInfo(this.myNode, null, erbNode) : NodeInfo.createTemplateInfo(this.myNode, erbNode, erbNode, new TextRange(childStartOffset, erbEnd));
            NodeInfo nodeInfo = this.myHelper.getBlockGenerator().processContentChildNode(erbNode, info, this.myNode, result, this.myNodeCmpSt, this.myViewProvider, this.getTextRange(), alignment, erbIndent);
            if (nodeInfo == null) {
                ErbHtmlTagBlock.$$$reportNull$$$0(4);
            }
            return nodeInfo;
        }
        result.add((Block)new ErbHtmlBlock(htmlChild, wrap, alignment, this.myHelper, erbIndent, this.myViewProvider, htmlChild.getTextRange()));
        NodeInfo nodeInfo = this.getNextHTMLChildInfo(htmlChild);
        if (nodeInfo == null) {
            ErbHtmlTagBlock.$$$reportNull$$$0(5);
        }
        return nodeInfo;
    }

    @Nullable
    protected XmlTag getTag() {
        return super.getTag();
    }

    protected List<Block> buildChildren() {
        ASTNode child = this.myNode.getFirstChildNode();
        NodeInfo childNodeInfo = NodeInfo.createErbInfo(this.myNode, null, child);
        RCompoundStatement prevChildRCmpSt = this.myNodeCmpSt;
        Wrap attrWrap = ErbWrapProcessor.createTagAttributesWrap(ErbHtmlTagBlock.getWrapType((int)this.myXmlFormattingPolicy.getAttributesWrap()));
        XmlTag tag = this.getTag();
        Wrap textWrap = ErbWrapProcessor.createTagTextWrap(ErbHtmlTagBlock.getWrapType((int)this.myXmlFormattingPolicy.getTextWrap(tag)));
        Wrap tagBeginWrap = this.createTagBeginWrapping(tag);
        Alignment attrAlignment = Alignment.createAlignment();
        Alignment textAlignment = Alignment.createAlignment();
        ArrayList<Block> result = new ArrayList<Block>(3);
        ArrayList<Object> localResult = new ArrayList<Block>(1);
        boolean insideTag = true;
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) && child.getTextLength() > 0) {
                Language childLanguage = child.getPsi().getLanguage();
                if (!(childLanguage instanceof XMLLanguage || childLanguage instanceof ErbLanguage || childLanguage instanceof RubyLanguage || childLanguage == Language.ANY)) {
                    this.myInjectedBlockBuilder.addInjectedLanguageBlockWrapper(result, child, Indent.getNormalIndent(), 0, null);
                    childNodeInfo = this.getNextHTMLChildInfo(child);
                    child = ErbHtmlTagBlock.getNextHtmlChild(childNodeInfo, this.getTextRange());
                    continue;
                }
                Wrap wrap = this.chooseWrap(child, tagBeginWrap, attrWrap, textWrap);
                Alignment alignment = this.chooseAlignment(child, attrAlignment, textAlignment, insideTag);
                RCompoundStatement childRCmpSt = ErbFormatterUtil.getParentRCmpStByErbOrHTMLChildNode(this.myViewProvider, child);
                IElementType childType = child.getElementType();
                if (childType == XmlTokenType.XML_TAG_END) {
                    childNodeInfo = this.processChildAndGetNext(localResult, child, childNodeInfo, wrap, alignment, this.calcTagContentIndent(child, insideTag, childRCmpSt));
                    if (this.isDirectAndNotHiddenChild(child, childRCmpSt)) {
                        result.add(this.createTagDescriptionNode(localResult));
                        localResult = new ArrayList(1);
                        insideTag = true;
                    }
                } else if (childType == XmlTokenType.XML_START_TAG_START) {
                    if (this.isDirectAndNotHiddenChild(child, childRCmpSt)) {
                        if (!localResult.isEmpty()) {
                            result.add(this.createTagContentNode(localResult, this.calcTagContentIndent(child, insideTag, prevChildRCmpSt)));
                            localResult = new ArrayList(1);
                        }
                        insideTag = false;
                    } else {
                        PsiElement htmlProjection = ErbFormatterUtil.findUpperHTMLElement(this.myViewProvider, child.getStartOffset(), this.getTextRange());
                        child = htmlProjection == null ? null : htmlProjection.getNode();
                    }
                    erbIndent = this.calcTagContentIndent(child, insideTag, childRCmpSt);
                    childNodeInfo = this.processChildAndGetNext(localResult, child, childNodeInfo, wrap, alignment, erbIndent);
                } else if (childType == XmlTokenType.XML_END_TAG_START) {
                    if (this.isDirectAndNotHiddenChild(child, childRCmpSt)) {
                        if (!localResult.isEmpty()) {
                            result.add(this.createTagContentNode(localResult, this.calcTagContentIndent(child, insideTag, prevChildRCmpSt)));
                            localResult = new ArrayList(1);
                        }
                        insideTag = false;
                    }
                    erbIndent = this.calcTagContentIndent(child, insideTag, childRCmpSt);
                    childNodeInfo = this.processChildAndGetNext(localResult, child, childNodeInfo, wrap, alignment, erbIndent);
                } else if (childType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    childNodeInfo = this.processChildAndGetNext(localResult, child, childNodeInfo, wrap, alignment, this.calcTagContentIndent(child, insideTag, childRCmpSt));
                    if (this.isDirectAndNotHiddenChild(child, childRCmpSt)) {
                        result.add(this.createTagDescriptionNode(localResult));
                        localResult = new ArrayList(1);
                    }
                } else {
                    if (prevChildRCmpSt != childRCmpSt) {
                        if (!localResult.isEmpty()) {
                            result.add(this.createTagContentNode(localResult, this.calcTagContentIndent(child, insideTag, prevChildRCmpSt)));
                            localResult = new ArrayList(1);
                        }
                        prevChildRCmpSt = childRCmpSt;
                    }
                    childNodeInfo = this.processChildAndGetNext(localResult, child, childNodeInfo, wrap, alignment, this.calcTagContentIndent(child, insideTag, childRCmpSt));
                }
            } else {
                childNodeInfo = this.getNextHTMLChildInfo(child);
            }
            child = ErbHtmlTagBlock.getNextHtmlChild(childNodeInfo, this.getTextRange());
        }
        if (!localResult.isEmpty()) {
            result.add(this.createTagContentNode(localResult, this.calcTagContentIndent(null, insideTag, prevChildRCmpSt)));
        }
        return result;
    }

    @Nullable
    protected Indent getTagContentChildIndent(int newChildIndex) {
        List subBlocks = this.getSubBlocks();
        if (newChildIndex != 0 && newChildIndex < subBlocks.size()) {
            ASTNode node;
            Block block = (Block)subBlocks.get(newChildIndex);
            if (block instanceof SyntheticBlock) {
                Block curFirstSubBlock = (Block)block.getSubBlocks().get(0);
                if (curFirstSubBlock instanceof AbstractBlock) {
                    RCompoundStatement firstSubBlockCmpst;
                    ASTNode curFirstSubBlockNode = ((AbstractBlock)curFirstSubBlock).getNode();
                    IElementType curFirstSubBlockType = curFirstSubBlockNode.getElementType();
                    if (newChildIndex == subBlocks.size() - 1 && curFirstSubBlockType == XmlTokenType.XML_END_TAG_START) {
                        Block prev = (Block)subBlocks.get(newChildIndex - 1);
                        if (prev instanceof SyntheticBlock) {
                            ASTNode prevLastSubBlockNode;
                            List prevSubBlocks = prev.getSubBlocks();
                            Block prevLastSubBlock = (Block)prevSubBlocks.get(prevSubBlocks.size() - 1);
                            if (prevLastSubBlock instanceof AbstractBlock && (prevLastSubBlockNode = ((AbstractBlock)prevLastSubBlock).getNode()).getElementType() == XmlTokenType.XML_TAG_END) {
                                return this.myHelper.getIndentProcessor().calcHTMLIndentForChild(prevLastSubBlockNode.getTreeParent());
                            }
                            return prev.getChildAttributes(prevSubBlocks.size() - 1).getChildIndent();
                        }
                    } else if (curFirstSubBlock instanceof ErbCodeInjectionBlock && (firstSubBlockCmpst = ErbFormatterUtil.getRCmpStNodeStartOffset(this.myViewProvider, curFirstSubBlockNode)) != null && ErbFormatterUtil.isErbXmlTagForRubyBlockEnd(curFirstSubBlockNode, firstSubBlockCmpst, this.myViewProvider)) {
                        RCompoundStatement parentCmpSt = ((ErbCodeInjectionBlock)curFirstSubBlock).getParentRCmpSt();
                        ASTNode parentNode = ((ErbCodeInjectionBlock)curFirstSubBlock).getParentNode();
                        return this.myHelper.getIndentProcessor().calcErbIndentForChild(firstSubBlockCmpst, parentCmpSt, parentNode, true);
                    }
                }
                return block.getChildAttributes(newChildIndex).getChildIndent();
            }
            ASTNode aSTNode = node = block instanceof AbstractBlock ? ((AbstractBlock)block).getNode() : null;
            if (node != null) {
                RCompoundStatement childCmpSt = ErbFormatterUtil.getParentRCmpStByErbOrHTMLChildNode(this.myViewProvider, node);
                return this.getChildrenIndent(childCmpSt);
            }
        }
        return Indent.getNormalIndent();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        boolean saveSpacesBetweenTagAndText;
        XmlTag startTag;
        AbstractSyntheticBlock syntheticBlock1;
        XmlTag tag;
        block20: {
            block19: {
                if (child2 == null) {
                    ErbHtmlTagBlock.$$$reportNull$$$0(6);
                }
                if ((tag = this.getTag()) == null) {
                    return this.createDefaultSpace(true, true);
                }
                if (!(child1 instanceof AbstractSyntheticBlock)) break block19;
                syntheticBlock1 = (AbstractSyntheticBlock)child1;
                if (child2 instanceof AbstractSyntheticBlock) break block20;
            }
            return this.createDefaultSpace(true, false);
        }
        AbstractSyntheticBlock syntheticBlock2 = (AbstractSyntheticBlock)child2;
        if (syntheticBlock2.startsWithCDATA() || syntheticBlock1.endsWithCDATA()) {
            return Spacing.getReadOnlySpacing();
        }
        if (this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(tag) && !ErbHtmlTagBlock.containsErbInjection(child1) && !ErbHtmlTagBlock.containsErbInjection(child2)) {
            return Spacing.getReadOnlySpacing();
        }
        if (this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces()) {
            return Spacing.getReadOnlySpacing();
        }
        if (syntheticBlock2.startsWithTag() && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(startTag = syntheticBlock2.getStartTag()) && startTag.textContains('\n')) {
            return this.getChildrenIndent(null) != Indent.getNoneIndent() ? Spacing.getReadOnlySpacing() : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        boolean bl = saveSpacesBetweenTagAndText = this.myXmlFormattingPolicy.shouldSaveSpacesBetweenTagAndText() && syntheticBlock1.getTextRange().getEndOffset() < syntheticBlock2.getTextRange().getStartOffset();
        if (syntheticBlock1.endsWithTextElement() && syntheticBlock2.startsWithTextElement()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.endsWithText()) {
            if (syntheticBlock1.insertLineFeedAfter()) {
                return Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)tag.getTextRange(), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            if (saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.isTagDescription() && syntheticBlock2.isTagDescription()) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock2.startsWithText()) {
            if (saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.isTagDescription() && syntheticBlock2.startsWithTag()) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.insertLineFeedAfter()) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.endsWithTag() && syntheticBlock2.isTagDescription()) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return this.createDefaultSpace(true, true);
    }

    @NotNull
    private Indent calcTagContentIndent(@Nullable ASTNode child, boolean insideTag, @Nullable RCompoundStatement childRCmpSt) {
        Indent indent;
        if (!insideTag) {
            ASTNode previousChild = child != null ? child.getTreePrev() : null;
            indent = previousChild != null && !TAG_BRACKETS.contains(child.getElementType()) && previousChild.textContains('\n') ? Indent.getNormalIndent() : Indent.getNoneIndent();
        } else {
            indent = this.getChildrenIndent(childRCmpSt);
        }
        Indent indent2 = indent;
        if (indent2 == null) {
            ErbHtmlTagBlock.$$$reportNull$$$0(7);
        }
        return indent2;
    }

    private Alignment chooseAlignment(ASTNode child, Alignment attrAlignment, Alignment textAlignment, boolean insideTag) {
        if (!insideTag && child.getElementType() == ErbTokenTypes.ERB_INJECTION_IN_HTML && child.getTreeParent() == this.myNode) {
            return attrAlignment;
        }
        return this.chooseAlignment(child, attrAlignment, textAlignment);
    }

    private Block createTagDescriptionNode(ArrayList<Block> localResult) {
        return new SyntheticBlock(localResult, (Block)this, Indent.getNoneIndent(), this.myXmlFormattingPolicy, null);
    }

    private Block createTagContentNode(@NotNull ArrayList<Block> localResult, Indent childIndent) {
        if (localResult == null) {
            ErbHtmlTagBlock.$$$reportNull$$$0(8);
        }
        return new SyntheticBlock(localResult, (Block)this, Indent.getNoneIndent(), this.myXmlFormattingPolicy, childIndent);
    }

    private NodeInfo getNextHTMLChildInfo(ASTNode child) {
        ASTNode nextChild = child.getTreeNext();
        if (nextChild == null) {
            int childEnd = child.getTextRange().getEndOffset();
            PsiElement htmlElement = ErbFormatterUtil.findUpperHTMLElement(this.myViewProvider, childEnd, this.getTextRange());
            ASTNode aSTNode = nextChild = htmlElement != null ? htmlElement.getNode() : null;
        }
        if (this.ifNextHtmlChildOutOfParentBounds(nextChild)) {
            if (nextChild instanceof CompositeElement) {
                nextChild = nextChild.getFirstChildNode();
                while (nextChild instanceof CompositeElement && this.ifNextHtmlChildOutOfParentBounds(nextChild)) {
                    nextChild = nextChild.getFirstChildNode();
                }
            } else {
                nextChild = null;
            }
        }
        return NodeInfo.createErbInfo(this.myNode, child, nextChild);
    }

    @NotNull
    private Indent getChildrenIndent(@Nullable RCompoundStatement childRCmpSt) {
        if (childRCmpSt == null) {
            Indent indent = this.myHelper.getIndentProcessor().calcHTMLIndentForChild(this.myNode);
            if (indent == null) {
                ErbHtmlTagBlock.$$$reportNull$$$0(9);
            }
            return indent;
        }
        Indent indent = this.myHelper.getIndentProcessor().calcErbIndentForChild(childRCmpSt, this.myNodeCmpSt, this.myNode, true);
        if (indent == null) {
            ErbHtmlTagBlock.$$$reportNull$$$0(10);
        }
        return indent;
    }

    private boolean isDirectAndNotHiddenChild(ASTNode child, RCompoundStatement childRCmpSt) {
        return child.getTreeParent() == this.myNode && childRCmpSt == this.myNodeCmpSt;
    }

    private boolean ifNextHtmlChildOutOfParentBounds(ASTNode nextChild) {
        return nextChild != null && nextChild.getStartOffset() >= this.getTextRange().getEndOffset();
    }

    public static ASTNode getNextHtmlChild(@NotNull NodeInfo childNodeInfo, TextRange textRange) {
        ASTNode child;
        if (childNodeInfo == null) {
            ErbHtmlTagBlock.$$$reportNull$$$0(11);
        }
        if ((child = NodeInfo.getNextNodeByInfo(childNodeInfo)) instanceof ErbOuterLanguageElement) {
            FileViewProvider vProvider = child.getPsi().getContainingFile().getViewProvider();
            PsiElement htmlProjection = ErbFormatterUtil.findUpperHTMLElement(vProvider, child.getStartOffset(), textRange);
            child = htmlProjection == null ? null : htmlProjection.getNode();
        }
        return child;
    }

    private static boolean containsErbInjection(@NotNull Block block) {
        if (block == null) {
            ErbHtmlTagBlock.$$$reportNull$$$0(12);
        }
        return ContainerUtil.exists((Iterable)block.getSubBlocks(), it -> it instanceof ErbCodeInjectionBlock);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/blocks/ErbHtmlTagBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localResult";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNodeInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/blocks/ErbHtmlTagBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processChildAndGetNext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTagContentIndent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTagContentNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNextHtmlChild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsErbInjection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

