/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbElementTypes;
import org.jetbrains.plugins.ruby.erb.psi.IErbElementType;
import org.jetbrains.plugins.ruby.erb.psi.IErbOuterElementType;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbHtmlTagBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbIncompleteBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormatterUtil;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormattingHelper;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.nodeInfo.ErbNodeInfo;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.nodeInfo.NodeInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;

public class ErbHtmlBlock
extends XmlBlock {
    private static final Logger LOG = Logger.getInstance(ErbHtmlBlock.class);
    private final FileViewProvider myViewProvider;
    private final RCompoundStatement myNodeCmpSt;
    private final ErbFormattingHelper myHelper;

    public ErbHtmlBlock(ASTNode node, Wrap wrap, Alignment alignment, @NotNull ErbFormattingHelper helper, Indent indent, FileViewProvider provider, TextRange textRange) {
        if (helper == null) {
            ErbHtmlBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment, helper.getXmlFormattingPolicy(), indent, textRange);
        this.myHelper = helper;
        this.myViewProvider = provider;
        this.myNodeCmpSt = ErbFormatterUtil.getParentRCmpStByErbOrHTMLChildNode(this.myViewProvider, this.myNode);
    }

    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            ErbHtmlBlock.$$$reportNull$$$0(1);
        }
        if (child1 == null) {
            return super.getSpacing(null, child2);
        }
        ASTNode childNode1 = ErbFormatterUtil.getNodeByBlockForErbFormatter(child1);
        ASTNode childNode2 = ErbFormatterUtil.getNodeByBlockForErbFormatter(child2);
        if (childNode2 == null) {
            return Spacing.getReadOnlySpacing();
        }
        Spacing spacing = this.myHelper.getSpacingProcessor().getSpacing(this.getNode(), childNode1, childNode2);
        return spacing != null ? spacing : super.getSpacing(child1, child2);
    }

    protected List<Block> buildChildren() {
        if (this.myNode.getElementType() == XmlElementType.XML_ATTRIBUTE_VALUE) {
            if (this.myNode.getFirstChildNode() != null) {
                ArrayList<Block> result = new ArrayList<Block>(5);
                ASTNode child = this.myNode.getFirstChildNode();
                while (child != null) {
                    if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) && child.getTextLength() > 0) {
                        child = this.processChild(result, child, null, null, Indent.getNoneIndent());
                    }
                    if (child == null) continue;
                    child = child.getTreeNext();
                }
                return result;
            }
            return EMPTY;
        }
        List children = super.buildChildren();
        int astEnd = this.myNode.getTextRange().getEndOffset();
        int textRangeEnd = this.getTextRange().getEndOffset();
        if (textRangeEnd > astEnd) {
            children.add(new ErbIncompleteBlock(new TextRange(astEnd, textRangeEnd)));
        }
        return children;
    }

    @Nullable
    protected ASTNode processChild(@NotNull List<Block> result, @NotNull ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        TextRange childTRange;
        if (result == null) {
            ErbHtmlBlock.$$$reportNull$$$0(2);
        }
        if (child == null) {
            ErbHtmlBlock.$$$reportNull$$$0(3);
        }
        if ((childTRange = child.getTextRange()) == null) {
            return null;
        }
        TextRange nodeTRange = this.getTextRange();
        if (!nodeTRange.contains(childTRange)) {
            TextRange boundsTRange = nodeTRange.intersection(childTRange);
            if (boundsTRange != null) {
                result.add((Block)new ErbBlock(child, indent, wrap, this.myHelper, boundsTRange, alignment));
            }
            return null;
        }
        IElementType childNodeType = child.getElementType();
        if (childNodeType instanceof IErbElementType || childNodeType instanceof IErbOuterElementType) {
            int childStartOffset = child.getStartOffset();
            PsiElement erbProjection = ErbFormatterUtil.findErbElementByStartOffset(this.myViewProvider, childStartOffset, true);
            LOG.assertTrue(erbProjection != null);
            ASTNode erbNode = erbProjection.getNode();
            int erbEnd = erbNode.getTextRange().getEndOffset();
            ErbNodeInfo info = erbNode.getElementType() == ErbElementTypes.ERB_XML_TAG ? NodeInfo.createErbInfo(this.myNode, null, erbNode) : NodeInfo.createTemplateInfo(this.myNode, erbNode, erbNode, new TextRange(childStartOffset, erbEnd));
            NodeInfo nextNodeInfo = this.myHelper.getBlockGenerator().processContentChildNode(erbNode, info, this.myNode, result, this.myNodeCmpSt, this.myViewProvider, nodeTRange, alignment, null);
            ASTNode nextChild = ErbHtmlTagBlock.getNextHtmlChild(nextNodeInfo, nodeTRange);
            return nextChild != null ? nextChild.getTreePrev() : null;
        }
        if (child instanceof XmlAttributeValue) {
            result.add((Block)new ErbHtmlBlock(child, wrap, alignment, this.myHelper, indent, this.myViewProvider, childTRange));
        } else {
            result.add((Block)new XmlBlock(child, wrap, alignment, this.myHelper.getXmlFormattingPolicy(), indent, childTRange));
        }
        return child;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/blocks/ErbHtmlBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processChild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

