/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.LazyInitializer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.formatter.ErbGraphQLInjectionBodyBlock;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.blocks.ErbBlock;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormatterUtil;
import org.jetbrains.plugins.ruby.rails.langs.erb.lang.formatter.helpers.ErbFormattingHelper;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;

public class ErbCodeInjectionBlock
extends ErbBlock {
    private final Indent myCodeIndent;
    private final Alignment myCodeAlignment;
    private final RCompoundStatement myParentRCmpSt;
    private final ASTNode myParentNode;

    public ErbCodeInjectionBlock(@NotNull ASTNode node, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull ErbFormattingHelper helper, @Nullable Alignment alignment, @Nullable ASTNode parentNode, @Nullable RCompoundStatement parentRCmpSt) {
        if (node == null) {
            ErbCodeInjectionBlock.$$$reportNull$$$0(0);
        }
        if (helper == null) {
            ErbCodeInjectionBlock.$$$reportNull$$$0(1);
        }
        super(node, indent, wrap, helper, alignment);
        this.myCodeIndent = Indent.getNormalIndent();
        this.myCodeAlignment = Alignment.createAlignment();
        this.myParentRCmpSt = parentRCmpSt;
        this.myParentNode = parentNode;
    }

    @Override
    @NotNull
    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>(3);
        for (ASTNode childNode = this.myNode.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (!ErbFormatterUtil.canBeCorrectBlock(childNode)) continue;
            IElementType childNodeType = childNode.getElementType();
            if (ErbTokenTypes.ERB_SEPARATORS.contains(childNodeType) || childNodeType == ErbTokenTypes.OMIT_NEW_LINE) {
                Wrap wrap = this.myHelper.getWrapProcessor().getWrapForNode(childNode, null);
                result.add((Block)new ErbBlock(childNode, Indent.getNoneIndent(), wrap, this.myHelper, null));
                continue;
            }
            if (ErbTokenTypes.RUBY_CODE_CHARACTERS == childNodeType) {
                this.processRubyCodeCharacters(result, childNode, this.myCodeAlignment, this.myCodeIndent);
                continue;
            }
            if (childNodeType != ErbTokenTypes.GRAPHQL_TEMPLATE_BLOCK) continue;
            result.add((Block)new ErbGraphQLInjectionBodyBlock(childNode, this.myHelper.getBlockGenerator().getErbGraphQLInjectedLanguageBlockBuilder()));
        }
        ArrayList<Block> arrayList = result;
        if (arrayList == null) {
            ErbCodeInjectionBlock.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.myCodeIndent, null);
    }

    @Nullable
    public RCompoundStatement getParentRCmpSt() {
        return this.myParentRCmpSt;
    }

    @Nullable
    public ASTNode getParentNode() {
        return this.myParentNode;
    }

    public void processRubyCodeCharacters(List<Block> subBlocks, ASTNode node, Alignment childrenAlignment, Indent childrenIndent) {
        PsiElement curRuby;
        PsiElement nodePsi = node.getPsi();
        int startOffset = node.getStartOffset();
        int endOffset = node.getTextRange().getEndOffset();
        FileViewProvider viewProvider = nodePsi.getContainingFile().getViewProvider();
        for (curRuby = viewProvider.findElementAt(startOffset); curRuby != null && curRuby.getParent() != null && curRuby.getParent().getTextRange().getStartOffset() == startOffset; curRuby = curRuby.getParent()) {
        }
        while (curRuby != null && curRuby.getTextRange().getStartOffset() < endOffset) {
            PsiElement nextRuby;
            ASTNode currRubyNode = curRuby.getNode();
            if (currRubyNode != null && ErbFormatterUtil.canBeCorrectBlock(currRubyNode)) {
                TextRange patchedTextRange;
                boolean elementExceedBelowBounds;
                TextRange curRubyTRange = curRuby.getTextRange();
                boolean elementExceedUpperBounds = curRubyTRange.getStartOffset() < startOffset;
                boolean bl = elementExceedBelowBounds = curRubyTRange.getEndOffset() > endOffset;
                if (elementExceedBelowBounds || elementExceedUpperBounds) {
                    int curRubyStart = Math.max(curRubyTRange.getStartOffset(), startOffset);
                    int curRubyEnd = Math.min(curRubyTRange.getEndOffset(), endOffset);
                    patchedTextRange = new TextRange(curRubyStart, curRubyEnd);
                } else {
                    patchedTextRange = null;
                }
                LazyInitializer.LazyValue wrap = LazyInitializer.create(() -> this.myHelper.getWrapProcessor().getWrapForNode(currRubyNode, viewProvider));
                RubyBlock rubyBlock = RubyBlock.isNonIndentableNode((ASTNode)currRubyNode) ? new RubyBlock(null, currRubyNode, LazyInitializer.create(Indent::getAbsoluteNoneIndent), wrap, null, this.myHelper.getRubyFormattingHelper(), patchedTextRange) : new RubyBlock(null, currRubyNode, LazyInitializer.create(() -> childrenIndent), wrap, LazyInitializer.create(() -> childrenAlignment), this.myHelper.getRubyFormattingHelper(), patchedTextRange);
                if (rubyBlock.getTextRange().getLength() > 0) {
                    subBlocks.add((Block)rubyBlock);
                }
                if (elementExceedBelowBounds) {
                    return;
                }
            }
            if ((nextRuby = curRuby.getNextSibling()) == null) {
                ASTNode nextNode;
                for (PsiElement curParent = curRuby.getParent(); nextRuby == null && curParent != null && !(curParent instanceof PsiFile); curParent = curParent.getParent()) {
                    nextRuby = curParent.getNextSibling();
                }
                if (nextRuby != null && ((nextNode = nextRuby.getNode()) == null || nextNode.getStartOffset() >= endOffset)) {
                    nextRuby = null;
                }
            }
            curRuby = nextRuby;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/blocks/ErbCodeInjectionBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/langs/erb/lang/formatter/blocks/ErbCodeInjectionBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

