/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.inspections.rails3.checklist;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.codeInsight.ActiveRecordType;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsPartialView;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RIdentifierImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;

public final class RailsChecklistHelper {
    public static final String FIND_METHOD_PREFIX = "find";
    private static final String FIND_OR_CREATE_METHOD_PREFIX = "find_or_create";

    private RailsChecklistHelper() {
    }

    public static boolean isCallModelMethod(@NotNull RDotReference dotReference) {
        RPsiElement receiver;
        if (dotReference == null) {
            RailsChecklistHelper.$$$reportNull$$$0(0);
        }
        if ((receiver = dotReference.getReceiver()) == null) {
            return false;
        }
        PsiReference reference = receiver.getReference();
        if (reference == null) {
            return false;
        }
        RType type = null;
        PsiElement resolvedReference = reference.resolve();
        if (resolvedReference != null) {
            if (resolvedReference instanceof RInstanceVariable) {
                RInstanceVariable variable = (RInstanceVariable)resolvedReference;
                RAssignmentExpression assignment = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)variable);
                if (assignment != null) {
                    type = assignment.getType();
                }
            } else if (resolvedReference instanceof RClass) {
                RClass call = (RClass)resolvedReference;
                type = RTypeUtil.getTypeByClass(call);
            } else if (resolvedReference instanceof RIdentifierImpl) {
                RIdentifierImpl identifier = (RIdentifierImpl)resolvedReference;
                type = identifier.getType();
            }
            if (type instanceof ActiveRecordType) {
                return true;
            }
        }
        return false;
    }

    private static boolean isFindMethod(@NotNull RDotReference dotReference) {
        String command;
        if (dotReference == null) {
            RailsChecklistHelper.$$$reportNull$$$0(1);
        }
        return (command = dotReference.getCommand()) != null && RailsChecklistHelper.isFind(command);
    }

    private static boolean isFind(String name) {
        return name != null && name.startsWith(FIND_METHOD_PREFIX) && !name.startsWith(FIND_OR_CREATE_METHOD_PREFIX);
    }

    public static boolean isModelFindMethod(@NotNull RDotReference dotReference) {
        if (dotReference == null) {
            RailsChecklistHelper.$$$reportNull$$$0(2);
        }
        return RailsChecklistHelper.isFindMethod(dotReference) && RailsChecklistHelper.isCallModelMethod(dotReference);
    }

    public static boolean isViewElement(@NotNull RPsiElement rPsiElement) {
        if (rPsiElement == null) {
            RailsChecklistHelper.$$$reportNull$$$0(3);
        }
        PsiFile rFile = rPsiElement.getContainingFile();
        RailsView view = RailsView.fromFile(rFile);
        RailsPartialView partialView = RailsPartialView.fromFile(rFile);
        return view != null || partialView != null;
    }

    public static boolean isHelperElement(@NotNull RPsiElement rPsiElement) {
        PsiFile file;
        RailsHelper helper;
        if (rPsiElement == null) {
            RailsChecklistHelper.$$$reportNull$$$0(4);
        }
        return (helper = RailsHelper.fromFile(file = rPsiElement.getContainingFile())) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPsiElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/inspections/rails3/checklist/RailsChecklistHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallModelMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFindMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModelFindMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isViewElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isHelperElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

