/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.inspections.rails3;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyDeprecatedSymbolInspection
extends LocalInspectionTool {
    public boolean showForOldProjects = false;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyDeprecatedSymbolInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/rails/inspections/rails3/RubyDeprecatedSymbolInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RubyInspectionVisitor {
        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRDotReference(@NotNull RDotReference reference) {
            PsiElement command;
            if (reference == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((command = reference.getPsiCommand()) == null) {
                return;
            }
            this.checkCall((RPsiElement)reference, command);
        }

        public void visitRFid(@NotNull RFid identifier) {
            if (identifier == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.checkCall((RPsiElement)identifier, (PsiElement)identifier);
        }

        public void visitRIdentifier(@NotNull RIdentifier identifier) {
            if (identifier == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (identifier.isLocalVariable() || identifier.isParameter()) {
                return;
            }
            this.checkCall((RPsiElement)identifier, (PsiElement)identifier);
        }

        private void checkCall(@NotNull RPsiElement expression, @NotNull PsiElement highlightElement) {
            Symbol symbol;
            if (expression == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if (highlightElement == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (!((symbol = ResolveUtil.resolveToSymbolWithCaching(expression.getReference())) instanceof RMethodSymbol)) {
                return;
            }
            for (PsiElement element : symbol.getAllDeclarations((PsiElement)expression)) {
                RMethod method;
                if (!element.isValid() || !(element instanceof RMethod) || !(method = (RMethod)element).isDeprecated()) continue;
                FQN name = symbol.getFQNWithNesting();
                this.registerProblem(highlightElement, RBundle.message((String)"inspection.rails3.call.deprecated", (Object[])new Object[]{name}), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightElement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/inspections/rails3/RubyDeprecatedSymbolInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRDotReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRFid";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIdentifier";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

