/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.inspections.paramdefs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;

public class InspectionResult {
    private final LocalQuickFix[] myQuickFixes;
    private final @InspectionMessage String myProblemDescription;
    private final ProblemHighlightType myHighlightingType;
    private final PsiElement myAffectedPsiElement;
    private final Type myType;

    protected InspectionResult(@NotNull PsiElement affectedPsiElement, @Nullable ProblemHighlightType highlightingType, @NotNull Type type, @Nullable @InspectionMessage String problemDescription, LocalQuickFix ... quickFixes) {
        if (affectedPsiElement == null) {
            InspectionResult.$$$reportNull$$$0(0);
        }
        if (type == null) {
            InspectionResult.$$$reportNull$$$0(1);
        }
        if (quickFixes == null) {
            InspectionResult.$$$reportNull$$$0(2);
        }
        this.myQuickFixes = quickFixes;
        this.myProblemDescription = problemDescription;
        this.myHighlightingType = highlightingType;
        this.myAffectedPsiElement = affectedPsiElement;
        this.myType = type;
    }

    public static InspectionResult createEmptyResult(@NotNull PsiElement affectedElement) {
        if (affectedElement == null) {
            InspectionResult.$$$reportNull$$$0(3);
        }
        return new InspectionResult(affectedElement, null, Type.PROBLEM, null, new LocalQuickFix[0]);
    }

    public static InspectionResult createOkResult(@NotNull PsiElement affectedElement) {
        if (affectedElement == null) {
            InspectionResult.$$$reportNull$$$0(4);
        }
        return new InspectionResult(affectedElement, null, Type.OK, null, new LocalQuickFix[0]);
    }

    public static InspectionResult createIgnoredResult(@NotNull PsiElement affectedElement) {
        if (affectedElement == null) {
            InspectionResult.$$$reportNull$$$0(5);
        }
        return new InspectionResult(affectedElement, null, Type.IGNORED, null, new LocalQuickFix[0]);
    }

    public static InspectionResult createProbablyAcceptibleResult(@NotNull PsiElement affectedElement) {
        if (affectedElement == null) {
            InspectionResult.$$$reportNull$$$0(6);
        }
        return new InspectionResult(affectedElement, null, Type.PROBABLY_OK, null, new LocalQuickFix[0]);
    }

    public static InspectionResult createWarningResult(@NotNull PsiElement affectedElement, @NotNull @InspectionMessage String description) {
        if (affectedElement == null) {
            InspectionResult.$$$reportNull$$$0(7);
        }
        if (description == null) {
            InspectionResult.$$$reportNull$$$0(8);
        }
        return InspectionResult.createWarningResultWithFixes(affectedElement, description, new LocalQuickFix[0]);
    }

    public static InspectionResult createNotApplicableResult(@NotNull PsiElement affectedElement, String ... expectations) {
        if (affectedElement == null) {
            InspectionResult.$$$reportNull$$$0(9);
        }
        if (expectations == null) {
            InspectionResult.$$$reportNull$$$0(10);
        }
        return new NotApplicableInspectionResult(affectedElement, Arrays.asList(expectations));
    }

    public static InspectionResult createResultByNotApplicables(NotApplicableInspectionResult ... results) {
        if (results == null) {
            InspectionResult.$$$reportNull$$$0(11);
        }
        ArrayList<String> expectations = new ArrayList<String>();
        for (NotApplicableInspectionResult result : results) {
            expectations.addAll(result.getExpectations());
        }
        return new NotApplicableInspectionResult(results[0].getAffectedPsiElement(), expectations);
    }

    public static InspectionResult createDefaultWarningResult(@NotNull PsiElement affectedElement) {
        if (affectedElement == null) {
            InspectionResult.$$$reportNull$$$0(12);
        }
        return InspectionResult.createWarningResultWithFixes(affectedElement, RBundle.message((String)"inspection.paramdef.unexpected.param.value"), new LocalQuickFix[0]);
    }

    public static InspectionResult createWarningResultWithFix(@NotNull PsiElement affectedElement, @NotNull @InspectionMessage String description, @Nullable LocalQuickFix quickFix) {
        if (affectedElement == null) {
            InspectionResult.$$$reportNull$$$0(13);
        }
        if (description == null) {
            InspectionResult.$$$reportNull$$$0(14);
        }
        if (quickFix == null) {
            return new InspectionResult(affectedElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, Type.PROBLEM, description, new LocalQuickFix[0]);
        }
        return new InspectionResult(affectedElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, Type.PROBLEM, description, quickFix);
    }

    public static InspectionResult createWarningResultWithFixes(@NotNull PsiElement affectedElement, @NotNull @InspectionMessage String description, LocalQuickFix ... quickFixes) {
        if (affectedElement == null) {
            InspectionResult.$$$reportNull$$$0(15);
        }
        if (description == null) {
            InspectionResult.$$$reportNull$$$0(16);
        }
        if (quickFixes == null) {
            InspectionResult.$$$reportNull$$$0(17);
        }
        return new InspectionResult(affectedElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, Type.PROBLEM, description, quickFixes);
    }

    public static InspectionResult createWarningResult(InspectionResult ... results) {
        if (results == null) {
            InspectionResult.$$$reportNull$$$0(18);
        }
        return new AggregatedInsResult(Type.PROBLEM, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, results);
    }

    public LocalQuickFix @NotNull [] getQuickFixes() {
        if (this.myQuickFixes == null) {
            InspectionResult.$$$reportNull$$$0(19);
        }
        return this.myQuickFixes;
    }

    @Nullable
    @InspectionMessage
    public String getProblemDescription() {
        return this.myProblemDescription;
    }

    @Nullable
    public ProblemHighlightType getHighlightingType() {
        return this.myHighlightingType;
    }

    @NotNull
    public PsiElement getAffectedPsiElement() {
        PsiElement psiElement = this.myAffectedPsiElement;
        if (psiElement == null) {
            InspectionResult.$$$reportNull$$$0(20);
        }
        return psiElement;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            InspectionResult.$$$reportNull$$$0(21);
        }
        return type;
    }

    public String toString() {
        return "InspectionResult[type=" + String.valueOf((Object)this.myType) + ", description=" + this.myProblemDescription + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedPsiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedElement";
                break;
            }
            case 8: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectations";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/inspections/paramdefs/InspectionResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/inspections/paramdefs/InspectionResult";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPsiElement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyResult";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOkResult";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createIgnoredResult";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createProbablyAcceptibleResult";
                break;
            }
            case 7: 
            case 8: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createWarningResult";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNotApplicableResult";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createResultByNotApplicables";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultWarningResult";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createWarningResultWithFix";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createWarningResultWithFixes";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 20, 21 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        OK,
        PROBABLY_OK,
        PROBLEM,
        NOT_APPLICABLE,
        IGNORED;

    }

    public static final class NotApplicableInspectionResult
    extends InspectionResult {
        private final List<String> myExpectations;

        private NotApplicableInspectionResult(@NotNull PsiElement affectedPsiElement, @NotNull List<String> expectations) {
            if (affectedPsiElement == null) {
                NotApplicableInspectionResult.$$$reportNull$$$0(0);
            }
            if (expectations == null) {
                NotApplicableInspectionResult.$$$reportNull$$$0(1);
            }
            super(affectedPsiElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, Type.NOT_APPLICABLE, RBundle.message((String)"inspection.message.expected", (Object[])new Object[]{NlsMessages.formatOrList((Collection)ContainerUtil.sorted(new HashSet<String>(expectations)))}), new LocalQuickFix[0]);
            this.myExpectations = new ArrayList<String>(expectations);
        }

        public List<String> getExpectations() {
            return this.myExpectations;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "affectedPsiElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expectations";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/inspections/paramdefs/InspectionResult$NotApplicableInspectionResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AggregatedInsResult
    extends InspectionResult {
        private AggregatedInsResult(@NotNull Type type, ProblemHighlightType highlightingType, InspectionResult ... results) {
            if (type == null) {
                AggregatedInsResult.$$$reportNull$$$0(0);
            }
            super(results[0].getAffectedPsiElement(), highlightingType, type, AggregatedInsResult.gatherDescription(results), AggregatedInsResult.gatherQuickFixes(results));
        }

        @InspectionMessage
        private static String gatherDescription(InspectionResult ... results) {
            return RBundle.message((String)"inspection.paramdef.aggregated.expected.warning", (Object[])new Object[]{StringUtil.join((Collection)ContainerUtil.map((Object[])results, result -> "  " + result.getProblemDescription()), (String)"\n")});
        }

        private static LocalQuickFix[] gatherQuickFixes(InspectionResult ... results) {
            ArrayList fixes = new ArrayList();
            for (InspectionResult result : results) {
                ContainerUtil.addAll(fixes, (Object[])result.getQuickFixes());
            }
            return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/ruby/rails/inspections/paramdefs/InspectionResult$AggregatedInsResult", "<init>"));
        }
    }
}

