/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.inspections.actionMailbox;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.model.RailsMailbox;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.VisibilityUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RailsActionMailboxMissingProcessInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RailsActionMailboxMissingProcessInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/rails/inspections/actionMailbox/RailsActionMailboxMissingProcessInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RubyElementVisitor {
        @NotNull
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitRClass(@NotNull RClass rClass) {
            if (rClass == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (RailsMailbox.isMailbox(rClass) && !MyVisitor.hasProcessMethod(rClass)) {
                PsiElement element = (PsiElement)ObjectUtils.coalesce((Object)rClass.getClassName(), (Object)rClass);
                this.myHolder.registerProblem(element, RBundle.message((String)"inspection.rails.actionMailbox.missing.process.message"), new LocalQuickFix[]{new MyQuickFix()});
            }
        }

        private static boolean hasProcessMethod(@NotNull RClass rClass) {
            if (rClass == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            return RContainerUtil.getMethodByName((RContainer)rClass, "process") != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClass";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/inspections/actionMailbox/RailsActionMailboxMissingProcessInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasProcessMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyQuickFix
    implements IntentionAction,
    LocalQuickFix {
        private MyQuickFix() {
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            MyQuickFix.applyFix(project, descriptor.getPsiElement());
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.rails.actionMailbox.missing.process.fix.name");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getText() {
            String string = RBundle.message((String)"inspection.rails.actionMailbox.missing.process.fix.name");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) {
            CaretModel caretModel;
            RName name;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            if ((name = (RName)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt((caretModel = editor.getCaretModel()).getOffset()), RName.class)) == null) {
                return;
            }
            RMethod method = MyQuickFix.applyFix(project, (PsiElement)name);
            TextRange methodRange = method.getTextRange();
            CharSequence documentText = editor.getDocument().getCharsSequence();
            int newLineOffset = StringUtil.indexOf((CharSequence)documentText, (char)'\n', (int)methodRange.getStartOffset(), (int)methodRange.getEndOffset());
            if (newLineOffset >= 0) {
                caretModel.moveToOffset(newLineOffset + 1);
                editor.getSelectionModel().removeSelection();
                Document document = editor.getDocument();
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, caretModel.getOffset());
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            }
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(5);
            }
            return true;
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static RMethod applyFix(@NotNull Project project, @NotNull PsiElement element) {
            RContainer container;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(6);
            }
            if (element == null) {
                MyQuickFix.$$$reportNull$$$0(7);
            }
            assert (element instanceof RName || element instanceof RClass);
            Object object = container = element instanceof RName ? RClassNavigator.getByName((RName)((RName)element)) : (RContainer)element;
            assert (container != null);
            RMethod method = (RMethod)RubyElementFactoryCore.createElementFromText((Project)project, (String)"def process\n\nend", (LanguageLevel)RubyPsiUtilCore.getLanguageLevel((PsiElement)container));
            PsiElement anchor = MyQuickFix.findAnchor(container);
            if (anchor != null) {
                return (RMethod)ContainerUtil.getOnlyItem(RefactoringPsiHelper.insertElements(anchor, Collections.singletonList(method)));
            }
            return (RMethod)container.getCompoundStatement().addBefore((PsiElement)method, null);
        }

        @Nullable
        private static PsiElement findAnchor(@NotNull RContainer container) {
            if (container == null) {
                MyQuickFix.$$$reportNull$$$0(8);
            }
            return container.getStatements().stream().filter(element -> element instanceof RMethod || element instanceof RClass || VisibilityUtilCore.isVisibilityChangeCall((ASTNode)element.getNode())).findFirst().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/inspections/actionMailbox/RailsActionMailboxMissingProcessInspection$MyQuickFix";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/inspections/actionMailbox/RailsActionMailboxMissingProcessInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findAnchor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

