/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.gems;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.gems.DirectoryGemsProvider;

public final class FrozenRailsGemsProvider
extends DirectoryGemsProvider {
    private static final Pattern MAJOR = Pattern.compile("^\\s*MAJOR\\s*=\\s*(\\d+)$", 8);
    private static final Pattern MINOR = Pattern.compile("^\\s*MINOR\\s*=\\s*(\\d+)$", 8);
    private static final Pattern TINY = Pattern.compile("^\\s*TINY\\s*=\\s*(\\d+)$", 8);

    @Override
    @NotNull
    protected List<VirtualFile> getGemsDirectories(@NotNull Module module) {
        if (module == null) {
            FrozenRailsGemsProvider.$$$reportNull$$$0(0);
        }
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                FrozenRailsGemsProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = ContainerUtil.filter(RailsPaths.getInstance(module).findFiles("vendor", "rails"), VirtualFile::isDirectory);
        if (list == null) {
            FrozenRailsGemsProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    protected String getGemName(@NotNull VirtualFile gemDirectory) {
        String fileName;
        if (gemDirectory == null) {
            FrozenRailsGemsProvider.$$$reportNull$$$0(3);
        }
        String string = FrozenRailsGemsProvider.isRailsGem(fileName = gemDirectory.getName()) ? "rails" : fileName;
        if (string == null) {
            FrozenRailsGemsProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean isRailsGem(String fileName) {
        return "railties".equals(fileName);
    }

    @Override
    @Nullable
    protected String getDefaultGemVersion(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            for (VirtualFile gemsDirectory : this.getGemsDirectories(module)) {
                VirtualFile versionFile = gemsDirectory != null ? gemsDirectory.findFileByRelativePath("railties/lib/rails/version.rb") : null;
                if (versionFile == null) continue;
                return FrozenRailsGemsProvider.getRailsVersion(versionFile);
            }
            return null;
        }));
    }

    @Nullable
    private static String getRailsVersion(@NotNull VirtualFile versionFile) {
        if (versionFile == null) {
            FrozenRailsGemsProvider.$$$reportNull$$$0(5);
        }
        try {
            String contents = VfsUtilCore.loadText((VirtualFile)versionFile);
            String major = null;
            String minor = null;
            String tiny = null;
            Matcher matcher = MAJOR.matcher(contents);
            if (matcher.find()) {
                major = matcher.group(1);
            }
            if ((matcher = MINOR.matcher(contents)).find()) {
                minor = matcher.group(1);
            }
            if ((matcher = TINY.matcher(contents)).find()) {
                tiny = matcher.group(1);
            }
            if (major != null) {
                String result = major;
                result = minor != null ? result + "." + minor : result;
                result = tiny != null ? result + "." + tiny : result;
                return result;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/gems/FrozenRailsGemsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/gems/FrozenRailsGemsProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsDirectories";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGemsDirectories";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGemName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRailsVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

