/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.gems;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemProvider;
import org.jetbrains.plugins.ruby.rails.gems.FrozenGemInfo;

public abstract class DirectoryGemsProvider
implements ModuleGemProvider {
    private final Map<VirtualFile, Collection<GemInfo>> myCachedGems = Collections.synchronizedMap(new HashMap());

    @Override
    @NotNull
    public List<GemInfo> getGemsList(@NotNull Module module) {
        if (module == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(0);
        }
        if (module.isDisposed()) {
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                DirectoryGemsProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<GemInfo> result = new ArrayList<GemInfo>();
        for (VirtualFile file : this.getGemsDirectories(module)) {
            ProgressManager.checkCanceled();
            result.addAll(this.getDirectoryGems(module, file));
        }
        ArrayList<GemInfo> arrayList = result;
        if (arrayList == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean isUnderDependenciesRoot(@NotNull VirtualFile virtualFile, @NotNull Module module) {
        if (virtualFile == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(4);
        }
        for (VirtualFile gemsDirectory : this.getGemsDirectories(module)) {
            if (gemsDirectory == null || !VfsUtilCore.isAncestor((VirtualFile)gemsDirectory, (VirtualFile)virtualFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<GemInfo> getDirectoryGems(@NotNull Module module, @Nullable VirtualFile gemDirectory) {
        if (module == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(5);
        }
        if (gemDirectory == null) {
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                DirectoryGemsProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        Collection<GemInfo> cachedGems = this.myCachedGems.get(gemDirectory);
        if (cachedGems != null) {
            Collection<GemInfo> collection = cachedGems;
            if (collection == null) {
                DirectoryGemsProvider.$$$reportNull$$$0(7);
            }
            return collection;
        }
        Collection<GemInfo> gemsToCache = this.getDirectoryGems(gemDirectory, this.getDefaultGemVersion(module));
        Collection collection = this.myCachedGems.computeIfAbsent(gemDirectory, it -> gemsToCache);
        if (collection == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public Set<VirtualFile> invalidateCaches(@Nullable VirtualFile file) {
        if (file == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                DirectoryGemsProvider.$$$reportNull$$$0(9);
            }
            return set;
        }
        HashSet<VirtualFile> invalidatedRoots = new HashSet<VirtualFile>();
        for (Object key : this.myCachedGems.keySet().toArray()) {
            VirtualFile keyFile = (VirtualFile)key;
            if (!VfsUtilCore.isAncestor((VirtualFile)keyFile, (VirtualFile)file, (boolean)false)) continue;
            this.myCachedGems.remove(keyFile);
            invalidatedRoots.add(keyFile);
        }
        HashSet<VirtualFile> hashSet = invalidatedRoots;
        if (hashSet == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    protected abstract List<VirtualFile> getGemsDirectories(@NotNull Module var1);

    @Nullable
    protected abstract String getGemName(@NotNull VirtualFile var1);

    protected boolean isIgnored(@NotNull VirtualFile gemDirectory) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Nullable
    protected String getGemVersion(@NotNull VirtualFile gemDirectory) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(12);
        }
        return null;
    }

    protected boolean isGitGem(@NotNull VirtualFile gemDirectory) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Nullable
    protected String getGemRef(@NotNull VirtualFile gemDirectory) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(14);
        }
        return null;
    }

    @Nullable
    protected String getDefaultGemVersion(@Nullable Module module) {
        return null;
    }

    private Collection<GemInfo> getDirectoryGems(@NotNull VirtualFile gemsRoot, @Nullable String defaultGemVersion) {
        if (gemsRoot == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(15);
        }
        HashSet<GemInfo> result = new HashSet<GemInfo>();
        for (VirtualFile gemDirectory : gemsRoot.getChildren()) {
            ContainerUtil.addIfNotNull(result, (Object)this.createDirectoryGem(gemDirectory, defaultGemVersion));
        }
        return result;
    }

    @Nullable
    protected GemInfo createDirectoryGem(@NotNull VirtualFile gemDirectory, @Nullable String defaultGemVersion) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.$$$reportNull$$$0(16);
        }
        ProgressManager.checkCanceled();
        if (!gemDirectory.isDirectory() || FileTypeManager.getInstance().isFileIgnored(gemDirectory) || this.isIgnored(gemDirectory)) {
            return null;
        }
        String gemName = this.getGemName(gemDirectory);
        String gemVersion = this.getGemVersion(gemDirectory);
        boolean isGitGem = this.isGitGem(gemDirectory);
        String gemRef = this.getGemRef(gemDirectory);
        return gemName == null ? null : new FrozenGemInfo(gemName, gemVersion != null ? gemVersion : defaultGemVersion, gemDirectory.getUrl(), isGitGem, gemRef);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/gems/DirectoryGemsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemDirectory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/gems/DirectoryGemsProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsList";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryGems";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "invalidateCaches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGemsList";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnderDependenciesRoot";
                break;
            }
            case 5: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryGems";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGemVersion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isGitGem";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGemRef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryGem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

