/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.gems;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigServiceImpl;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyFileSystemUtil;

public class BundlerGemsRefresher
implements ProjectManagerListener,
Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<String> myWatchRequests;

    @NotNull
    public static BundlerGemsRefresher getInstance(@NotNull Project project) {
        if (project == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(0);
        }
        BundlerGemsRefresher bundlerGemsRefresher = (BundlerGemsRefresher)project.getService(BundlerGemsRefresher.class);
        if (bundlerGemsRefresher == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(1);
        }
        return bundlerGemsRefresher;
    }

    @Nullable
    public static BundlerGemsRefresher getInstanceIfCreated(@NotNull Project project) {
        if (project == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(2);
        }
        return (BundlerGemsRefresher)project.getServiceIfCreated(BundlerGemsRefresher.class);
    }

    public BundlerGemsRefresher(@NotNull Project project) {
        if (project == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(3);
        }
        this.myWatchRequests = ConcurrentCollectionFactory.createConcurrentSet();
        this.myProject = project;
    }

    public void projectOpened() {
        if (this.myProject.isDefault()) {
            return;
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            BundleConfig moduleConfig = BundleConfigServiceImpl.getInstance(this.myProject).getConfig(module);
            if (moduleConfig == null) continue;
            this.registerWatchRoot(moduleConfig.getConfigFile().getPath());
        }
        LocalFileSystem.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                BundlerGemsRefresher.this.onFileModified(event.getFile());
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                VirtualFile cacheDir;
                VirtualFile file;
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                Object object = (file = event.getFile()).isDirectory() ? ("vendor".equals(file.getName()) ? file.findChild("cache") : ("cache".equals(file.getName()) ? file : null)) : (cacheDir = null);
                if (cacheDir != null) {
                    Module module = BundlerGemsRefresher.this.getModule(cacheDir);
                    if (!RModuleUtil.getInstance().hasRubySupport(module)) {
                        return;
                    }
                    BundlerGemsRefresher.this.excludeBundleDirectory(module, null, cacheDir);
                } else if (BundlerUtil.isBundlerDir(file)) {
                    VirtualFile config = file.findChild("config");
                    if (config != null) {
                        BundlerGemsRefresher.this.onFileModified(config);
                    }
                } else {
                    BundlerGemsRefresher.this.onFileModified(file);
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                BundlerGemsRefresher.this.onFileDeleted(event.getFile());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                BundlerGemsRefresher.this.onFileModified(event.getFile());
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                BundlerGemsRefresher.this.onFileModified(event.getFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/gems/BundlerGemsRefresher$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCopied";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    private void registerWatchRoot(@NotNull String path) {
        if (path == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(4);
        }
        if (this.myWatchRequests.add(path)) {
            RubyFileSystemUtil.addRootToWatch(path, false, this);
        }
    }

    private void onFileDeleted(@Nullable VirtualFile file) {
        Object pathToRemove;
        if (BundlerUtil.isBundlerDir(file)) {
            pathToRemove = file.getPath() + "/config";
        } else if (BundleConfig.isConfig(file)) {
            pathToRemove = file.getPath();
        } else {
            return;
        }
        Module module = this.getModule(file);
        if (module == null || !RModuleUtil.getInstance().hasRubySupport(module)) {
            return;
        }
        this.myWatchRequests.remove(pathToRemove);
        RubySdkGemLibraryManager.getInstance().refresh();
    }

    @Nullable
    private Module getModule(@NotNull VirtualFile file) {
        VirtualFile parent;
        if (file == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(5);
        }
        if ((parent = file.getParent()) == null) {
            return null;
        }
        VirtualFile grandParent = parent.getParent();
        if (grandParent == null) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(grandParent);
    }

    private void onFileModified(@Nullable VirtualFile file) {
        if (BundlerUtil.isBundlerDir(file)) {
            file = file.findChild("config");
        }
        if (!BundleConfig.isConfig(file)) {
            return;
        }
        Module module = this.getModule(file);
        if (module == null || !RModuleUtil.getInstance().hasRubySupport(module)) {
            return;
        }
        BundleConfig bundleConfig = BundleConfigServiceImpl.getInstance(module.getProject()).getConfig(module);
        if (bundleConfig == null) {
            return;
        }
        this.excludeBundleDirectory(module, file, bundleConfig.getBundlePathVirtualFile());
        RubySdkGemLibraryManager.getInstance().refresh();
    }

    private void excludeBundleDirectory(@NotNull Module module, @Nullable VirtualFile configFile, @Nullable VirtualFile bundleDir) {
        if (module == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(6);
        }
        if (bundleDir == null) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        if (fileIndex.isExcluded(bundleDir)) {
            return;
        }
        VirtualFile theRoot = fileIndex.getContentRootForFile(bundleDir);
        if (theRoot == null) {
            return;
        }
        if (!BundlerGemsRefresher.markFolderAsExcluded(module, bundleDir, theRoot)) {
            return;
        }
        if (configFile != null && fileIndex.isExcluded(configFile)) {
            this.registerWatchRoot(configFile.getPath());
        }
        new Notification("Gem Manager", RBundle.message((String)"gems.directory.excluded.title"), RBundle.message((String)"gems.directory.excluded.message", (Object[])new Object[]{bundleDir.getPath()}), NotificationType.INFORMATION).notify(module.getProject());
    }

    private static boolean markFolderAsExcluded(@NotNull Module module, @NotNull VirtualFile bundleDir, @NotNull VirtualFile theRoot) {
        if (module == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(7);
        }
        if (bundleDir == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(8);
        }
        if (theRoot == null) {
            BundlerGemsRefresher.$$$reportNull$$$0(9);
        }
        return (Boolean)WriteAction.compute(() -> {
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (ContentEntry entry : modifiableModel.getContentEntries()) {
                if (!entry.getUrl().equals(theRoot.getUrl())) continue;
                entry.addExcludeFolder(bundleDir);
                modifiableModel.commit();
                return true;
            }
            return false;
        });
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/gems/BundlerGemsRefresher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/gems/BundlerGemsRefresher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceIfCreated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerWatchRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "excludeBundleDirectory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "markFolderAsExcluded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

