/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.gems;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.gems.GemsWithSpecsProvider;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public class BundlerGemsProvider
extends GemsWithSpecsProvider {
    private final Map<Module, VirtualFile> myCacheDirs = Collections.synchronizedMap(new WeakHashMap());

    @Override
    @Nullable
    protected VirtualFile getGemPathDirectory(Module module) {
        VirtualFile bundleConfigGemsDir;
        if (this.myCacheDirs.containsKey(module)) {
            VirtualFile myCachedDir = this.myCacheDirs.get(module);
            if (myCachedDir.isValid()) {
                return myCachedDir;
            }
            this.myCacheDirs.remove(module);
        }
        if ((bundleConfigGemsDir = BundlerUtil.getBundlerGemsDirFromConfig(module)) != null) {
            return this.cache(module, BundlerGemsProvider.findDirForBundler8(module, bundleConfigGemsDir));
        }
        VirtualFile gemsDir = (VirtualFile)ReadAction.compute(() -> {
            RFile gemFile = BundlerUtil.getGemfilePsiFile(module);
            if (gemFile != null) {
                VirtualFile bundlerGemsDir = BundlerGemsProvider.getBundlerGemsDir(gemFile);
                return bundlerGemsDir != null ? BundlerGemsProvider.findDirForBundler8(module, bundlerGemsDir) : null;
            }
            return null;
        });
        if (gemsDir != null) {
            return this.cache(module, gemsDir);
        }
        return null;
    }

    @Nullable
    private static VirtualFile findDirForBundler8(Module module, @Nullable VirtualFile configGemsDir) {
        if (configGemsDir == null) {
            return null;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        String sdkType = JRubySdkUtil.isJRubySDK(sdk) ? "jruby" : "ruby";
        VirtualFile childDir = configGemsDir.findFileByRelativePath(sdkType + "/" + BundlerUtil.getGemSdkVersion(sdk));
        return childDir != null && childDir.findChild("gems") != null ? childDir : configGemsDir;
    }

    private VirtualFile cache(final Module module, VirtualFile gemsDir) {
        this.myCacheDirs.put(module, gemsDir);
        Disposer.register((Disposable)module, (Disposable)new Disposable(){

            public void dispose() {
                BundlerGemsProvider.this.myCacheDirs.remove(module);
            }
        });
        return gemsDir;
    }

    @Override
    @NotNull
    public Set<VirtualFile> invalidateCaches(@Nullable VirtualFile file) {
        HashSet<VirtualFile> invalidatedRoots = new HashSet<VirtualFile>();
        if (file != null && BundlerUtil.isGemfile(file)) {
            this.myCacheDirs.clear();
            invalidatedRoots.addAll(super.invalidateCaches(file.getParent()));
        }
        invalidatedRoots.addAll(super.invalidateCaches(file));
        HashSet<VirtualFile> hashSet = invalidatedRoots;
        if (hashSet == null) {
            BundlerGemsProvider.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Nullable
    private static VirtualFile getBundlerGemsDir(@NotNull RFile gemFile) {
        VirtualFile file;
        VirtualFile parent;
        if (gemFile == null) {
            BundlerGemsProvider.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = parent = (file = gemFile.getVirtualFile()) != null ? file.getParent() : null;
        if (parent == null) {
            return null;
        }
        for (RPsiElement statement : gemFile.getStatements()) {
            String path;
            VirtualFile gemDir;
            List args;
            RCall call;
            if (!(statement instanceof RCall) || !"bundle_path".equals((call = (RCall)statement).getCommand()) || (args = call.getArguments()).size() != 1 || (gemDir = (gemDir = parent.findFileByRelativePath(path = TextUtil.removeQuoting((String)((RPsiElement)args.get(0)).getText()))) != null ? gemDir : VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path))) == null) continue;
            return gemDir;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/gems/BundlerGemsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invalidateCaches";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/gems/BundlerGemsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBundlerGemsDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

