/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet.versions;

import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfigurationLowLevel;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;

public abstract class BaseRailsFrameworkDetector<F extends BaseRailsFacet>
extends FacetBasedFrameworkDetector<F, BaseRailsFacetConfiguration> {
    @NotNull
    public static final FileContentPattern ROUTES_FILE_PATTERN = (FileContentPattern)FileContentPattern.fileContent().withName("routes.rb").with((PatternCondition)new PatternCondition<FileContent>("rails app config file"){

        public boolean accepts(@NotNull FileContent content, ProcessingContext context) {
            if (content == null) {
                1.$$$reportNull$$$0(0);
            }
            return BaseRailsFrameworkDetector.isRailsAppBootFile(content.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFrameworkDetector$1", "accepts"));
        }
    });

    protected BaseRailsFrameworkDetector(String detectorId) {
        super(detectorId);
    }

    @NotNull
    public FileType getFileType() {
        RubyFileType rubyFileType = RubyFileType.RUBY;
        if (rubyFileType == null) {
            BaseRailsFrameworkDetector.$$$reportNull$$$0(0);
        }
        return rubyFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        FileContentPattern fileContentPattern = ROUTES_FILE_PATTERN;
        if (fileContentPattern == null) {
            BaseRailsFrameworkDetector.$$$reportNull$$$0(1);
        }
        return fileContentPattern;
    }

    private static boolean isRailsAppBootFile(@NotNull VirtualFile virtualFile) {
        VirtualFile configDir;
        if (virtualFile == null) {
            BaseRailsFrameworkDetector.$$$reportNull$$$0(2);
        }
        if ((configDir = virtualFile.getParent()) == null) {
            return false;
        }
        VirtualFile railsHome = configDir.getParent();
        return railsHome != null && RailsUtil.containsRailsApp(railsHome.getPath());
    }

    protected BaseRailsFacetConfiguration createConfiguration(Collection<? extends VirtualFile> files) {
        VirtualFile configDir = ((VirtualFile)ContainerUtil.getFirstItem(files)).getParent();
        assert (configDir != null);
        VirtualFile railsHomeDir = configDir.getParent();
        assert (railsHomeDir != null);
        BaseRailsFacetConfigurationLowLevel conf = (BaseRailsFacetConfigurationLowLevel)this.getFacetType().createDefaultConfiguration();
        conf.setRailsApplicationRootPath(railsHomeDir.getPath());
        return conf;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFrameworkDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitableFilePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFrameworkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRailsAppBootFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

