/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet.versions;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.FacetType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.AssetsRegistrationWatcher;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ImplicitSymbolHierarchy;
import org.jetbrains.plugins.ruby.rails.facet.BaseRailsFacetBuilder;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfigurationLowLevel;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.versions.RailsFacet;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public abstract class BaseRailsFacet
extends Facet<BaseRailsFacetConfiguration> {
    private Ref<String> myProjectNameRef;
    private boolean initFacetHasBeenAlreadyInvoked;

    @NotNull
    public abstract String getDefaultRailsApplicationHomePath(ModuleRootModel var1);

    @Nullable
    public abstract Sdk getSdk(Module var1, @Nullable Facet var2);

    public BaseRailsFacet(@NotNull FacetType facetType, @NotNull Module module, @NotNull @NlsSafe String name, @NotNull BaseRailsFacetConfiguration configuration, Facet underlyingFacet, @Nullable Sdk rubySdk) {
        if (facetType == null) {
            BaseRailsFacet.$$$reportNull$$$0(0);
        }
        if (module == null) {
            BaseRailsFacet.$$$reportNull$$$0(1);
        }
        if (name == null) {
            BaseRailsFacet.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            BaseRailsFacet.$$$reportNull$$$0(3);
        }
        super(facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        BaseRailsFacetBuilder.constructOrInitFacetInstance(this, rubySdk, true);
    }

    public void initFacet() {
        if (this.initFacetHasBeenAlreadyInvoked) {
            return;
        }
        this.initFacetHasBeenAlreadyInvoked = true;
        final Module uncommitedModule = this.getModule();
        Sdk sdk = this.getSdk(uncommitedModule, this.getUnderlyingFacet());
        BaseRailsFacetBuilder.constructOrInitFacetInstance(this, sdk, false);
        ModuleRootListener moduleRootListener = new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                BaseRailsFacetConfigurationLowLevel conf;
                Sdk oldSDK;
                Sdk newSDK;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((newSDK = RModuleUtil.getInstance().findRubySdkForModule(uncommitedModule)) != (oldSDK = (conf = (BaseRailsFacetConfigurationLowLevel)BaseRailsFacet.this.getConfiguration()).getSdk())) {
                    conf.setSdk(newSDK);
                    BaseRailsFacet.this.resetProjectName();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFacet$1", "rootsChanged"));
            }
        };
        MessageBusConnection projectConnection = this.getModule().getProject().getMessageBus().connect((Disposable)this);
        projectConnection.subscribe(ModuleRootListener.TOPIC, (Object)moduleRootListener);
        AssetsRegistrationWatcher.getInstance(uncommitedModule).subscribe();
        projectConnection.subscribe(GemManager.MODULE_GEMS_CHANGED_TOPIC, (Object)new GemManager.ModuleGemsListener(){

            @Override
            public void gemsChanged(@NotNull Module module) {
                if (module == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (module == BaseRailsFacet.this.getModule()) {
                    SpringUtil.stopSpring(BaseRailsFacet.this.getModule(), false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFacet$2", "gemsChanged"));
            }
        });
        projectConnection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (module.equals(BaseRailsFacet.this.getModule())) {
                    SpringUtil.stopSpring(module, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFacet$3";
                objectArray[2] = "beforeModuleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        projectConnection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                SpringUtil.stopSpring(BaseRailsFacet.this.getModule(), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFacet$4", "projectClosing"));
            }
        });
        projectConnection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void beforeFacetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (facet.equals((Object)BaseRailsFacet.this) && facet.getModule() == BaseRailsFacet.this.getModule()) {
                    SpringUtil.stopSpring(BaseRailsFacet.this.getModule(), true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFacet$5", "beforeFacetRemoved"));
            }
        });
    }

    private void resetProjectName() {
        this.myProjectNameRef = null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static BaseRailsFacet getInstance(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return null;
        }
        return (BaseRailsFacet)FacetManager.getInstance((Module)module).getFacetByType(RailsFacet.ID);
    }

    @Nullable
    public String getProjectName() {
        if (this.myProjectNameRef == null) {
            this.myProjectNameRef = new Ref((Object)this.calculateProjectName());
        }
        return (String)this.myProjectNameRef.get();
    }

    @Nullable
    private String calculateProjectName() {
        Module appModule = this.getModule();
        RailsApp app = RailsApp.fromModule(appModule);
        if (app == null) {
            return null;
        }
        VirtualFile file = app.getApplicationFile();
        if (file == null) {
            return null;
        }
        Project project = appModule.getProject();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof RFile)) {
            return null;
        }
        RFile appFile = (RFile)psiFile;
        List<RModule> modules = RContainerUtil.getTopLevelModules((RContainer)appFile);
        boolean engine = app.isEngine();
        for (RModule module : modules) {
            GlobalSearchScope searchScope;
            RElementWithFQN clazz;
            if (RContainerUtilCore.findClassByName((RContainer)module, (String)(engine ? "Engine" : "Application")) != null) {
                return module.getName();
            }
            if (!engine || (clazz = (RElementWithFQN)ReadAction.compute(() -> BaseRailsFacet.lambda$calculateProjectName$1(project, (SearchScope)(searchScope = GlobalSearchScope.fileScope((PsiFile)psiFile))))) == null || !PsiTreeUtil.isAncestor((PsiElement)module, (PsiElement)clazz, (boolean)true)) continue;
            return module.getName();
        }
        return null;
    }

    @TestOnly
    public static void cleanupForNextText(Module module) {
        BaseRailsFacet facet = BaseRailsFacet.getInstance(module);
        if (facet != null) {
            facet.resetProjectName();
        }
    }

    @NotNull
    public ImplicitSymbolHierarchy getImplicitSymbolHierarchy() {
        Project project = this.getModule().getProject();
        Module module = this.getModule();
        ImplicitSymbolHierarchy implicitSymbolHierarchy = (ImplicitSymbolHierarchy)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ImplicitSymbolHierarchy hierarchy = BaseRailsFacet.computeModuleFqnsByDirectoryPaths(BaseRailsFacet.getRelativeAndAbsolutePathsOfImplicitModules(this.getImplicitModuleDirectoryRoots()), module);
            ArrayList dependencies = new ArrayList(RubyModificationTrackers.getRailsSettingsModificationTrackers(project, module));
            dependencies.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            return CachedValueProvider.Result.create((Object)hierarchy, dependencies);
        });
        if (implicitSymbolHierarchy == null) {
            BaseRailsFacet.$$$reportNull$$$0(4);
        }
        return implicitSymbolHierarchy;
    }

    @NotNull
    public List<VirtualFile> getImplicitModuleDirectoryRoots() {
        RailsPaths paths = RailsPaths.getInstance(this.getModule());
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        files.addAll(paths.findFiles("app/controllers"));
        files.addAll(paths.findFiles("app/models"));
        files.addAll(RailsPaths.getInstance(this.getModule()).findFiles("app", "services"));
        List<VirtualFile> list = Collections.unmodifiableList(files);
        if (list == null) {
            BaseRailsFacet.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static ImplicitSymbolHierarchy computeModuleFqnsByDirectoryPaths(@NotNull Set<Pair<String, String>> modulePaths, @Nullable Module module) {
        if (modulePaths == null) {
            BaseRailsFacet.$$$reportNull$$$0(6);
        }
        ImplicitSymbolHierarchy implicitSymbolHierarchy = ImplicitSymbolHierarchy.create(ContainerUtil.map(modulePaths, it -> Pair.create((Object)BaseRailsFacet.getModuleFQNFromDirectories(StringUtil.split((String)((String)it.first), (String)"/"), module), (Object)((String)it.second))));
        if (implicitSymbolHierarchy == null) {
            BaseRailsFacet.$$$reportNull$$$0(7);
        }
        return implicitSymbolHierarchy;
    }

    @NotNull
    private static FQN getModuleFQNFromDirectories(@NotNull List<String> directories, @Nullable Module module) {
        if (directories == null) {
            BaseRailsFacet.$$$reportNull$$$0(8);
        }
        FQN fQN = FQN.Builder.create((List)ContainerUtil.map(directories, name -> NamingConventions.toCamelCase((String)name, (Module)module)), (boolean)false);
        if (fQN == null) {
            BaseRailsFacet.$$$reportNull$$$0(9);
        }
        return fQN;
    }

    @RequiresReadLock
    @NotNull
    private static Set<Pair<String, String>> getRelativeAndAbsolutePathsOfImplicitModules(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            BaseRailsFacet.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.softAssertReadAccess();
        HashSet<Pair<String, String>> result = new HashSet<Pair<String, String>>();
        for (VirtualFile root : roots) {
            if (root == null) continue;
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)root, file -> {
                if (file.isDirectory()) {
                    result.add(Pair.create((Object)VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root), (Object)file.getPath()));
                }
                return true;
            });
        }
        HashSet<Pair<String, String>> hashSet = result;
        if (hashSet == null) {
            BaseRailsFacet.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private static /* synthetic */ RElementWithFQN lambda$calculateProjectName$1(Project project, SearchScope searchScope) throws RuntimeException {
        return (RElementWithFQN)RubyClassModuleNameIndex.getInstance().findElement(project, searchScope, "Engine", it -> it instanceof RContainer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFacet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePaths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/versions/BaseRailsFacet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitSymbolHierarchy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitModuleDirectoryRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeModuleFqnsByDirectoryPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFQNFromDirectories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeAndAbsolutePathsOfImplicitModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeModuleFqnsByDirectoryPaths";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModuleFQNFromDirectories";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeAndAbsolutePathsOfImplicitModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 9, 11 -> new IllegalStateException(string);
        };
    }
}

