/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPathsChangedListener;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

@State(name="RailsPaths", storages={@Storage(value="$MODULE_FILE$")})
public final class RailsPaths
implements Disposable.Default,
PersistentStateComponent<Element> {
    private static final Map<String, List<String>> DEFAULT_PATHS = Map.ofEntries(Map.entry("app", List.of("app")), Map.entry("app/assets", List.of("app/assets")), Map.entry("app/channels", List.of("app/channels")), Map.entry("app/controllers", List.of("app/controllers")), Map.entry("app/helpers", List.of("app/helpers")), Map.entry("app/mailers", List.of("app/mailers")), Map.entry("app/models", List.of("app/models")), Map.entry("app/views", List.of("app/views")), Map.entry("config", List.of("config")), Map.entry("config/cable", List.of("config/cable.yml")), Map.entry("config/database", List.of("config/database.yml")), Map.entry("config/environment", List.of("config/environment.rb")), Map.entry("config/environments", List.of("config/environments")), Map.entry("config/initializers", List.of("config/initializers")), Map.entry("config/locales", List.of("config/locales")), Map.entry("config/routes", List.of("config/routes")), Map.entry("config/routes.rb", List.of("config/routes.rb")), Map.entry("config/secrets", List.of("config")), Map.entry("db", List.of("db")), Map.entry("db/migrate", List.of("db/migrate")), Map.entry("db/seeds.rb", List.of("db/seeds.rb")), Map.entry("lib", List.of("lib")), Map.entry("lib/assets", List.of("lib/assets")), Map.entry("lib/tasks", List.of("lib/tasks")), Map.entry("lib/templates", List.of("lib/templates")), Map.entry("log", List.of("log/development.log")), Map.entry("public", List.of("public")), Map.entry("public/javascripts", List.of("public/javascripts")), Map.entry("public/stylesheets", List.of("public/stylesheets")), Map.entry("tmp", List.of("tmp")), Map.entry("vendor", List.of("vendor")), Map.entry("vendor/assets", List.of("vendor/assets")));
    private final Project myProject;
    private final Module myModule;
    private final Map<@NlsSafe String, List<String>> myUrls;
    private final AtomicBoolean myIsManagedAutomatically;

    public RailsPaths(@NotNull Module module) {
        if (module == null) {
            RailsPaths.$$$reportNull$$$0(0);
        }
        this.myUrls = Collections.synchronizedMap(new TreeMap());
        this.myIsManagedAutomatically = new AtomicBoolean(true);
        this.myProject = module.getProject();
        this.myModule = module;
    }

    public void clearUrls() {
        this.myUrls.clear();
    }

    @NotNull
    public List<VirtualFile> findFiles(@NotNull String key) {
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(1);
        }
        VirtualFileManager manager = VirtualFileManager.getInstance();
        List list = ContainerUtil.mapNotNull((Collection)this.myUrls.getOrDefault(key, Collections.emptyList()), arg_0 -> ((VirtualFileManager)manager).findFileByUrl(arg_0));
        if (list == null) {
            RailsPaths.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> findFiles(@NotNull String key, String ... paths) {
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(3);
        }
        if (paths == null) {
            RailsPaths.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.mapNotNull(this.findFiles(key), it -> it.findFileByRelativePath(String.join((CharSequence)"/", paths)));
        if (list == null) {
            RailsPaths.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> findFilesByAnyPath(@NotNull String key, String ... paths) {
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(6);
        }
        if (paths == null) {
            RailsPaths.$$$reportNull$$$0(7);
        }
        List<VirtualFile> list = this.findFiles(key).stream().flatMap(vFile -> Arrays.stream(paths).map(path -> vFile.findFileByRelativePath(path))).filter(Objects::nonNull).toList();
        if (list == null) {
            RailsPaths.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public String getRelativePath(@NotNull String key, @NotNull String url) {
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(9);
        }
        if (url == null) {
            RailsPaths.$$$reportNull$$$0(10);
        }
        for (String root : this.getUrls(key)) {
            if (!VfsUtilCore.isEqualOrAncestor((String)root, (String)url)) continue;
            return VirtualFileUtil.getRelativePath(url, root);
        }
        return null;
    }

    @NotNull
    public Element getState() {
        Element paths = new Element("paths");
        if (this.myUrls.isEmpty()) {
            Element element = paths;
            if (element == null) {
                RailsPaths.$$$reportNull$$$0(11);
            }
            return element;
        }
        paths.setAttribute("isManagedAutomatically", Boolean.toString(this.myIsManagedAutomatically.get()));
        this.myUrls.forEach((key, value) -> {
            Element entry = new Element("entry").setAttribute("key", key);
            value.forEach(it -> entry.addContent(new Element("value").addContent(it)));
            paths.addContent(entry);
        });
        Element element = paths;
        if (element == null) {
            RailsPaths.$$$reportNull$$$0(12);
        }
        return element;
    }

    public @NotNull Map<@NlsSafe String, List<String>> getUrls() {
        Map<String, List<String>> map = Collections.unmodifiableMap(this.myUrls);
        if (map == null) {
            RailsPaths.$$$reportNull$$$0(13);
        }
        return map;
    }

    @NotNull
    public List<String> getUrls(@NotNull String key) {
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(14);
        }
        List<String> list = this.myUrls.getOrDefault(key, Collections.emptyList());
        if (list == null) {
            RailsPaths.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public List<String> getUrls(@NotNull String key, String ... paths) {
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(16);
        }
        if (paths == null) {
            RailsPaths.$$$reportNull$$$0(17);
        }
        List list = ContainerUtil.map(this.getUrls(key), it -> "%s/%s".formatted(it, String.join((CharSequence)"/", paths)));
        if (list == null) {
            RailsPaths.$$$reportNull$$$0(18);
        }
        return list;
    }

    public boolean isManagedAutomatically() {
        return this.myIsManagedAutomatically.get();
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            RailsPaths.$$$reportNull$$$0(19);
        }
        String isManagedAutomatically = state.getAttributeValue("isManagedAutomatically");
        TreeMap<String, List> urls = new TreeMap<String, List>();
        for (Element child : state.getChildren("entry")) {
            List paths = ContainerUtil.mapNotNull((Collection)child.getContent(), Content::getValue);
            urls.put(child.getAttributeValue("key"), paths);
        }
        this.myIsManagedAutomatically.set(isManagedAutomatically != null ? "true".equals(isManagedAutomatically) : urls.equals(RailsPaths.getDefaultUrls(this.myModule)));
        this.setUrls(urls);
    }

    public void noStateLoaded() {
        this.myUrls.putAll(RailsPaths.getDefaultUrls(this.myModule));
    }

    public void putUrls(@NotNull String key, @NotNull List<String> urls) {
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(20);
        }
        if (urls == null) {
            RailsPaths.$$$reportNull$$$0(21);
        }
        this.myUrls.put(key, List.copyOf(urls));
        ((RailsPathsChangedListener)this.myProject.getMessageBus().syncPublisher(RailsPathsChangedListener.TOPIC)).onPathsChanged(this.myModule);
    }

    public void setManagedAutomatically(boolean isManagedAutomatically) {
        this.myIsManagedAutomatically.set(isManagedAutomatically);
    }

    public void setUrls(@NotNull Map<String, ? extends Collection<String>> urls) {
        if (urls == null) {
            RailsPaths.$$$reportNull$$$0(22);
        }
        this.myUrls.clear();
        urls.forEach((key, value) -> this.myUrls.put((String)key, List.copyOf(value)));
        ((RailsPathsChangedListener)this.myProject.getMessageBus().syncPublisher(RailsPathsChangedListener.TOPIC)).onPathsChanged(this.myModule);
    }

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    public static VirtualFile findDefaultFile(@NotNull Module module, @NotNull String key) {
        if (module == null) {
            RailsPaths.$$$reportNull$$$0(23);
        }
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(24);
        }
        return (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsFacetUtil.getRailsAppHomeDir(module), root -> root.findFileByRelativePath(Objects.requireNonNull((String)ContainerUtil.getOnlyItem((Collection)DEFAULT_PATHS.get(key)))));
    }

    @Deprecated
    @Nullable
    public static VirtualFile findDefaultFile(@NotNull Module module, @NotNull String key, String ... paths) {
        if (module == null) {
            RailsPaths.$$$reportNull$$$0(25);
        }
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(26);
        }
        if (paths == null) {
            RailsPaths.$$$reportNull$$$0(27);
        }
        return (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsFacetUtil.getRailsAppHomeDir(module), root -> root.findFileByRelativePath(Objects.requireNonNull((String)ContainerUtil.getOnlyItem((Collection)DEFAULT_PATHS.get(key))) + "/" + String.join((CharSequence)"/", paths)));
    }

    public static @NotNull Map<@NlsSafe String, List<String>> getDefaultPaths() {
        Map<String, List<String>> map = DEFAULT_PATHS;
        if (map == null) {
            RailsPaths.$$$reportNull$$$0(28);
        }
        return map;
    }

    @Deprecated
    @NotNull
    public static String getDefaultUrl(@NotNull Module module, @NotNull String key) {
        if (module == null) {
            RailsPaths.$$$reportNull$$$0(29);
        }
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(30);
        }
        String root = Objects.requireNonNull(RailsFacetUtil.getRailsAppHomeDirUrl(module));
        String path = Objects.requireNonNull((String)ContainerUtil.getOnlyItem((Collection)DEFAULT_PATHS.get(key)));
        String string = "%s/%s".formatted(root, path);
        if (string == null) {
            RailsPaths.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public static String getDefaultUrl(@NotNull Module module, @NotNull String key, String ... paths) {
        if (module == null) {
            RailsPaths.$$$reportNull$$$0(32);
        }
        if (key == null) {
            RailsPaths.$$$reportNull$$$0(33);
        }
        if (paths == null) {
            RailsPaths.$$$reportNull$$$0(34);
        }
        String root = Objects.requireNonNull(RailsFacetUtil.getRailsAppHomeDirUrl(module));
        String path = Objects.requireNonNull((String)ContainerUtil.getOnlyItem((Collection)DEFAULT_PATHS.get(key)));
        String string = "%s/%s/%s".formatted(root, path, String.join((CharSequence)"/", paths));
        if (string == null) {
            RailsPaths.$$$reportNull$$$0(35);
        }
        return string;
    }

    public static @NotNull Map<@NlsSafe String, List<String>> getDefaultUrls(@NotNull Module module) {
        String root;
        if (module == null) {
            RailsPaths.$$$reportNull$$$0(36);
        }
        if ((root = RailsFacetUtil.getRailsAppHomeDirUrl(module)) == null) {
            Map<String, List<String>> map = Collections.emptyMap();
            if (map == null) {
                RailsPaths.$$$reportNull$$$0(37);
            }
            return map;
        }
        TreeMap<String, List> urls = new TreeMap<String, List>();
        for (Map.Entry<String, List<String>> entry : DEFAULT_PATHS.entrySet()) {
            urls.put(entry.getKey(), ContainerUtil.map((Collection)entry.getValue(), it -> "%s/%s".formatted(root, it)));
        }
        Map<String, List<String>> map = Collections.unmodifiableMap(urls);
        if (map == null) {
            RailsPaths.$$$reportNull$$$0(38);
        }
        return map;
    }

    @NotNull
    public static RailsPaths getInstance(@NotNull Module module) {
        if (module == null) {
            RailsPaths.$$$reportNull$$$0(39);
        }
        RailsPaths railsPaths = (RailsPaths)module.getService(RailsPaths.class);
        if (railsPaths == null) {
            RailsPaths.$$$reportNull$$$0(40);
        }
        return railsPaths;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 11, 12, 13, 15, 18, 28, 31, 35, 37, 38, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 16: 
            case 20: 
            case 24: 
            case 26: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/facet/configuration/RailsPaths";
                break;
            }
            case 4: 
            case 7: 
            case 17: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/configuration/RailsPaths";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesByAnyPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPaths";
                break;
            }
            case 31: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUrl";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUrls";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFiles";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFilesByAnyPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putUrls";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultFile";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultUrl";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultUrls";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 11, 12, 13, 15, 18, 28, 31, 35, 37, 38, 40 -> new IllegalStateException(string);
        };
    }
}

