/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.devise;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;

public final class DeviseForCallType
extends RubyCallTypeBase<DeviseData> {
    DeviseForCallType() {
        super("devise_for");
    }

    @NotNull
    public DeviseData getCallData(@NotNull RPossibleCall call) {
        if (call == null) {
            DeviseForCallType.$$$reportNull$$$0(0);
        }
        String pluralModelName = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)ContainerUtil.getFirstItem((List)call.getArguments()));
        String className = RubyInterpretUtil.evaluateOptionValue(call, "class_name");
        String singularName = RubyInterpretUtil.evaluateOptionValue(call, "singular");
        List<String> namespaces = DeviseForCallType.evaluateNamespaces(call);
        return new DeviseData(pluralModelName, className, singularName, (List)ObjectUtils.coalesce(namespaces, Collections.emptyList()));
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean isCompatible(@NotNull RPossibleCall possibleCall) {
        if (possibleCall == null) {
            DeviseForCallType.$$$reportNull$$$0(1);
        }
        return !possibleCall.getArguments().isEmpty();
    }

    public boolean process(@NotNull Processor<? super Symbol> processor, @NotNull Symbol parent, @NotNull RCall call, @Nullable PsiElement invocationPoint) {
        if (processor == null) {
            DeviseForCallType.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            DeviseForCallType.$$$reportNull$$$0(3);
        }
        if (call == null) {
            DeviseForCallType.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    private static List<String> evaluateNamespaces(@NotNull RPossibleCall call) {
        if (call == null) {
            DeviseForCallType.$$$reportNull$$$0(5);
        }
        ArrayList<String> namespaceList = new ArrayList<String>();
        RPossibleCall currentCall = (RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)call.getParent(), RPossibleCall.class, (boolean)false);
        while (currentCall != null) {
            ProgressManager.checkCanceled();
            if (currentCall.getCommand() != null && currentCall.getCommand().equals("namespace")) {
                String namespace = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)ContainerUtil.getFirstItem((List)currentCall.getArguments()));
                namespaceList.add((String)ObjectUtils.coalesce((Object)namespace, (Object)""));
            }
            currentCall = (RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)currentCall.getParent(), RPossibleCall.class, (boolean)false);
        }
        ArrayList<String> arrayList = namespaceList;
        if (arrayList == null) {
            DeviseForCallType.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/devise/DeviseForCallType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/devise/DeviseForCallType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCallData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNamespaces";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static final class DeviseData {
        @Nullable
        final String myPluralModelName;
        @Nullable
        final String myClassName;
        @Nullable
        final String mySingularModelName;
        final List<String> myNamespaces;

        DeviseData(@Nullable String pluralModelName, @Nullable String className, @Nullable String singularModelName, @NotNull List<String> namespaces) {
            if (namespaces == null) {
                DeviseData.$$$reportNull$$$0(0);
            }
            this.myPluralModelName = pluralModelName;
            this.myClassName = className;
            this.mySingularModelName = singularModelName;
            this.myNamespaces = Collections.unmodifiableList(new ArrayList<String>(namespaces));
        }

        @Nullable
        public String getSingularModelName(@Nullable Module module) {
            if (this.mySingularModelName != null) {
                return this.mySingularModelName;
            }
            if (module != null) {
                InflectorService inflectorService = InflectorService.getInstance(module);
                return inflectorService.singularize(this.myPluralModelName);
            }
            if (this.myPluralModelName != null) {
                return StringUtil.unpluralize((String)this.myPluralModelName);
            }
            return null;
        }

        @Nullable
        public String getClassifiedModelName(@Nullable Module module) {
            if (this.myClassName != null) {
                return this.myClassName;
            }
            if (module != null) {
                InflectorService inflectorService = InflectorService.getInstance(module);
                return inflectorService.classify(this.myPluralModelName);
            }
            return (String)ObjectUtils.doIfNotNull((Object)this.getNestedSingularModelName(null), StringUtil::capitalize);
        }

        @Nullable
        public String getNestedSingularModelName(@Nullable Module module) {
            String singularName = this.getSingularModelName(module);
            if (singularName == null) {
                return null;
            }
            String concatenatedNamespaces = this.getConcatenatedNamespaces();
            if (concatenatedNamespaces.isEmpty()) {
                return singularName;
            }
            return this.getConcatenatedNamespaces() + "_" + singularName;
        }

        @Nullable
        public String getPluralModelName() {
            return this.myPluralModelName;
        }

        @Nullable
        public RType getModelType(@NotNull Project project, @NotNull Module module) {
            if (project == null) {
                DeviseData.$$$reportNull$$$0(1);
            }
            if (module == null) {
                DeviseData.$$$reportNull$$$0(2);
            }
            return (RType)ObjectUtils.doIfNotNull((Object)this.getClassifiedModelName(module), classifiedModelName -> RTypeFactory.createTypeByFQN(project, classifiedModelName));
        }

        @NotNull
        public List<String> getNamespaces() {
            List<String> list = this.myNamespaces;
            if (list == null) {
                DeviseData.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public String getConcatenatedNamespaces() {
            String string = String.join((CharSequence)"_", this.myNamespaces);
            if (string == null) {
                DeviseData.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaces";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/devise/DeviseForCallType$DeviseData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/devise/DeviseForCallType$DeviseData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaces";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcatenatedNamespaces";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getModelType";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

